/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.mixin;

import com.github.razorplay01.cpa.platform.common.util.MapRenderer;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ExtendedItemStackRenderState;
import com.github.razorplay01.cpa.platform.common.util.interfaces.HumanoidRenderStateAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public abstract class ItemInHandLayerMixin<S extends ArmedEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    protected ItemInHandLayerMixin(RenderLayerParent<S, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(method={"submitArmWithItem(Lnet/minecraft/client/renderer/entity/state/ArmedEntityRenderState;Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderArmWithItem(S armedEntityRenderState, ItemStackRenderState itemStackRenderState, HumanoidArm humanoidArm, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, CallbackInfo ci) {
        ExtendedItemStackRenderState ext;
        if (!(armedEntityRenderState instanceof AvatarRenderState)) {
            return;
        }
        AvatarRenderState playerRenderState = (AvatarRenderState)armedEntityRenderState;
        LivingEntity livingEntity = ((HumanoidRenderStateAccessor)playerRenderState).getLivingEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = null;
        if (!(itemStackRenderState instanceof ExtendedItemStackRenderState) || (ext = (ExtendedItemStackRenderState)itemStackRenderState).getItemStack() == null) {
            return;
        }
        itemStack = ext.getItemStack();
        this.onRenderItem((LivingEntity)player, (EntityModel<?>)this.getParentModel(), itemStack, humanoidArm, poseStack, submitNodeCollector, (LivingEntityRenderState)armedEntityRenderState, i, ci);
    }

    @Unique
    public void onRenderItem(LivingEntity entity, EntityModel<?> model, ItemStack itemStack, HumanoidArm arm, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, LivingEntityRenderState livingEntityRenderState, int light, CallbackInfo info) {
        ItemStack heldItem;
        if (!(model instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel humanoid = (HumanoidModel)model;
        if (!this.isArmVisible(humanoid, arm)) {
            return;
        }
        boolean isMainHand = arm == entity.getMainArm();
        ItemStack itemStack2 = heldItem = isMainHand ? entity.getMainHandItem() : entity.getOffhandItem();
        if (heldItem.getItem().equals(Items.FILLED_MAP)) {
            this.renderMapInHand(entity, humanoid, itemStack, arm, poseStack, submitNodeCollector, livingEntityRenderState, light, info);
            info.cancel();
        }
    }

    @Unique
    private boolean isArmVisible(HumanoidModel<?> humanoid, HumanoidArm arm) {
        return arm == HumanoidArm.RIGHT && humanoid.rightArm.visible || arm == HumanoidArm.LEFT && humanoid.leftArm.visible;
    }

    @Unique
    private void renderMapInHand(LivingEntity entity, HumanoidModel<?> humanoid, ItemStack itemStack, HumanoidArm arm, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, LivingEntityRenderState livingEntityRenderState, int light, CallbackInfo info) {
        poseStack.pushPose();
        humanoid.translateToHand((HumanoidRenderState)livingEntityRenderState, arm, poseStack);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(200.0f));
        boolean isLeftHand = arm == HumanoidArm.LEFT;
        poseStack.translate((double)((float)(isLeftHand ? -1 : 1) / 16.0f), 0.125, -0.625);
        MapRenderer.renderFirstPersonMap(poseStack, submitNodeCollector, light, itemStack, !entity.getOffhandItem().isEmpty(), entity.getMainArm() == HumanoidArm.LEFT);
        poseStack.popPose();
    }
}

