/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.overlay;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.Modifiers;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;

public class SwordAnimation
implements ICustomAnimation {
    private final Map<UUID, Integer> comboCounts = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastSwingTicks = new HashMap<UUID, Long>();
    private final int COMBO_RESET_TICKS = 50;
    private final Map<UUID, Boolean> animationsInProgress = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> animationStartTimes = new HashMap<UUID, Long>();
    private final Map<UUID, Float> animationDurations = new HashMap<UUID, Float>();

    @Override
    public void playAnimation(AnimationContext context) {
        UUID uuid = context.player().getUUID();
        if (!ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.isEnabled()) {
            context.overlayAnimationContainer().disableAnimation();
            this.animationsInProgress.put(uuid, false);
        } else if (SwordAnimation.isPlayerSwingingWeapon(context.player())) {
            this.animationStartTimes.put(uuid, context.player().level().getGameTime());
            this.animationsInProgress.put(uuid, true);
            this.handleSwordComboAnimation(context);
            if (context.overlayAnimationContainer().getCurrentAnimation() != null) {
                this.animationDurations.put(uuid, Float.valueOf(context.overlayAnimationContainer().getCurrentAnimation().length() - 5.0f));
            }
        } else if (Boolean.TRUE.equals(this.animationsInProgress.getOrDefault(uuid, false))) {
            long currentTime = context.player().level().getGameTime();
            if ((float)(currentTime - this.animationStartTimes.getOrDefault(uuid, 0L)) < this.animationDurations.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue()) {
                this.handleSwordComboAnimation(context);
            } else {
                this.animationsInProgress.put(uuid, false);
            }
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        UUID uuid = context.player().getUUID();
        return (SwordAnimation.isPlayerSwingingWeapon(context.player()) || Boolean.TRUE.equals(this.animationsInProgress.getOrDefault(uuid, false))) && !context.mainAnimationContainer().getCurrentAnimationId().equalsIgnoreCase(AnimationsId.SLEEP_ANIMATION.getAnimationId());
    }

    private void handleSwordComboAnimation(AnimationContext context) {
        UUID uuid = context.player().getUUID();
        long currentTick = context.player().level().getGameTime();
        this.comboCounts.putIfAbsent(uuid, 0);
        this.lastSwingTicks.putIfAbsent(uuid, 0L);
        if (currentTick - this.lastSwingTicks.get(uuid) > 50L) {
            this.comboCounts.put(uuid, 0);
        }
        if (context.overlayAnimationContainer().getAnimationController().getCurrentAnimation() != null) {
            if (context.overlayAnimationContainer().getAnimationController().isActive() && context.overlayAnimationContainer().getAnimationController().getCurrentAnimation().animation() == ModTemplate.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId())) {
                this.comboCounts.compute(uuid, (k, currentCount) -> currentCount % 3 + 1);
            }
            this.lastSwingTicks.put(uuid, currentTick);
            int currentCombo = this.comboCounts.get(uuid);
            switch (currentCombo) {
                case 2: {
                    context.overlayAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getPriority());
                    break;
                }
                case 3: {
                    context.overlayAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getPriority());
                    break;
                }
                default: {
                    context.overlayAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getPriority());
                }
            }
            this.selectComboAnimation(context);
            ((MirrorModifier)context.overlayAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = context.playerData().getRightHand() != InteractionHand.MAIN_HAND;
        }
    }

    private void selectComboAnimation(AnimationContext context) {
        boolean isSneaking = context.player().isCrouching();
        UUID uuid = context.player().getUUID();
        int currentCombo = this.comboCounts.getOrDefault(uuid, 1);
        switch (currentCombo) {
            case 1: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? ModTemplate.getAnimation(AnimationsId.SWORD_ATTACK_1_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.SWORD_ATTACK_1_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_1_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_1_ANIMATION.getAnimationId());
                break;
            }
            case 2: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? ModTemplate.getAnimation(AnimationsId.SWORD_ATTACK_2_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.SWORD_ATTACK_2_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_2_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_2_ANIMATION.getAnimationId());
                break;
            }
            default: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? ModTemplate.getAnimation(AnimationsId.SWORD_ATTACK_3_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.SWORD_ATTACK_3_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_3_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_3_ANIMATION.getAnimationId());
            }
        }
    }

    public static boolean isPlayerSwingingWeapon(Avatar player) {
        ItemStack itemStack = player.getMainHandItem();
        if (Util.isAxe(itemStack) || Util.isPickaxe(itemStack) || Util.isShovel(itemStack)) {
            return false;
        }
        return player.swinging && (Util.isSword(itemStack) || itemStack.getItem() instanceof TridentItem) && player.swingingArm.equals((Object)InteractionHand.MAIN_HAND);
    }
}

