/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Quaternionfc;

public class MapRenderer {
    private static final RenderType MAP_BACKGROUND = RenderType.text((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/map/map_background.png"));
    private static final RenderType MAP_BACKGROUND_CHECKERBOARD = RenderType.text((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/map/map_background_checkerboard.png"));

    private MapRenderer() {
    }

    public static void renderFirstPersonMap(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light, ItemStack stack, boolean small, boolean leftHanded) {
        Minecraft client = Minecraft.getInstance();
        if (small) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(160.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            poseStack.scale(0.38f, 0.38f, 0.38f);
            poseStack.translate(-0.1, -1.2, 0.0);
            poseStack.scale(0.0098125f, 0.0098125f, 0.0098125f);
        } else {
            if (leftHanded) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(154.5f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(166.5f));
                poseStack.scale(0.38f, 0.38f, 0.38f);
                poseStack.translate(0.585, -1.225, 0.15);
            } else {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(155.0f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(213.5f));
                poseStack.scale(0.38f, 0.38f, 0.38f);
                poseStack.translate(-0.955, -1.8, 0.0);
            }
            poseStack.scale(0.0138125f, 0.0138125f, 0.0138125f);
        }
        MapId mapid = (MapId)stack.get(DataComponents.MAP_ID);
        MapItemSavedData mapState = MapItem.getSavedData((ItemStack)stack, (Level)client.level);
        RenderType renderType = mapState == null ? MAP_BACKGROUND : MAP_BACKGROUND_CHECKERBOARD;
        submitNodeCollector.submitCustomGeometry(poseStack, renderType, (pose, vertexConsumer) -> {
            vertexConsumer.addVertex(pose, -7.0f, 135.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(light);
            vertexConsumer.addVertex(pose, 135.0f, 135.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(light);
            vertexConsumer.addVertex(pose, 135.0f, -7.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(light);
            vertexConsumer.addVertex(pose, -7.0f, -7.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(light);
        });
        submitNodeCollector.submitCustomGeometry(poseStack, MAP_BACKGROUND, (pose, vertexConsumer) -> {
            vertexConsumer.addVertex(pose, -7.0f, -7.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(light);
            vertexConsumer.addVertex(pose, 135.0f, -7.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(light);
            vertexConsumer.addVertex(pose, 135.0f, 135.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(light);
            vertexConsumer.addVertex(pose, -7.0f, 135.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(light);
        });
        if (mapState != null) {
            MapRenderState mapRenderState = new MapRenderState();
            client.getMapRenderer().extractRenderState(mapid, mapState, mapRenderState);
            client.getMapRenderer().render(mapRenderState, poseStack, submitNodeCollector, false, light);
        }
    }
}

