/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.util;

import lombok.Generated;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlayerData {
    private Vec3 playerPosition;
    private Vec3 prevPlayerPosition = new Vec3(0.0, 0.0, 0.0);
    private double movementSpeed = 0.0;
    private float playerHeadYaw = 0.0f;
    private float playerBodyYaw = 0.0f;
    private float prevPlayerBodyYaw = 0.0f;
    private float bodyYawDelta = 0.0f;
    private float vectorX = 0.0f;
    private float vectorY = 0.0f;
    private float vectorZ = 0.0f;
    private int flychecker = 0;
    private boolean isMovingBackwards = false;
    private boolean isOnFence = false;
    private boolean isOnEdge = false;
    private boolean prevOnGround = false;
    private InteractionHand rightHand = InteractionHand.MAIN_HAND;
    private InteractionHand leftHand = InteractionHand.OFF_HAND;
    private HumanoidModel.ArmPose mainArmPose = HumanoidModel.ArmPose.EMPTY;
    private HumanoidModel.ArmPose offArmPose = HumanoidModel.ArmPose.EMPTY;
    private ItemStack mainHandItem = ItemStack.EMPTY;
    private ItemStack offHandItem = ItemStack.EMPTY;
    private int movementTicks;
    private boolean prevMainHandUp = false;
    private boolean prevOffHandUp = false;

    public void update(Avatar player) {
        if (player == null) {
            return;
        }
        this.updateHandOrientation(player.getMainArm());
        this.updatePlayerPosition(player.getYHeadRot(), player.getVisualRotationYInDegrees(), player.position());
        this.updateMovementInfo(player.yBodyRot);
        this.updateEnvironmentInfo(player);
        this.updateFlyChecker(player);
        this.updateMovementTicks(player);
    }

    private void updateMovementTicks(Avatar player) {
        if (this.getMovementSpeed() > 0.0 && !this.isMovingBackwards() && !player.isCrouching() && !player.isPassenger()) {
            this.setMovementTicks(this.getMovementTicks() + 1);
        } else {
            this.setMovementTicks(0);
        }
    }

    private void updateHandOrientation(HumanoidArm mainHand) {
        if (mainHand == HumanoidArm.RIGHT) {
            this.setRightHand(InteractionHand.MAIN_HAND);
            this.setLeftHand(InteractionHand.OFF_HAND);
        } else {
            this.setRightHand(InteractionHand.OFF_HAND);
            this.setLeftHand(InteractionHand.MAIN_HAND);
        }
    }

    private void updatePlayerPosition(float headYRot, float visualRotationYInDegress, Vec3 playerPosition) {
        this.setPlayerBodyYaw(visualRotationYInDegress);
        this.setPlayerHeadYaw(headYRot);
        this.setPlayerPosition(playerPosition);
        this.setVectorX((float)(this.getPlayerPosition().x - this.getPrevPlayerPosition().x));
        this.setVectorY((float)(this.getPlayerPosition().y - this.getPrevPlayerPosition().y));
        this.setVectorZ((float)(this.getPlayerPosition().z - this.getPrevPlayerPosition().z));
        this.setMovementSpeed(Math.sqrt(this.getVectorX() * this.getVectorX() + this.getVectorZ() * this.getVectorZ()));
        this.setBodyYawDelta(this.getPlayerBodyYaw() - this.getPrevPlayerBodyYaw());
    }

    private void updateMovementInfo(float yBodyRot) {
        double bodyYawRadians = Math.toRadians(yBodyRot + 90.0f);
        Vector3f movementVector = new Vector3f(this.getVectorX(), 0.0f, this.getVectorZ());
        Vector3f lookVector = new Vector3f((float)Math.cos(bodyYawRadians), 0.0f, (float)Math.sin(bodyYawRadians));
        this.setMovingBackwards(movementVector.length() > 0.0f && movementVector.dot((Vector3fc)lookVector) < 0.0f);
    }

    private void updateEnvironmentInfo(Avatar player) {
        Block standingBlock = player.level().getBlockState(player.blockPosition().below()).getBlock();
        this.setOnFence((standingBlock instanceof FenceBlock || standingBlock instanceof WallBlock || standingBlock instanceof IronBarsBlock) && player.onGround());
        this.setOnEdge(standingBlock instanceof AirBlock && player.onGround());
    }

    private void updateFlyChecker(Avatar player) {
        double flyVectorY = (double)Math.round((double)this.getVectorY() * 1000.0) / 1000.0;
        if (!(flyVectorY != 0.0 && Math.abs(flyVectorY) != 0.375 || player.onGround() || player.isUnderWater())) {
            this.setFlychecker(this.getFlychecker() + 1);
        } else if (Math.abs(flyVectorY) > 0.375 || player.onGround()) {
            this.setFlychecker(0);
        }
    }

    public boolean getPrevMainHandUp() {
        return this.prevMainHandUp;
    }

    public boolean getPrevOffHandUp() {
        return this.prevOffHandUp;
    }

    @Generated
    public Vec3 getPlayerPosition() {
        return this.playerPosition;
    }

    @Generated
    public Vec3 getPrevPlayerPosition() {
        return this.prevPlayerPosition;
    }

    @Generated
    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    @Generated
    public float getPlayerHeadYaw() {
        return this.playerHeadYaw;
    }

    @Generated
    public float getPlayerBodyYaw() {
        return this.playerBodyYaw;
    }

    @Generated
    public float getPrevPlayerBodyYaw() {
        return this.prevPlayerBodyYaw;
    }

    @Generated
    public float getBodyYawDelta() {
        return this.bodyYawDelta;
    }

    @Generated
    public float getVectorX() {
        return this.vectorX;
    }

    @Generated
    public float getVectorY() {
        return this.vectorY;
    }

    @Generated
    public float getVectorZ() {
        return this.vectorZ;
    }

    @Generated
    public int getFlychecker() {
        return this.flychecker;
    }

    @Generated
    public boolean isMovingBackwards() {
        return this.isMovingBackwards;
    }

    @Generated
    public boolean isOnFence() {
        return this.isOnFence;
    }

    @Generated
    public boolean isOnEdge() {
        return this.isOnEdge;
    }

    @Generated
    public boolean isPrevOnGround() {
        return this.prevOnGround;
    }

    @Generated
    public InteractionHand getRightHand() {
        return this.rightHand;
    }

    @Generated
    public InteractionHand getLeftHand() {
        return this.leftHand;
    }

    @Generated
    public HumanoidModel.ArmPose getMainArmPose() {
        return this.mainArmPose;
    }

    @Generated
    public HumanoidModel.ArmPose getOffArmPose() {
        return this.offArmPose;
    }

    @Generated
    public ItemStack getMainHandItem() {
        return this.mainHandItem;
    }

    @Generated
    public ItemStack getOffHandItem() {
        return this.offHandItem;
    }

    @Generated
    public int getMovementTicks() {
        return this.movementTicks;
    }

    @Generated
    public void setPlayerPosition(Vec3 playerPosition) {
        this.playerPosition = playerPosition;
    }

    @Generated
    public void setPrevPlayerPosition(Vec3 prevPlayerPosition) {
        this.prevPlayerPosition = prevPlayerPosition;
    }

    @Generated
    public void setMovementSpeed(double movementSpeed) {
        this.movementSpeed = movementSpeed;
    }

    @Generated
    public void setPlayerHeadYaw(float playerHeadYaw) {
        this.playerHeadYaw = playerHeadYaw;
    }

    @Generated
    public void setPlayerBodyYaw(float playerBodyYaw) {
        this.playerBodyYaw = playerBodyYaw;
    }

    @Generated
    public void setPrevPlayerBodyYaw(float prevPlayerBodyYaw) {
        this.prevPlayerBodyYaw = prevPlayerBodyYaw;
    }

    @Generated
    public void setBodyYawDelta(float bodyYawDelta) {
        this.bodyYawDelta = bodyYawDelta;
    }

    @Generated
    public void setVectorX(float vectorX) {
        this.vectorX = vectorX;
    }

    @Generated
    public void setVectorY(float vectorY) {
        this.vectorY = vectorY;
    }

    @Generated
    public void setVectorZ(float vectorZ) {
        this.vectorZ = vectorZ;
    }

    @Generated
    public void setFlychecker(int flychecker) {
        this.flychecker = flychecker;
    }

    @Generated
    public void setMovingBackwards(boolean isMovingBackwards) {
        this.isMovingBackwards = isMovingBackwards;
    }

    @Generated
    public void setOnFence(boolean isOnFence) {
        this.isOnFence = isOnFence;
    }

    @Generated
    public void setOnEdge(boolean isOnEdge) {
        this.isOnEdge = isOnEdge;
    }

    @Generated
    public void setPrevOnGround(boolean prevOnGround) {
        this.prevOnGround = prevOnGround;
    }

    @Generated
    public void setRightHand(InteractionHand rightHand) {
        this.rightHand = rightHand;
    }

    @Generated
    public void setLeftHand(InteractionHand leftHand) {
        this.leftHand = leftHand;
    }

    @Generated
    public void setMainArmPose(HumanoidModel.ArmPose mainArmPose) {
        this.mainArmPose = mainArmPose;
    }

    @Generated
    public void setOffArmPose(HumanoidModel.ArmPose offArmPose) {
        this.offArmPose = offArmPose;
    }

    @Generated
    public void setMainHandItem(ItemStack mainHandItem) {
        this.mainHandItem = mainHandItem;
    }

    @Generated
    public void setOffHandItem(ItemStack offHandItem) {
        this.offHandItem = offHandItem;
    }

    @Generated
    public void setMovementTicks(int movementTicks) {
        this.movementTicks = movementTicks;
    }

    @Generated
    public void setPrevMainHandUp(boolean prevMainHandUp) {
        this.prevMainHandUp = prevMainHandUp;
    }

    @Generated
    public void setPrevOffHandUp(boolean prevOffHandUp) {
        this.prevOffHandUp = prevOffHandUp;
    }

    @Generated
    public PlayerData() {
    }
}

