/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.class_1282;
import net.minecraft.class_8111;

public class DeathAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!ModTemplate.CONFIG.getMainAnimations().deathAnimations.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
        } else {
            String animationId = this.getDeathAnimationId(context);
            DeathAnimation.configureAnimationContainer(context, animationId);
            context.mainAnimationContainer().setCurrentAnimation(ModTemplate.getAnimation(animationId));
            context.mainAnimationContainer().setCurrentAnimationId(animationId);
        }
    }

    private static void configureAnimationContainer(AnimationContext context, String animationId) {
        switch (animationId) {
            case "death_burn": {
                context.mainAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig.getFadeTime());
                context.mainAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig.getPriority());
                break;
            }
            case "death_explosion": {
                context.mainAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig.getFadeTime());
                context.mainAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig.getPriority());
                break;
            }
            case "death_drown": {
                context.mainAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig.getFadeTime());
                context.mainAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig.getPriority());
                break;
            }
            default: {
                context.mainAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getMainAnimations().deathAnimations.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getMainAnimations().deathAnimations.getFadeTime());
                context.mainAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getMainAnimations().deathAnimations.getPriority());
            }
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.player().method_6032() <= 0.0f;
    }

    private String getDeathAnimationId(AnimationContext context) {
        class_1282 lastDamageSource = context.player().method_6081();
        if (lastDamageSource != null) {
            if (lastDamageSource.method_49708(class_8111.field_42335) || lastDamageSource.method_49708(class_8111.field_42337) || lastDamageSource.method_49708(class_8111.field_51566)) {
                return AnimationsId.DEATH_BURN_ANIMATION.getAnimationId();
            }
            if (lastDamageSource.method_49708(class_8111.field_42331) || lastDamageSource.method_49708(class_8111.field_42332)) {
                return AnimationsId.DEATH_EXPLOSION_ANIMATION.getAnimationId();
            }
            if (lastDamageSource.method_49708(class_8111.field_42342)) {
                return AnimationsId.DEATH_DROWN_ANIMATION.getAnimationId();
            }
        }
        return AnimationsId.DEATH_DEFAULT_ANIMATION.getAnimationId();
    }
}

