/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.animation.animations.base;

import com.github.razorplay01.cpa.CustomPlayerAnimations;
import com.github.razorplay01.cpa.util.Util;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.util.records.AnimationContext;

public class TurnRigthAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!CustomPlayerAnimations.CONFIG.getMainAnimations().idleAnimations.turnAnimations.turningStandingAnimationConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
            return;
        }
        TurnRigthAnimation.handleTurningAnimation(context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.playerData().getBodyYawDelta() != 0.0f && !context.player().method_18276() && context.playerData().getBodyYawDelta() > 0.0f && !context.player().method_5765();
    }

    private static void handleTurningAnimation(AnimationContext context) {
        Util.configureAnimationContainer(CustomPlayerAnimations.CONFIG.getMainAnimations().idleAnimations.turnAnimations.turningStandingAnimationConfig, context.mainAnimationContainer());
        context.mainAnimationContainer().setAnimationSpeed(TurnRigthAnimation.calculateAnimationSpeed(context));
        context.mainAnimationContainer().setCurrentAnimation(CustomPlayerAnimations.getAnimation(AnimationsId.TURN_RIGHT_ANIMATION.getAnimationId()));
        context.mainAnimationContainer().setCurrentAnimationId(AnimationsId.TURN_RIGHT_ANIMATION.getAnimationId());
    }

    private static float calculateAnimationSpeed(AnimationContext context) {
        float bodyYawDelta = context.playerData().getBodyYawDelta();
        float halfBodyYawDelta = 0.5f * bodyYawDelta;
        float speedMultiplier = CustomPlayerAnimations.CONFIG.getMainAnimations().idleAnimations.turnAnimations.turningStandingAnimationConfig.getSpeedMultiplier();
        if (halfBodyYawDelta > 2.0f || halfBodyYawDelta < -2.0f) {
            return speedMultiplier;
        }
        return Math.abs(halfBodyYawDelta * speedMultiplier);
    }
}

