/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.animation.animations.overlay;

import com.github.razorplay01.cpa.CustomPlayerAnimations;
import com.github.razorplay01.cpa.util.Util;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.enums.Modifiers;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_742;

public class SwordAnimation
implements ICustomAnimation {
    private int currentComboCount = 0;
    private long lastSwingTick = 0L;
    private final int COMBO_RESET_TICKS = 50;
    private boolean isAnimationInProgress = false;
    private long animationStartTime = 0L;
    private float animationDuration = 0.0f;

    @Override
    public void playAnimation(AnimationContext context) {
        if (!CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.isEnabled()) {
            context.overlayAnimationContainer().disableAnimation();
            this.isAnimationInProgress = false;
        } else if (SwordAnimation.isPlayerSwingingWeapon(context.player())) {
            this.animationStartTime = context.player().method_37908().method_8510();
            this.isAnimationInProgress = true;
            this.handleSwordComboAnimation(context);
            if (context.overlayAnimationContainer().getCurrentAnimation() != null) {
                this.animationDuration = context.overlayAnimationContainer().getCurrentAnimation().length() - 5.0f;
            }
        } else if (this.isAnimationInProgress) {
            long currentTime = context.player().method_37908().method_8510();
            if ((float)(currentTime - this.animationStartTime) < this.animationDuration) {
                this.handleSwordComboAnimation(context);
            } else {
                this.isAnimationInProgress = false;
            }
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return (SwordAnimation.isPlayerSwingingWeapon(context.player()) || this.isAnimationInProgress) && !context.mainAnimationContainer().getCurrentAnimationId().equalsIgnoreCase(AnimationsId.SLEEP_ANIMATION.getAnimationId());
    }

    private void handleSwordComboAnimation(AnimationContext context) {
        long currentTick = context.player().method_37908().method_8510();
        if (currentTick - this.lastSwingTick > 50L) {
            this.currentComboCount = 0;
        }
        if (context.overlayAnimationContainer().getAnimationController().getCurrentAnimation() != null) {
            if (context.overlayAnimationContainer().getAnimationController().isActive() && context.overlayAnimationContainer().getAnimationController().getCurrentAnimation().animation() == CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId())) {
                this.currentComboCount = this.currentComboCount % 3 + 1;
            }
            this.lastSwingTick = currentTick;
            switch (this.currentComboCount) {
                case 2: {
                    context.overlayAnimationContainer().setAnimationSpeed(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getPriority());
                    break;
                }
                case 3: {
                    context.overlayAnimationContainer().setAnimationSpeed(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getPriority());
                    break;
                }
                default: {
                    context.overlayAnimationContainer().setAnimationSpeed(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getPriority());
                }
            }
            this.selectComboAnimation(context);
            ((MirrorModifier)context.overlayAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = context.playerData().getRightHand() != class_1268.field_5808;
        }
    }

    private void selectComboAnimation(AnimationContext context) {
        boolean isSneaking = context.player().method_18276();
        switch (this.currentComboCount) {
            case 1: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_1_SNEAK_ANIMATION.getAnimationId()) : CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_1_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_1_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_1_ANIMATION.getAnimationId());
                break;
            }
            case 2: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_2_SNEAK_ANIMATION.getAnimationId()) : CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_2_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_2_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_2_ANIMATION.getAnimationId());
                break;
            }
            default: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_3_SNEAK_ANIMATION.getAnimationId()) : CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_3_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_3_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_3_ANIMATION.getAnimationId());
            }
        }
    }

    public static boolean isPlayerSwingingWeapon(class_742 player) {
        class_1799 itemStack = player.method_6047();
        if (Util.isAxe(itemStack) || Util.isPickaxe(itemStack) || Util.isShovel(itemStack)) {
            return false;
        }
        return player.field_6252 && (Util.isSword(itemStack) || itemStack.method_7909() instanceof class_1835) && player.field_6266.equals((Object)class_1268.field_5808);
    }
}

