/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.mixin;

import com.github.razorplay01.cpa.CustomPlayerAnimations;
import com.github.razorplay01.cpa.animation.AnimationContainer;
import com.github.razorplay01.cpa.animation.animations.AnimationProvider;
import com.github.razorplay01.cpa.util.CustomModifiers;
import com.github.razorplay01.cpa.util.PlayerData;
import com.github.razorplay01.cpa.util.Util;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.enums.BodyParts;
import com.github.razorplay01.cpa.util.enums.Modifiers;
import com.github.razorplay01.cpa.util.interfaces.IAnimationControl;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimatedPlayer;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.util.records.AnimationContext;
import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.SpeedModifier;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.easing.EasingType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_572;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_7430;
import net.minecraft.class_8162;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements IAnimationControl,
ICustomAnimatedPlayer {
    @Unique
    private AnimationContainer mainAnimationContainer;
    @Unique
    private AnimationContainer overlayAnimationContainer;
    @Unique
    private AnimationContainer specialAnimationContainer;
    @Unique
    private final PlayerData playerData = new PlayerData();
    @Unique
    private AnimationContext actualAnimationContext;

    protected AbstractClientPlayerEntityMixin(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(class_638 clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        this.mainAnimationContainer = new AnimationContainer((AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((class_742)((class_742)this), (class_2960)CustomPlayerAnimations.MAIN_ANIMATION_CONTAINER_LAYER_ID), new HashMap<String, SpeedModifier>(Map.of(Modifiers.MIRROR_MODIFIER.getModifierId(), new MirrorModifier(), Modifiers.SPEED_MODIFIER.getModifierId(), new SpeedModifier(1.0f))), CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()), AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId(), "", 0, 0, 0, 0.0f);
        this.overlayAnimationContainer = new AnimationContainer((AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((class_742)((class_742)this), (class_2960)CustomPlayerAnimations.OVERLAY_ANIMATION_CONTAINER_LAYER_ID), new HashMap<String, AdjustmentModifier>(Map.of(Modifiers.MIRROR_MODIFIER.getModifierId(), new MirrorModifier(), Modifiers.SPEED_MODIFIER.getModifierId(), new SpeedModifier(1.0f), Modifiers.SHIELD_MODIFIER.getModifierId(), CustomModifiers.createShieldModifier((class_742)this), Modifiers.HAND_SWING_MODIFIER.getModifierId(), CustomModifiers.createSwingModifier((class_742)this, this.mainAnimationContainer), Modifiers.BOW_MODIFIER.getModifierId(), CustomModifiers.createBowModifier((class_742)this))), CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()), AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId(), "", 0, 0, 0, 0.0f);
        this.specialAnimationContainer = new AnimationContainer((AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((class_742)((class_742)this), (class_2960)CustomPlayerAnimations.SPECIAL_ANIMATION_CONTAINER_LAYER_ID), new HashMap<String, SpeedModifier>(Map.of(Modifiers.MIRROR_MODIFIER.getModifierId(), new MirrorModifier(), Modifiers.SPEED_MODIFIER.getModifierId(), new SpeedModifier(1.0f))), CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()), AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId(), "", 0, 0, 0, 0.0f);
        Util.addModifiersToContainer(this.mainAnimationContainer);
        Util.addModifiersToContainer(this.overlayAnimationContainer);
        Util.addModifiersToContainer(this.specialAnimationContainer);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.mainAnimationContainer == null || this.overlayAnimationContainer == null || this.specialAnimationContainer == null) {
            return;
        }
        this.playerData.update((class_742)this);
        this.enableAllBodyPartsInAllContainers();
        this.overlayAnimationContainer.resetAnimationProperties();
        this.actualAnimationContext = new AnimationContext(this.mainAnimationContainer, this.overlayAnimationContainer, this.specialAnimationContainer, (class_742)this, this.playerData);
        this.playAnimations();
        this.updateAnimationSpeeds();
        this.checkMainHandItemForArmDisabling();
        this.checkOffHandItemForArmDisabling();
        this.applyDisables();
        this.updateAnimationContainers();
        this.playerData.setPrevPlayerPosition(this.playerData.getPlayerPosition());
        this.playerData.setPrevPlayerBodyYaw(this.playerData.getPlayerBodyYaw());
        this.playerData.setPrevOnGround(this.method_24828());
    }

    @Override
    public AnimationContainer getMainAnimationCPA() {
        return this.mainAnimationContainer;
    }

    @Override
    public AnimationContainer getOverlayAnimationCPA() {
        return this.overlayAnimationContainer;
    }

    @Override
    public AnimationContainer getSpecialAnimationCPA() {
        return this.specialAnimationContainer;
    }

    @Override
    public AnimationContext getAnimationContext() {
        return this.actualAnimationContext;
    }

    @Override
    public void disableBodyPartAnimation(AnimationContainer animationContainer, BodyParts bodyPart) {
        animationContainer.getDisabledBoneIds().add(bodyPart.getPartId());
    }

    @Unique
    public void enabledAllBodyPartsAnimation(AnimationContainer animationContainer) {
        animationContainer.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {});
        animationContainer.getDisabledBoneIds().clear();
    }

    @Override
    public void disableBodyPartAnimationInAllContainers(BodyParts bodyPart) {
        this.disableBodyPartAnimation(this.actualAnimationContext.mainAnimationContainer(), bodyPart);
        this.disableBodyPartAnimation(this.actualAnimationContext.overlayAnimationContainer(), bodyPart);
        this.disableBodyPartAnimation(this.actualAnimationContext.specialAnimationContainer(), bodyPart);
    }

    @Override
    public void disableActiveArm(AnimationContainer animationContainer) {
        if (this.actualAnimationContext.player().method_6058().equals((Object)class_1268.field_5808)) {
            this.disableBodyPartAnimation(animationContainer, this.actualAnimationContext.player().method_6068() == class_1306.field_6183 ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
        } else {
            this.disableBodyPartAnimation(animationContainer, this.actualAnimationContext.player().method_6068() == class_1306.field_6183 ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM);
        }
    }

    @Override
    public class_572.class_573 getMainArmPose() {
        return this.playerData.getMainArmPose();
    }

    @Override
    public void setMainArmPose(class_572.class_573 armPosition) {
        this.playerData.setMainArmPose(armPosition);
    }

    @Override
    public class_572.class_573 getOffArmPose() {
        return this.playerData.getOffArmPose();
    }

    @Override
    public void setOffArmPose(class_572.class_573 armPosition) {
        this.playerData.setOffArmPose(armPosition);
    }

    @Unique
    private void updateAnimationSpeeds() {
        ((SpeedModifier)this.mainAnimationContainer.getAnimationModifiers().get((Object)Modifiers.SPEED_MODIFIER.getModifierId())).speed = this.mainAnimationContainer.getAnimationSpeed() * CustomPlayerAnimations.CONFIG.getGeneral().getAnimationSpeedMultiplier();
        ((SpeedModifier)this.overlayAnimationContainer.getAnimationModifiers().get((Object)Modifiers.SPEED_MODIFIER.getModifierId())).speed = this.overlayAnimationContainer.getAnimationSpeed() * CustomPlayerAnimations.CONFIG.getGeneral().getAnimationSpeedMultiplier();
        ((SpeedModifier)this.specialAnimationContainer.getAnimationModifiers().get((Object)Modifiers.SPEED_MODIFIER.getModifierId())).speed = this.specialAnimationContainer.getAnimationSpeed() * CustomPlayerAnimations.CONFIG.getGeneral().getAnimationSpeedMultiplier();
    }

    @Unique
    private void enableAllBodyPartsInAllContainers() {
        this.enabledAllBodyPartsAnimation(this.mainAnimationContainer);
        this.enabledAllBodyPartsAnimation(this.overlayAnimationContainer);
        this.enabledAllBodyPartsAnimation(this.specialAnimationContainer);
    }

    @Unique
    private void applyDisables() {
        this.applyDisableToContainer(this.mainAnimationContainer);
        this.applyDisableToContainer(this.overlayAnimationContainer);
        this.applyDisableToContainer(this.specialAnimationContainer);
    }

    @Unique
    private void applyDisableToContainer(AnimationContainer container) {
        Set<String> disabledIds = container.getDisabledBoneIds();
        if (disabledIds.isEmpty()) {
            container.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {});
        } else {
            container.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {
                for (String boneId : disabledIds) {
                    ((AdvancedPlayerAnimBone)getBoneFunc.apply(boneId)).setEnabled(false);
                }
            });
        }
    }

    @Unique
    private void playAnimations() {
        for (ICustomAnimation animation : AnimationProvider.MAIN_ANIMATIONS) {
            if (!animation.shouldPlayAnimation(this.actualAnimationContext)) continue;
            animation.playAnimation(this.actualAnimationContext);
        }
        for (ICustomAnimation animation : AnimationProvider.OVERLAY_ANIMATIONS) {
            if (!animation.shouldPlayAnimation(this.actualAnimationContext)) continue;
            animation.playAnimation(this.actualAnimationContext);
        }
        for (ICustomAnimation animation : AnimationProvider.SPECIAL_ANIMATIONS) {
            if (!animation.shouldPlayAnimation(this.actualAnimationContext)) continue;
            animation.playAnimation(this.actualAnimationContext);
        }
    }

    @Unique
    private void updateAnimationContainers() {
        this.updateAnimationContainer(this.mainAnimationContainer);
        this.updateAnimationContainer(this.overlayAnimationContainer);
        this.updateAnimationContainer(this.specialAnimationContainer);
    }

    @Unique
    private void updateAnimationContainer(AnimationContainer animationContainer) {
        if (!animationContainer.getAnimationController().isActive() && !animationContainer.getCurrentAnimationId().equals(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId())) {
            animationContainer.setCurrentAnimation(CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()));
            animationContainer.setCurrentAnimationId(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId());
            animationContainer.setAnimationPriority(0);
            animationContainer.setAnimationFadeTime(0);
            animationContainer.setAnimationSpeed(1.0f);
        }
        if (!Objects.equals(animationContainer.getCurrentAnimationId(), animationContainer.getPrevAnimationId()) && animationContainer.getAnimationPriority() >= animationContainer.getPrevAnimationPriority() || !animationContainer.getAnimationController().isActive()) {
            this.playCurrentAnimation(animationContainer);
            animationContainer.setPrevAnimationId(animationContainer.getCurrentAnimationId());
            animationContainer.setPrevAnimationPriority(animationContainer.getAnimationPriority());
        }
    }

    @Unique
    public void playCurrentAnimation(AnimationContainer animationContainer) {
        animationContainer.getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)animationContainer.getAnimationFadeTime(), (EasingType)EasingType.EASE_IN_OUT_SINE), RawAnimation.begin().thenPlay(animationContainer.getCurrentAnimation()), false);
    }

    @Unique
    private void checkMainHandItemForArmDisabling() {
        if (!this.method_6047().method_7960() && this.method_6115() && (this.method_31550() || this.method_6047().method_7909() instanceof class_7430 || this.method_6047().method_7909() instanceof class_8162)) {
            this.disableBodyPartAnimationInAllContainers(this.method_6068() == class_1306.field_6183 ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
        }
    }

    @Unique
    private void checkOffHandItemForArmDisabling() {
        if (!this.method_6079().method_7960() && this.method_6115() && (this.method_31550() || this.method_6079().method_7909() instanceof class_7430 || this.method_6079().method_7909() instanceof class_8162)) {
            this.disableBodyPartAnimationInAllContainers(this.method_6068() == class_1306.field_6183 ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM);
        }
    }
}

