/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.special;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.Modifiers;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import java.util.Set;
import net.minecraft.class_11890;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class UpHandAnimation
implements ICustomAnimation {
    private static final Set<class_1792> UP_HAND_ITEMS = Set.of(class_1802.field_8810, class_1802.field_22001, class_1802.field_8530, class_1802.field_8204, class_1802.field_38747, class_1802.field_8251);

    @Override
    public void playAnimation(AnimationContext context) {
        boolean shouldPlay;
        HandStates handStates = UpHandAnimation.determineHandStates(context.player());
        UpHandAnimation.handleHandStateChange(handStates, context.mainAnimationContainer(), context);
        boolean configEnabled = ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.isEnabled();
        boolean bl = shouldPlay = configEnabled && UpHandAnimation.shouldPlayHandAnimation(handStates, context);
        if (shouldPlay) {
            UpHandAnimation.playHandAnimations(handStates, context);
        } else {
            String currId = context.specialAnimationContainer().getCurrentAnimationId();
            if (currId.contains(AnimationsId.UP_HAND_ANIMATION.getAnimationId())) {
                context.specialAnimationContainer().disableAnimation();
            }
        }
        UpHandAnimation.updateLastHandStates(handStates, context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return true;
    }

    private static HandStates determineHandStates(class_11890 player) {
        return new HandStates(UpHandAnimation.isHandUp(player.method_6047()), UpHandAnimation.isHandUp(player.method_6079()));
    }

    private static void handleHandStateChange(HandStates currentStates, AnimationContainer mainContainer, AnimationContext context) {
        boolean prevOff;
        boolean prevMain = context.playerData().getPrevMainHandUp();
        if (currentStates.hasChanged(prevMain, prevOff = context.playerData().getPrevOffHandUp())) {
            mainContainer.disableAnimation();
        }
    }

    private static boolean shouldPlayHandAnimation(HandStates states, AnimationContext context) {
        return (states.isMainHandUp || states.isOffHandUp) && !UpHandAnimation.isBlockingAnimation(context.overlayAnimationContainer(), context.mainAnimationContainer());
    }

    private static boolean isBlockingAnimation(AnimationContainer overlay, AnimationContainer main) {
        return Util.containsAnyAnimation(overlay, ModTemplate.CONFIG.getGeneral().getUpHandDisableAnimationIds()) || Util.containsAnyAnimation(main, ModTemplate.CONFIG.getGeneral().getUpHandDisableAnimationIds());
    }

    private static void playHandAnimations(HandStates states, AnimationContext context) {
        if (states.isMainHandUp) {
            UpHandAnimation.setUpHandAnimation(context, context.player().method_6068());
        }
        if (states.isOffHandUp) {
            UpHandAnimation.setUpHandAnimation(context, UpHandAnimation.getOppositeArm(context.player().method_6068()));
        }
    }

    private static class_1306 getOppositeArm(class_1306 arm) {
        return arm == class_1306.field_6183 ? class_1306.field_6182 : class_1306.field_6183;
    }

    private static void updateLastHandStates(HandStates states, AnimationContext context) {
        context.playerData().setPrevMainHandUp(states.isMainHandUp);
        context.playerData().setPrevOffHandUp(states.isOffHandUp);
    }

    private static void setUpHandAnimation(AnimationContext context, class_1306 arm) {
        context.specialAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getSpeedMultiplier());
        context.specialAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getFadeTime());
        context.specialAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getPriority());
        context.specialAnimationContainer().setCurrentAnimation(ModTemplate.getAnimation(AnimationsId.UP_HAND_ANIMATION.getAnimationId()));
        boolean isMainRightArm = arm == class_1306.field_6183;
        String animationId = (isMainRightArm ? "right_" : "left_") + AnimationsId.UP_HAND_ANIMATION.getAnimationId();
        context.specialAnimationContainer().setCurrentAnimationId(animationId);
        ((MirrorModifier)context.specialAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = isMainRightArm;
    }

    private static boolean isHandUp(class_1799 itemStack) {
        return UP_HAND_ITEMS.contains(itemStack.method_7909());
    }

    record HandStates(boolean isMainHandUp, boolean isOffHandUp) {
        boolean hasChanged(boolean lastMainState, boolean lastOffState) {
            return lastMainState != this.isMainHandUp || lastOffState != this.isOffHandUp;
        }
    }
}

