/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.mixin.InventoryAccessor;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.config.ClientConfig;
import com.github.razorplay01.cpa.platform.common.util.PlayerData;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.TwistingVinesBlock;
import net.minecraft.world.level.block.TwistingVinesPlantBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WeepingVinesBlock;
import net.minecraft.world.level.block.WeepingVinesPlantBlock;

public class ClimbAnimations
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!ModTemplate.CONFIG.getMainAnimations().extraAnimations.climbingAnimationsConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
            return;
        }
        Block block = ClimbAnimations.getPlayerBlock(context);
        if (ClimbAnimations.isLadderOrVine(block)) {
            ClimbAnimations.handleLadderOrVineAnimation(context);
        } else if (ClimbAnimations.isClimbablePlant(block)) {
            ClimbAnimations.handleClimbablePlantAnimation(context);
        } else if (ClimbAnimations.isPowderSnow(block)) {
            ClimbAnimations.handlePowderSnowAnimation(context);
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return !context.player().onGround() || !context.player().isPassenger();
    }

    private static Block getPlayerBlock(AnimationContext context) {
        return context.player().level().getBlockState(context.player().blockPosition()).getBlock();
    }

    private static boolean isLadderOrVine(Block block) {
        return block instanceof LadderBlock || block instanceof VineBlock;
    }

    private static boolean isClimbablePlant(Block block) {
        return block instanceof TwistingVinesPlantBlock || block instanceof WeepingVinesPlantBlock || block instanceof TwistingVinesBlock || block instanceof WeepingVinesBlock || block instanceof ScaffoldingBlock;
    }

    private static boolean isPowderSnow(Block block) {
        return block instanceof PowderSnowBlock;
    }

    private static void handleLadderOrVineAnimation(AnimationContext context) {
        ClimbAnimations.setBodyRotationInLeadderAndVineBlocks(context);
        ClimbAnimations.playClimbAnimation(context);
    }

    private static void handleClimbablePlantAnimation(AnimationContext context) {
        ClimbAnimations.setBodyRotationOnClimbableBlocks(context);
        ClimbAnimations.playClimbAnimation(context);
    }

    private static void handlePowderSnowAnimation(AnimationContext context) {
        if (ClimbAnimations.hasLeatherBoots(context)) {
            ClimbAnimations.playClimbAnimation(context);
        }
    }

    private static boolean hasLeatherBoots(AnimationContext context) {
        Avatar avatar = context.player();
        if (!(avatar instanceof Player)) {
            return false;
        }
        Player player = (Player)avatar;
        ItemStack itemStack = ((InventoryAccessor)player.getInventory()).getEquipment().get(EquipmentSlot.FEET);
        return String.valueOf(itemStack.getItemName()).contains("leather_boots");
    }

    public static void playClimbAnimation(AnimationContext context) {
        if (!context.player().onClimbable()) {
            return;
        }
        ClimbAnimations.configureAnimationContainer(context);
        ClimbAnimations.setClimbingAnimation(context);
    }

    private static void configureAnimationContainer(AnimationContext context) {
        ClientConfig.AnimationConfig config = ModTemplate.CONFIG.getMainAnimations().extraAnimations.climbingAnimationsConfig;
        AnimationContainer animationContainer = context.mainAnimationContainer();
        animationContainer.setAnimationSpeed(config.getSpeedMultiplier());
        animationContainer.setAnimationFadeTime(config.getFadeTime());
        animationContainer.setAnimationPriority(config.getPriority());
    }

    private static void setClimbingAnimation(AnimationContext context) {
        Avatar player = context.player();
        PlayerData playerData = context.playerData();
        boolean isCrouching = player.isCrouching();
        double verticalSpeed = playerData.getVectorY();
        if (verticalSpeed > 0.0) {
            AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.CLIMB_SNEAK_ANIMATION);
        } else if (verticalSpeed < 0.0) {
            AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.CLIMB_BACKWARDS_ANIMATION);
        } else {
            AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.CLIMB_IDLE_SNEAK_ANIMATION);
        }
    }

    private static void setBodyRotationInLeadderAndVineBlocks(AnimationContext context) {
        if (!(context.player().getUseItem().getItem() instanceof BowItem)) {
            String blockStateString = String.valueOf(context.player().level().getBlockState(context.player().blockPosition()));
            context.playerData().setPlayerBodyYaw(context.player().getVisualRotationYInDegrees());
            context.playerData().setPlayerHeadYaw(context.player().getYHeadRot());
            if (blockStateString.contains("facing=north") || blockStateString.contains("south=true")) {
                context.playerData().setPlayerBodyYaw(0.0f);
            } else if (blockStateString.contains("facing=south") || blockStateString.contains("north=true")) {
                context.playerData().setPlayerBodyYaw(180.0f);
            } else if (blockStateString.contains("facing=west") || blockStateString.contains("east=true")) {
                context.playerData().setPlayerBodyYaw(270.0f);
            } else if (blockStateString.contains("facing=east") || blockStateString.contains("west=true")) {
                context.playerData().setPlayerBodyYaw(90.0f);
            }
            context.playerData().setPlayerBodyYaw((context.playerData().getPlayerBodyYaw() % 360.0f + 360.0f) % 360.0f);
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            context.player().setYBodyRot(context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw(context.playerData().getPlayerHeadYaw() - context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            if (context.playerData().getPlayerHeadYaw() > 90.0f && context.playerData().getPlayerHeadYaw() <= 180.0f) {
                context.player().setYHeadRot(context.playerData().getPlayerBodyYaw() + 90.0f);
            } else if (context.playerData().getPlayerHeadYaw() > 180.0f && context.playerData().getPlayerHeadYaw() < 270.0f) {
                context.player().setYHeadRot(context.playerData().getPlayerBodyYaw() + 270.0f);
            }
        }
    }

    private static void setBodyRotationOnClimbableBlocks(AnimationContext context) {
        if (!(context.player().getUseItem().getItem() instanceof BowItem)) {
            context.playerData().setPrevPlayerBodyYaw((float)Math.toDegrees(Math.atan2((double)context.player().blockPosition().getZ() + 0.5 - context.playerData().getPlayerPosition().z, (double)context.player().blockPosition().getX() + 0.5 - context.playerData().getPlayerPosition().x)) - 90.0f);
            context.playerData().setPlayerHeadYaw(context.player().getYHeadRot());
            context.playerData().setPrevPlayerBodyYaw((context.playerData().getPlayerBodyYaw() % 360.0f + 360.0f) % 360.0f);
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            context.player().setYBodyRot(context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw(context.playerData().getPlayerHeadYaw() - context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            if (context.playerData().getPlayerHeadYaw() > 90.0f && context.playerData().getPlayerHeadYaw() <= 180.0f) {
                context.player().setYHeadRot(context.playerData().getPlayerBodyYaw() + 90.0f);
            } else if (context.playerData().getPlayerHeadYaw() > 180.0f && context.playerData().getPlayerHeadYaw() < 270.0f) {
                context.player().setYHeadRot(context.playerData().getPlayerBodyYaw() + 270.0f);
            }
        }
    }
}

