/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.player.Player;

public class CreativeFlyIdleAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        CreativeFlyIdleAnimation.playFlyIdleCreativeAnimation(context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        Avatar avatar = context.player();
        if (!(avatar instanceof Player)) {
            return false;
        }
        Player player = (Player)avatar;
        return context.playerData().getFlychecker() > 10 && !player.isPassenger() && player.isCreative();
    }

    private static void playFlyIdleCreativeAnimation(AnimationContext context) {
        if (!ModTemplate.CONFIG.getMainAnimations().idleAnimations.idleCreativeFlyingAnimationConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
        } else {
            Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().idleAnimations.idleCreativeFlyingAnimationConfig, context.mainAnimationContainer());
            AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.IDLE_CREATIVE_FLY_ANIMATION);
        }
    }
}

