package com.github.razorplay01.cpa.platform.common.animation.animations.special;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.config.ClientConfig;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.Modifiers;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

import static com.github.razorplay01.cpa.ModTemplate.CONFIG;
import static com.github.razorplay01.cpa.ModTemplate.getAnimation;
import static com.github.razorplay01.cpa.platform.common.util.Util.*;

public class UpHandAnimation implements ICustomAnimation {
	public void playAnimation(AnimationContext context) {
		HandStates handStates = determineHandStates(context.player());
		handleHandStateChange(handStates, context.mainAnimationContainer(), context);
		boolean configEnabled = CONFIG.getSpecialAnimations().upHandAnimationConfig.isEnabled();
		boolean shouldPlay = configEnabled && shouldPlayHandAnimation(handStates, context);
		if (shouldPlay) {
			playHandAnimations(handStates, context);
		} else {
			String currId = context.specialAnimationContainer().getCurrentAnimationId();
			if (currId.contains(AnimationsId.UP_HAND_ANIMATION.getAnimationId())) {
				context.specialAnimationContainer().disableAnimation();
			}
		}
		updateLastHandStates(handStates, context);
	}

	@Override
	public boolean shouldPlayAnimation(AnimationContext context) {
		return true;  // Siempre considera, la lógica de config está en playAnimation para poder deshabilitar si es necesario.
	}

	private static HandStates determineHandStates(
			//? if <= 1.21.8 {
			//AbstractClientPlayer player
			//?} else {
			net.minecraft.class_11890 player
			//?}
			) {
		return new HandStates(
				isHandUp(player.method_6047()),
				isHandUp(player.method_6079())
		);
	}

	private static void handleHandStateChange(HandStates currentStates, AnimationContainer mainContainer, AnimationContext context) {
		boolean prevMain = context.playerData().getPrevMainHandUp();
		boolean prevOff = context.playerData().getPrevOffHandUp();
		if (currentStates.hasChanged(prevMain, prevOff)) {
			mainContainer.disableAnimation();
		}
	}

	private static boolean shouldPlayHandAnimation(HandStates states, AnimationContext context) {
		return (states.isMainHandUp || states.isOffHandUp) &&
				!isBlockingAnimation(context.overlayAnimationContainer(), context.mainAnimationContainer());
	}

	private static boolean isBlockingAnimation(AnimationContainer overlay, AnimationContainer main) {
		return containsAnyAnimation(overlay, CONFIG.getSpecialAnimations().getUpHandDisableAnimationIds()) ||
				containsAnyAnimation(main, CONFIG.getSpecialAnimations().getUpHandDisableAnimationIds());
	}

	private static void playHandAnimations(HandStates states, AnimationContext context) {
		if (states.isMainHandUp) {
			setUpHandAnimation(context, context.player().method_6068());
		}
		if (states.isOffHandUp) {
			setUpHandAnimation(context, getOppositeArm(context.player().method_6068()));
		}
	}

	private static class_1306 getOppositeArm(class_1306 arm) {
		return arm == class_1306.field_6183 ? class_1306.field_6182 : class_1306.field_6183;
	}

	private static void updateLastHandStates(HandStates states, AnimationContext context) {
		context.playerData().setPrevMainHandUp(states.isMainHandUp);
		context.playerData().setPrevOffHandUp(states.isOffHandUp);
	}

	private static void setUpHandAnimation(AnimationContext context, class_1306 arm) {
		context.specialAnimationContainer().setAnimationSpeed(CONFIG.getSpecialAnimations().upHandAnimationConfig.getSpeedMultiplier());
		context.specialAnimationContainer().setAnimationFadeTime(CONFIG.getSpecialAnimations().upHandAnimationConfig.getFadeTime());
		context.specialAnimationContainer().setAnimationPriority(CONFIG.getSpecialAnimations().upHandAnimationConfig.getPriority());
		context.specialAnimationContainer().setCurrentAnimation(getAnimation(AnimationsId.UP_HAND_ANIMATION.getAnimationId()));
		boolean isMainRightArm = arm == class_1306.field_6183;
		String animationId = (isMainRightArm ? RIGHT_PREFIX : LEFT_PREFIX) + AnimationsId.UP_HAND_ANIMATION.getAnimationId();
		context.specialAnimationContainer().setCurrentAnimationId(animationId);
		((MirrorModifier) context.specialAnimationContainer().getAnimationModifiers().get(Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = isMainRightArm;
	}

	private static boolean isHandUp(class_1799 itemStack) {
		return getUpHandItems().contains(itemStack.method_7909());
	}

	record HandStates(boolean isMainHandUp, boolean isOffHandUp) {
		boolean hasChanged(boolean lastMainState, boolean lastOffState) {
			return (lastMainState != isMainHandUp) || (lastOffState != isOffHandUp);
		}
	}

	public static Set<class_1792> getUpHandItems() {
		return CONFIG.getSpecialAnimations().upHandItemIds.stream()
				.map(idStr -> {
					ResourceLocation id;
					if (idStr.contains(":")) {
						id = ResourceLocation.tryParse(idStr);
					} else {
						id = ResourceLocation.fromNamespaceAndPath("minecraft", idStr.toLowerCase());
					}
					if (id != null && BuiltInRegistries.ITEM.get(id).isPresent()) {
						Item item = BuiltInRegistries.ITEM.get(id).get().value();
						if (item != Items.AIR) {
							return item;
						}
					}

					return null;
				})
				.filter(Objects::nonNull)
				.collect(Collectors.toUnmodifiableSet());
	}
}
