/*
 * Decompiled with CFR 0.152.
 */
package com.HeroxWar.HeroxCore;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class Events
implements Listener {
    public Events(Plugin pluginInstance, List<String> ignoredEvents) {
        this.method(pluginInstance, ignoredEvents);
    }

    public void method(Plugin pluginInstance, List<String> ignoredEvents) {
        System.out.println("Enabling EventLogger...");
        Listener listener = new Listener(){};
        EventExecutor executor = (ignored, event) -> {
            if (!ignoredEvents.contains(event.getEventName())) {
                System.out.println("Event got fired: " + event.getEventName());
            }
        };
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().acceptPackages(new String[]{"org.bukkit.event"}).scan();){
            ClassInfoList events = scanResult.getClassInfo(Event.class.getName()).getSubclasses().filter(info -> !info.isAbstract());
            try {
                for (ClassInfo event2 : events) {
                    Class<?> eventClass = Class.forName(event2.getName());
                    if (!Arrays.stream(eventClass.getDeclaredMethods()).anyMatch(method -> method.getParameterCount() == 0 && method.getName().equals("getHandlers"))) continue;
                    Bukkit.getPluginManager().registerEvent(eventClass, listener, EventPriority.MONITOR, executor, pluginInstance, false);
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError("Scanned class wasn't found", e);
            }
            CharSequence[] eventNames = (String[])events.stream().map(info -> info.getName().substring(info.getName().lastIndexOf(46) + 1)).toArray(String[]::new);
            System.out.println("List of events: " + String.join((CharSequence)", ", eventNames));
            System.out.println("Events found: " + events.size());
            System.out.println("HandlerList size: " + HandlerList.getHandlerLists().size());
        }
    }
}

