/*
 * Decompiled with CFR 0.152.
 */
package com.HeroxWar.HeroxCore.TimeGesture;

import java.util.ArrayList;
import java.util.List;

public class Time {
    private static final int ticksInOneSecond = 20;
    private static final int millisecondsInOneSecond = 1000;
    private static final int secondsInOneMinute = 60;
    private static final int minutesInOneHour = 60;
    private static final int hoursInADay = 24;
    private long seconds = 0L;
    private long minutes = 0L;
    private long hours = 0L;
    private long days = 0L;
    private char formatter = (char)58;

    public Time() {
    }

    public Time(int ticks, char formatter) {
        this((long)ticks / 20L * 1000L, formatter);
    }

    public Time(long milliseconds, char formatter) {
        this.seconds = this.getSecondsFromMilliseconds(milliseconds);
        this.minutes = this.getMinutesFromSeconds(this.seconds);
        this.hours = this.getHoursFromMinutes(this.minutes);
        this.days = this.getDaysFromHours(this.hours);
        this.seconds -= this.getSecondsFromMinutes(this.minutes);
        this.minutes -= this.getMinutesFromHours(this.hours);
        this.hours -= this.getHoursFromDays(this.days);
        this.formatter = formatter;
    }

    public Time(long days, long hours, long minutes, long seconds, char formatter) {
        this.seconds = seconds >= 60L ? 59L : seconds;
        this.minutes = minutes >= 60L ? 59L : minutes;
        this.hours = hours >= 24L ? 23L : hours;
        this.days = days;
        this.formatter = formatter;
    }

    public Time(int days, int hours, int minutes, int seconds, char formatter) {
        this.seconds = seconds >= 60 ? 59L : (long)seconds;
        this.minutes = minutes >= 60 ? 59L : (long)minutes;
        this.hours = hours >= 24 ? 23L : (long)hours;
        this.days = days;
        this.formatter = formatter;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public void setMinutes(long minutes) {
        this.minutes = minutes;
    }

    public long getHours() {
        return this.hours;
    }

    public void setHours(long hours) {
        this.hours = hours;
    }

    public long getDays() {
        return this.days;
    }

    public void setDays(long days) {
        this.days = days;
    }

    public long getMilliseconds() {
        long totalHours = this.getHoursFromDays(this.days) + this.hours;
        long totalMinutes = this.getMinutesFromHours(totalHours) + this.minutes;
        long totalSeconds = this.getSecondsFromMinutes(totalMinutes) + this.seconds;
        return totalSeconds * 1000L;
    }

    public long getSecondsFromMilliseconds(long milliseconds) {
        return milliseconds / 1000L;
    }

    public long getSecondsFromMinutes(long minutes) {
        return minutes * 60L;
    }

    public long getMinutesFromSeconds(long seconds) {
        return seconds / 60L;
    }

    public long getMinutesFromHours(long hours) {
        return hours * 60L;
    }

    public long getHoursFromMinutes(long minutes) {
        return minutes / 60L;
    }

    public long getHoursFromDays(long days) {
        return days * 24L;
    }

    public long getDaysFromHours(long hours) {
        return hours / 24L;
    }

    public String getTime() {
        return this.getTime(this.formatter);
    }

    public String getTime(char formatter) {
        return "" + this.days + formatter + this.hours + formatter + this.minutes + formatter + this.seconds;
    }

    public String getTimeWithoutZeros() {
        return this.getTimeWithoutZeros(this.formatter);
    }

    public String getTimeWithoutZeros(char formatter) {
        StringBuilder time = new StringBuilder();
        boolean found = true;
        for (long partTime : this.getArrayTime()) {
            if (partTime == 0L && found) continue;
            found = false;
            time.append(partTime).append(formatter);
        }
        time = new StringBuilder(time.substring(0, time.length() - 1));
        return time.toString();
    }

    public List<Long> getArrayTime() {
        ArrayList<Long> informations = new ArrayList<Long>();
        informations.add(this.days);
        informations.add(this.hours);
        informations.add(this.minutes);
        informations.add(this.seconds);
        return informations;
    }

    public List<Long> getArrayTimeWithoutZero() {
        List<Long> informations = this.getArrayTime();
        boolean found = true;
        while (found) {
            if (informations.get(0) == 0L) {
                informations.remove(0);
                continue;
            }
            found = false;
        }
        return informations;
    }

    public boolean equals(Object time) {
        if (time instanceof Time) {
            return ((Time)time).getTime().equalsIgnoreCase(this.getTime());
        }
        return false;
    }

    public Time cloneTime() {
        return new Time(this.days, this.hours, this.minutes, this.seconds, this.formatter);
    }

    public boolean isBiggerThen(Time time) {
        return time.getMilliseconds() > this.getMilliseconds();
    }

    public Time differenceBetween(Time time) {
        boolean isBigger = this.isBiggerThen(time);
        Time timeToReturn = isBigger ? new Time(time.getMilliseconds() - this.getMilliseconds(), this.formatter) : new Time(this.getMilliseconds() - time.getMilliseconds(), this.formatter);
        return timeToReturn;
    }

    public void difference(Time time) {
        Time timeToReturn = this.differenceBetween(time);
        this.setDays(timeToReturn.getDays());
        this.setHours(timeToReturn.getHours());
        this.setMinutes(timeToReturn.getMinutes());
        this.setSeconds(timeToReturn.getSeconds());
    }

    public Time sumBetween(Time time) {
        return new Time(this.getMilliseconds() + time.getMilliseconds(), this.formatter);
    }

    public void sum(Time time) {
        Time timeSum = this.sumBetween(time);
        this.setDays(timeSum.getDays());
        this.setHours(timeSum.getHours());
        this.setMinutes(timeSum.getMinutes());
        this.setSeconds(timeSum.getSeconds());
    }

    public String toString() {
        return "Time{seconds=" + this.seconds + ", minutes=" + this.minutes + ", hours=" + this.hours + ", days=" + this.days + ", formatter='" + this.formatter + "'}";
    }
}

