/*
 * Decompiled with CFR 0.152.
 */
package com.HeroxWar.HeroxCore.Utils;

import com.HeroxWar.HeroxCore.Utils.NmsException;
import org.bukkit.Bukkit;

public class Nms {
    private String packageName = Bukkit.getServer().getClass().getPackage().getName();
    private String nms;
    private boolean nmsVersion;
    private boolean brigadierIsActive;
    private Class<?> minecraftServerClass;

    public Nms() {
        try {
            if (this.packageName.equals("org.bukkit.craftbukkit")) {
                this.nms = ".";
            } else {
                String[] parts = this.packageName.split("\\.");
                this.nms = "." + parts[3] + ".";
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.nms = ".";
        }
        this.checkNmsVersion();
        this.checkBrigadier();
        try {
            this.checkMinecraftServerClass();
        }
        catch (NmsException nmsException) {
            // empty catch block
        }
    }

    public Class<?> getNMSClass(String path) throws ClassNotFoundException {
        return Class.forName(path.replace(".__VERSION__.", this.nms));
    }

    private void checkNmsVersion() {
        try {
            Class.forName("net.minecraft.server.MinecraftServer");
            this.nmsVersion = false;
        }
        catch (ClassNotFoundException ignore) {
            this.nmsVersion = true;
        }
    }

    private void checkBrigadier() {
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
            this.brigadierIsActive = true;
        }
        catch (Exception ignored) {
            this.brigadierIsActive = false;
        }
    }

    private void checkMinecraftServerClass() throws NmsException {
        try {
            this.minecraftServerClass = Class.forName("net.minecraft.server" + (this.nmsVersion ? this.nms : ".") + "MinecraftServer");
        }
        catch (Exception ex) {
            this.brigadierIsActive = false;
            throw new NmsException(ex.getMessage());
        }
    }

    public String getNms() {
        return this.nms;
    }

    public void setNms(String nms) {
        this.nms = nms;
    }

    public boolean isNmsVersion() {
        return this.nmsVersion;
    }

    public void setNmsVersion(boolean nmsVersion) {
        this.nmsVersion = nmsVersion;
    }

    public boolean isBrigadierIsActive() {
        return this.brigadierIsActive;
    }

    public void setBrigadierIsActive(boolean brigadierIsActive) {
        this.brigadierIsActive = brigadierIsActive;
    }

    public Class<?> getMinecraftServerClass() {
        return this.minecraftServerClass;
    }

    public void setMinecraftServerClass(Class<?> minecraftServerClass) {
        this.minecraftServerClass = minecraftServerClass;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String toString() {
        return "Nms{packageName='" + this.packageName + "', nms='" + this.nms + "', nmsVersion=" + this.nmsVersion + ", brigadierIsActive=" + this.brigadierIsActive + ", minecraftServerClass=" + String.valueOf(this.minecraftServerClass) + "}";
    }
}

