/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Api;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Database.Objects.Challenger;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class VanillaChallengesAPI {
    private static final boolean isDebugEnabled = Main.instance.getConfigGesture().getDebug().get("API");

    public static String getDailyChallengeName() {
        DebugUtils debug = new DebugUtils("API");
        long time = System.currentTimeMillis();
        if (isDebugEnabled) {
            debug.addLine("Method: getDailyChallenge");
            debug.addLine("API execution time= " + (System.currentTimeMillis() - time));
            debug.debug();
        }
        return Main.instance.getDailyChallenge().getChallengeName();
    }

    public static String getDailyChallengeType() {
        DebugUtils debug = new DebugUtils("API");
        long time = System.currentTimeMillis();
        if (isDebugEnabled) {
            debug.addLine("Method: getDailyChallenge");
            debug.addLine("API execution time= " + (System.currentTimeMillis() - time));
            debug.debug();
        }
        return Main.instance.getDailyChallenge().getTypeChallenge();
    }

    public static String getDailyChallengeGuiName() {
        DebugUtils debug = new DebugUtils("API");
        long time = System.currentTimeMillis();
        if (isDebugEnabled) {
            debug.addLine("Method: getDailyChallenge");
            debug.addLine("API execution time= " + (System.currentTimeMillis() - time));
            debug.debug();
        }
        return Main.instance.getDailyChallenge().getNameChallenge();
    }

    public static String getDailyChallengeGuiItem() {
        DebugUtils debug = new DebugUtils("API");
        long time = System.currentTimeMillis();
        if (isDebugEnabled) {
            debug.addLine("Method: getDailyChallenge");
            debug.addLine("API execution time= " + (System.currentTimeMillis() - time));
            debug.debug();
        }
        return Main.instance.getDailyChallenge().getItemChallenge();
    }

    public static String getDailyChallengeTime() {
        DebugUtils debug = new DebugUtils("API");
        long time = System.currentTimeMillis();
        if (isDebugEnabled) {
            debug.addLine("Method: getDailyChallenge");
            debug.addLine("API execution time= " + (System.currentTimeMillis() - time));
            debug.debug();
        }
        return Main.instance.getDailyChallenge().getTimeChallenge().getTime();
    }

    public static int getDailyChallengePoint() {
        DebugUtils debug = new DebugUtils("API");
        long time = System.currentTimeMillis();
        if (isDebugEnabled) {
            debug.addLine("Method: getDailyChallenge");
            debug.addLine("API execution time= " + (System.currentTimeMillis() - time));
            debug.debug();
        }
        return Main.instance.getDailyChallenge().getPoint();
    }

    public static Map<String, Long> getChallengers() {
        return Collections.unmodifiableMap(Main.instance.getDailyChallenge().getPlayers());
    }

    public static long getPoints(String playerName) {
        if (Main.instance.getDailyChallenge().getPlayers().containsKey(playerName)) {
            return Main.instance.getDailyChallenge().getPlayers().get(playerName);
        }
        return -1L;
    }

    public static void addPoints(String playerName, long points) {
        Main.instance.getDailyChallenge().incrementCommands(playerName, points);
    }

    public static void removePoints(String playerName, long points) {
        Main.instance.getDailyChallenge().incrementCommands(playerName, Math.negateExact(points));
    }

    public static List<String> getTop() {
        ArrayList<String> players = new ArrayList<String>();
        for (Challenger challenger : Main.instance.getDailyChallenge().getTopPlayers(Main.instance.getConfigGesture().getNumberOfTop())) {
            players.add(challenger.getNomePlayer());
        }
        return Collections.unmodifiableList(players);
    }
}

