/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Comandi;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.HeroxWar.HeroxCore.ReloadGesture;
import com.HeroxWar.HeroxCore.TimeGesture.Time;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Database.H2Database;
import io.eliotesta98.VanillaChallenges.Database.Objects.Challenger;
import io.eliotesta98.VanillaChallenges.Database.Objects.DailyWinner;
import io.eliotesta98.VanillaChallenges.Events.DailyGiveWinners;
import io.eliotesta98.VanillaChallenges.Interfaces.Interface;
import io.eliotesta98.VanillaChallenges.Utils.Challenge;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import io.eliotesta98.VanillaChallenges.Utils.MoneyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Commands
implements CommandExecutor {
    private final String errorYouAreNotAPlayer = Main.instance.getConfigGesture().getMessages().get("Errors.YouAreNotAPlayer");
    private final String errorCommandNotFound = Main.instance.getConfigGesture().getMessages().get("Errors.CommandNotFound");
    private final String errorNoPerms = Main.instance.getConfigGesture().getMessages().get("Errors.NoPerms");
    private final String alreadyStartEvent = Main.instance.getConfigGesture().getMessages().get("Errors.AlreadyStartEvent");
    private final String alreadyStopEvent = Main.instance.getConfigGesture().getMessages().get("Errors.AlreadyStopEvent");
    private final String scheduleError = Main.instance.getConfigGesture().getMessages().get("Errors.Schedule");
    private final String addError = Main.instance.getConfigGesture().getMessages().get("Errors.Add");
    private final String alreadyDisable = Main.instance.getConfigGesture().getMessages().get("Errors.AlreadyDisable");
    private final String timeError = Main.instance.getConfigGesture().getMessages().get("Errors.Time");
    private final String addSuccess = Main.instance.getConfigGesture().getMessages().get("Success.Add");
    private final String removeSuccess = Main.instance.getConfigGesture().getMessages().get("Success.Remove");
    private final String succesfullyRestored = Main.instance.getConfigGesture().getMessages().get("Success.Restored");
    private final String timeRemove = Main.instance.getConfigGesture().getMessages().get("Success.TimeRemove");
    private final String timeAdd = Main.instance.getConfigGesture().getMessages().get("Success.TimeAdd");
    private final String timeSet = Main.instance.getConfigGesture().getMessages().get("Success.TimeSet");
    private final String commandFooter = Main.instance.getConfigGesture().getMessages().get("Commands.Footer");
    private final String commandVcReloadHelp = Main.instance.getConfigGesture().getMessages().get("Commands.Reload");
    private final String commandVcNextHelp = Main.instance.getConfigGesture().getMessages().get("Commands.Next");
    private final String commandVcPointsHelp = Main.instance.getConfigGesture().getMessages().get("Commands.Points");
    private final String commandVcTopHelp = Main.instance.getConfigGesture().getMessages().get("Commands.Top");
    private final String commandVcClear = Main.instance.getConfigGesture().getMessages().get("Commands.Clear");
    private final String commandVcChallenge = Main.instance.getConfigGesture().getMessages().get("Commands.Challenge");
    private final String commandVcEconomyChallenge = Main.instance.getConfigGesture().getMessages().get("Commands.Economy");
    private final String commandVcReward = Main.instance.getConfigGesture().getMessages().get("Commands.Reward");
    private final String commandVcList = Main.instance.getConfigGesture().getMessages().get("Commands.List");
    private final String commandVcEvent = Main.instance.getConfigGesture().getMessages().get("Commands.Event");
    private final String commandVcSchedule = Main.instance.getConfigGesture().getMessages().get("Commands.Schedule");
    private final String commandVcRestore = Main.instance.getConfigGesture().getMessages().get("Commands.Restore");
    private final String commandVcTime = Main.instance.getConfigGesture().getMessages().get("Commands.Time");
    private final String fileList = Main.instance.getConfigGesture().getMessages().get("Lists.Files");
    private final String fileLine = Main.instance.getConfigGesture().getMessages().get("Lists.FilesLine");
    private final String pointsInfo = Main.instance.getConfigGesture().getMessages().get("Points.Info");
    private final String pointsPlayerPlaceholder = Main.instance.getConfigGesture().getMessages().get("Points.PlayerPlaceholder");
    private final String actuallyInTop = Main.instance.getConfigGesture().getMessages().get("ActuallyInTop");
    private final String pointsadd = Main.instance.getConfigGesture().getMessages().get("PointsAdd");
    private final String pointsremove = Main.instance.getConfigGesture().getMessages().get("PointsRemove");
    private final String timeRemaining = Main.instance.getConfigGesture().getMessages().get("TimeRemaining");
    private final String cooldown = Main.instance.getConfigGesture().getMessages().get("Cooldown");
    private final String challengeList = Main.instance.getConfigGesture().getMessages().get("ChallengeList");
    private final String challengeOfList = Main.instance.getConfigGesture().getMessages().get("ChallengeofList");
    private final boolean debugCommand = Main.instance.getConfigGesture().getDebug().get("Commands");
    private final boolean resetPoints = Main.instance.getConfigGesture().isResetPointsAtNewChallenge();
    private final int numberOfTop = Main.instance.getConfigGesture().getNumberOfTop();
    private final int numberOfRewardedPlayer = Main.instance.getConfigGesture().getNumberOfRewardPlayer();
    private final boolean rankingReward = Main.instance.getConfigGesture().isRankingReward();
    private final boolean randomReward = Main.instance.getConfigGesture().isRandomReward();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            DebugUtils debug = new DebugUtils("Commands");
            long tempo = System.currentTimeMillis();
            if (!command.getName().equalsIgnoreCase("vanillachallenges")) {
                MessageGesture.sendMessage(sender, this.errorCommandNotFound);
                if (this.debugCommand) {
                    debug.addLine("Commands execution time= " + (System.currentTimeMillis() - tempo));
                    debug.debug();
                }
                return;
            }
            if (args.length == 0) {
                String finale = "\n\n&e&l" + Main.instance.getName() + "&7 \u25cf Version " + Main.instance.getDescription().getVersion() + " created by &a&leliotesta98 & xSavior_of_God\n&r\n";
                if (sender.hasPermission("vc.add.command")) {
                    finale = finale + this.commandVcEconomyChallenge + "\n";
                }
                if (sender.hasPermission("vc.challenge.command")) {
                    finale = finale + this.commandVcChallenge + "\n";
                }
                if (sender.hasPermission("vc.clear.command")) {
                    finale = finale + this.commandVcClear + "\n";
                }
                if (sender.hasPermission("vc.event.start.command") || sender.hasPermission("vc.event.stop.command")) {
                    finale = finale + this.commandVcEvent + "\n";
                }
                if (sender.hasPermission("vc.list.command")) {
                    finale = finale + this.commandVcList + "\n";
                }
                if (sender.hasPermission("vc.next.command")) {
                    finale = finale + this.commandVcNextHelp + "\n";
                }
                if (sender.hasPermission("vc.points.command")) {
                    finale = finale + this.commandVcPointsHelp + "\n";
                }
                if (sender.hasPermission("vc.reload.command")) {
                    finale = finale + this.commandVcReloadHelp + "\n";
                }
                if (sender.hasPermission("vc.reward.command")) {
                    finale = finale + this.commandVcReward + "\n";
                }
                if (sender.hasPermission("vc.schedule.add.command") || sender.hasPermission("vc.schedule.remove.command")) {
                    finale = finale + this.commandVcSchedule + "\n";
                }
                if (sender.hasPermission("vc.time.add.command") || sender.hasPermission("vc.time.remove.command") || sender.hasPermission("vc.time.set.command")) {
                    finale = finale + this.commandVcTime + "\n";
                }
                if (sender.hasPermission("vc.top.command")) {
                    finale = finale + this.commandVcTopHelp + "\n";
                }
                finale = finale + "&r\n";
                finale = finale + this.commandFooter;
                MessageGesture.sendMessage(sender, finale);
                if (this.debugCommand) {
                    debug.addLine("Commands execution time= " + (System.currentTimeMillis() - tempo));
                    debug.debug();
                }
                return;
            }
            switch (args[0]) {
                case "add": {
                    if (!sender.hasPermission("vc.add.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (args.length > 3) {
                        MessageGesture.sendMessage(sender, this.commandVcEconomyChallenge);
                        break;
                    }
                    Main.instance.getDailyChallenge().incrementCommands(args[1], Long.parseLong(args[2]));
                    MessageGesture.sendMessage(sender, this.pointsadd.replace("{points}", args[2]).replace("{player}", args[1]));
                    break;
                }
                case "challenge": {
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (args.length != 1) {
                        MessageGesture.sendMessage(sender, this.commandVcChallenge);
                        break;
                    }
                    Main.instance.getDailyChallenge().message(sender);
                    break;
                }
                case "clear": {
                    if (!sender.hasPermission("vc.clear.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length != 1) {
                        MessageGesture.sendMessage(sender, this.commandVcClear);
                        if (this.debugCommand) {
                            debug.addLine("Commands execution time= " + (System.currentTimeMillis() - tempo));
                            debug.debug();
                        }
                        return;
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                        Main.db.clearAll();
                        if (Main.challengeSelected) {
                            Main.instance.getDailyChallenge().clearPlayers();
                            for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                                interfaces.getValue().closeAllInventories();
                            }
                        }
                        Main.instance.getConfigGesture().getTasks().stopAllTasks();
                        Main.instance.unregisterCurrentListener();
                        Main.instance.pluginStartingProcess();
                    });
                    break;
                }
                case "event": {
                    List<Challenge> challenges;
                    if (args.length < 2 || args.length > 3) {
                        MessageGesture.sendMessage(sender, this.commandVcEvent);
                        break;
                    }
                    String rowTime = "";
                    if (args.length == 3) {
                        rowTime = args[2];
                        String typeTime = rowTime.charAt(rowTime.length() - 1) + "";
                        try {
                            int n = Integer.parseInt(rowTime.replace(typeTime, ""));
                        }
                        catch (NumberFormatException e) {
                            MessageGesture.sendMessage(sender, this.timeError.replace("{value}", rowTime));
                            break;
                        }
                    }
                    if (args[1].equalsIgnoreCase("stop")) {
                        if (!sender.hasPermission("vc.event.stop.command")) {
                            MessageGesture.sendMessage(sender, this.errorNoPerms);
                            break;
                        }
                        challenges = Main.db.getChallenges();
                        if (!challenges.isEmpty() && !challenges.get(0).getChallengeName().contains("Event_")) {
                            MessageGesture.sendMessage(sender, this.alreadyStopEvent);
                            break;
                        }
                        if (challenges.isEmpty()) {
                            MessageGesture.sendMessage(sender, this.alreadyStopEvent);
                            break;
                        }
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                            List<Challenger> topPlayers = Main.instance.getDailyChallenge().getTopPlayers(this.numberOfRewardedPlayer);
                            Main.db.removeTopYesterday();
                            Main.db.saveTopYesterday(Main.instance.getDailyChallenge().getTopPlayers(this.numberOfTop));
                            if (Main.instance.getConfigGesture().isBackupEnabled()) {
                                Main.db.backupDb(Main.instance.getConfigGesture().getNumberOfFilesInFolderForBackup());
                            }
                            int number = Main.db.lastDailyWinnerId();
                            Random random = new Random();
                            if (Main.instance.getDailyChallenge().isMinimumPointsReached()) {
                                for (int z = 0; z < topPlayers.size(); ++z) {
                                    int placeInTop = z;
                                    int rewardsSize = Main.instance.getDailyChallenge().getRewards().size();
                                    if (z >= rewardsSize) {
                                        placeInTop = rewardsSize - 1;
                                    }
                                    ++number;
                                    DailyWinner dailyWinner = new DailyWinner();
                                    dailyWinner.setPlayerName(topPlayers.get(z).getNomePlayer());
                                    dailyWinner.setNomeChallenge(Main.instance.getDailyChallenge().getChallengeName());
                                    if (this.rankingReward) {
                                        dailyWinner.setId(number);
                                        dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(placeInTop));
                                        Main.db.insertDailyWinner(dailyWinner);
                                        continue;
                                    }
                                    if (this.randomReward) {
                                        dailyWinner.setId(number);
                                        dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(random.nextInt(rewardsSize)));
                                        Main.db.insertDailyWinner(dailyWinner);
                                        continue;
                                    }
                                    for (int i = 0; i < rewardsSize; ++i) {
                                        dailyWinner.setId(number);
                                        dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(i));
                                        Main.db.insertDailyWinner(dailyWinner);
                                        ++number;
                                    }
                                }
                            }
                            Main.db.deleteChallengeWithName(Main.db.getChallenges().get(0).getChallengeName());
                            Main.db.resumeOldPoints();
                            if (Main.challengeSelected) {
                                Main.instance.getDailyChallenge().clearPlayers();
                                for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                                    interfaces.getValue().closeAllInventories();
                                }
                            }
                            Main.instance.getConfigGesture().getTasks().stopAllTasks();
                            Main.instance.unregisterCurrentListener();
                            Main.instance.pluginStartingProcess();
                        });
                        break;
                    }
                    if (args[1].equalsIgnoreCase("random")) {
                        challenges = Main.db.getChallenges();
                        if (!challenges.isEmpty() && challenges.get(0).getChallengeName().contains("Event_")) {
                            MessageGesture.sendMessage(sender, this.alreadyStartEvent);
                            break;
                        }
                        Random random = new Random();
                        int sizeChallenges = random.nextInt(Main.instance.getConfigGesture().getChallengesEvent().size() - 1);
                        int i = 0;
                        Challenge challengeSelected = null;
                        for (Map.Entry<String, Challenge> challenge : Main.instance.getConfigGesture().getChallengesEvent().entrySet()) {
                            if (i == sizeChallenges) {
                                challengeSelected = challenge.getValue();
                                break;
                            }
                            ++i;
                        }
                        if (!rowTime.equalsIgnoreCase("")) {
                            challengeSelected = challengeSelected.cloneChallenge(rowTime);
                        }
                        String string = challengeSelected.getChallengeName();
                        long milliseconds = challengeSelected.getTimeChallenge().getMilliseconds();
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                            Main.db.insertChallengeEvent(challengeName, milliseconds);
                            if (Main.challengeSelected) {
                                Main.db.saveOldPointsForChallengeEvents();
                                Main.instance.getDailyChallenge().clearPlayers();
                                for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                                    interfaces.getValue().closeAllInventories();
                                }
                            }
                            Main.instance.getConfigGesture().getTasks().stopAllTasks();
                            Main.instance.unregisterCurrentListener();
                            Main.instance.pluginStartingProcess();
                        });
                        break;
                    }
                    if (Main.instance.getConfigGesture().getChallengesEvent().get(args[1]) != null) {
                        if (!sender.hasPermission("vc.event.start.command")) {
                            MessageGesture.sendMessage(sender, this.errorNoPerms);
                            break;
                        }
                        challenges = Main.db.getChallenges();
                        if (!challenges.isEmpty() && challenges.get(0).getChallengeName().contains("Event_")) {
                            MessageGesture.sendMessage(sender, this.alreadyStartEvent);
                            break;
                        }
                        Challenge challengeSelected = Main.instance.getConfigGesture().getChallengesEvent().get(args[1]);
                        if (!rowTime.equalsIgnoreCase("")) {
                            challengeSelected = challengeSelected.cloneChallenge(rowTime);
                        }
                        String challengeName = challengeSelected.getChallengeName();
                        long milliseconds = challengeSelected.getTimeChallenge().getMilliseconds();
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                            Main.db.insertChallengeEvent(challengeName, milliseconds);
                            if (Main.challengeSelected) {
                                Main.db.saveOldPointsForChallengeEvents();
                                Main.instance.getDailyChallenge().clearPlayers();
                                for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                                    interfaces.getValue().closeAllInventories();
                                }
                            }
                            Main.instance.getConfigGesture().getTasks().stopAllTasks();
                            Main.instance.unregisterCurrentListener();
                            Main.instance.pluginStartingProcess();
                        });
                        break;
                    }
                    if (!sender.hasPermission("vc.event.start.command") || !sender.hasPermission("vc.event.stop.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    StringBuilder send = new StringBuilder("\n");
                    for (Map.Entry<String, Challenge> challenge : Main.instance.getConfigGesture().getChallengesEvent().entrySet()) {
                        send.append(this.challengeOfList.replace("{challenge}", challenge.getKey())).append("\n");
                    }
                    MessageGesture.sendMessage(sender, this.challengeList.replace("{challengeList}", send.toString()));
                    break;
                }
                case "list": {
                    if (!(sender instanceof Player)) {
                        MessageGesture.sendMessage(sender, this.errorYouAreNotAPlayer);
                        break;
                    }
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (!sender.hasPermission("vc.list.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length != 1) {
                        MessageGesture.sendMessage(sender, this.commandVcList);
                        break;
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                        int size = Main.instance.getConfigGesture().getInterfaces().get("Challenges").getSizeModificableSlot();
                        ArrayList<Challenge> challenges = new ArrayList<Challenge>();
                        for (Challenge challenge : Main.db.getChallenges()) {
                            if (challenges.size() >= size) continue;
                            challenges.add(challenge);
                        }
                        Main.instance.getConfigGesture().getInterfaces().get("Challenges").openInterface(challenges, (Player)sender, 1);
                    });
                    break;
                }
                case "next": {
                    boolean skipPeacefulTime;
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (!sender.hasPermission("vc.next.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length > 2) {
                        MessageGesture.sendMessage(sender, this.commandVcNextHelp);
                        break;
                    }
                    boolean bl = skipPeacefulTime = args.length != 1;
                    if (Main.db.getChallenges().get(0).getChallengeName().contains("Event_")) {
                        MessageGesture.sendMessage(sender, this.alreadyStartEvent);
                        break;
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> Main.instance.getDailyChallenge().nextChallenge(this.resetPoints, this.rankingReward, this.randomReward, this.numberOfRewardedPlayer, this.numberOfTop, "Command Execution", skipPeacefulTime));
                    break;
                }
                case "points": {
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (!sender.hasPermission("vc.points.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length > 2) {
                        MessageGesture.sendMessage(sender, this.commandVcPointsHelp);
                        break;
                    }
                    if (args.length == 1) {
                        if (sender instanceof Player) {
                            long points = Main.instance.getDailyChallenge().getPointFromPLayerName(sender.getName());
                            MessageGesture.sendMessage(sender, this.pointsInfo.replace("{player}", this.pointsPlayerPlaceholder).replace("{number}", "" + points));
                            break;
                        }
                        MessageGesture.sendMessage(sender, this.errorYouAreNotAPlayer);
                        break;
                    }
                    if (!sender.hasPermission("vc.points.admin.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    long points = Main.instance.getDailyChallenge().getPointFromPLayerName(args[1]);
                    MessageGesture.sendMessage(sender, this.pointsInfo.replace("{player}", args[1]).replace("{number}", "" + points));
                    break;
                }
                case "reload": {
                    if (!sender.hasPermission("vc.reload.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length != 1) {
                        MessageGesture.sendMessage(sender, this.commandVcReloadHelp);
                        break;
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                        MessageGesture.sendMessage(sender, "&6Reloading...");
                        ReloadGesture.reload(Main.instance.getName());
                        MessageGesture.sendMessage(sender, "&aReloaded!");
                    });
                    break;
                }
                case "remove": {
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (!sender.hasPermission("vc.remove.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length > 2) {
                        MessageGesture.sendMessage(sender, this.commandVcEconomyChallenge);
                        break;
                    }
                    Main.instance.getDailyChallenge().incrementCommands(args[1], -Long.parseLong(args[2]));
                    MessageGesture.sendMessage(sender, this.pointsremove.replace("{points}", args[2]).replace("{player}", args[1]));
                    break;
                }
                case "reward": {
                    if (!(sender instanceof Player)) {
                        MessageGesture.sendMessage(sender, this.errorYouAreNotAPlayer);
                        break;
                    }
                    if (!sender.hasPermission("vc.reward.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length > 1) {
                        MessageGesture.sendMessage(sender, this.commandVcReward);
                        break;
                    }
                    List<DailyWinner> winners = Main.db.getDailyWinners();
                    if (winners.isEmpty()) break;
                    DailyGiveWinners.getRewardsAtPlayers((Player)sender, winners);
                    break;
                }
                case "restore": {
                    if (args.length > 3) {
                        MessageGesture.sendMessage(sender, this.commandVcRestore);
                        break;
                    }
                    if (args.length == 1) {
                        File folder = new File(Main.instance.getDataFolder() + File.separator + "backup");
                        StringBuilder finale = new StringBuilder("\n" + this.fileList + "\n");
                        for (int i = 0; i < folder.listFiles().length; ++i) {
                            if (folder.listFiles()[i].length() == 0L) continue;
                            finale.append(this.fileLine.replace("{fileName}", folder.listFiles()[i].getName() + "\n"));
                        }
                        MessageGesture.sendMessage(sender, finale.toString());
                        break;
                    }
                    File configFile = new File(Main.instance.getDataFolder() + File.separator + "backup", args[1]);
                    Main.db.clearAll();
                    YamlConfiguration file = YamlConfiguration.loadConfiguration((File)configFile);
                    if (file.getConfigurationSection("Challenges") != null) {
                        for (String string : file.getConfigurationSection("Challenges").getKeys(true)) {
                            Main.db.insertChallenge(string, file.getInt("Challenges." + string));
                        }
                    }
                    if (file.getConfigurationSection("Points") != null) {
                        for (String string : file.getConfigurationSection("Points").getKeys(true)) {
                            Main.db.insertChallenger(string, file.getInt("Points." + string));
                        }
                    }
                    if (file.getConfigurationSection("DailyWinners") != null) {
                        for (String string : file.getConfigurationSection("DailyWinners").getKeys(false)) {
                            Main.db.insertDailyWinner(new DailyWinner(Integer.parseInt(string), file.getString("DailyWinners." + string + ".PlayerName"), file.getString("DailyWinners." + string + ".NomeChallenge"), file.getString("DailyWinners." + string + ".Reward")));
                        }
                    }
                    if (file.getConfigurationSection("TopYesterday") != null) {
                        H2Database h2 = (H2Database)Main.db;
                        for (String winnerYesterday : file.getConfigurationSection("TopYesterday").getKeys(true)) {
                            h2.insertChallengerTopYesterday(winnerYesterday, file.getInt("TopYesterday." + winnerYesterday));
                        }
                    }
                    MessageGesture.sendMessage(sender, this.succesfullyRestored);
                    if (Main.challengeSelected) {
                        Main.instance.getDailyChallenge().clearPlayers();
                        for (Map.Entry entry : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                            ((Interface)entry.getValue()).closeAllInventories();
                        }
                    }
                    Main.instance.getConfigGesture().getTasks().stopAllTasks();
                    Main.instance.unregisterCurrentListener();
                    Main.instance.pluginStartingProcess();
                    break;
                }
                case "schedule": {
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (args.length < 2 || args.length > 4) {
                        MessageGesture.sendMessage(sender, this.commandVcSchedule);
                        break;
                    }
                    Challenge challenge1 = null;
                    if (args.length >= 3) {
                        challenge1 = Main.instance.getConfigGesture().getChallenges().get(args[2]);
                    }
                    if (args[1].equalsIgnoreCase("add")) {
                        void var15_55;
                        int find;
                        if (!sender.hasPermission("vc.schedule.add.command")) {
                            MessageGesture.sendMessage(sender, this.errorNoPerms);
                            break;
                        }
                        if (challenge1 == null && !args[2].equalsIgnoreCase("random")) {
                            StringBuilder stringBuilder = new StringBuilder("\n");
                            for (Map.Entry<String, Challenge> challenge : Main.instance.getConfigGesture().getChallengesEvent().entrySet()) {
                                stringBuilder.append(this.challengeOfList.replace("{challenge}", challenge.getKey())).append("\n");
                            }
                            MessageGesture.sendMessage(sender, this.challengeList.replace("{challengeList}", stringBuilder.toString()));
                            break;
                        }
                        if (args[2].equalsIgnoreCase("random")) {
                            List<Challenge> list = Main.db.getChallenges();
                            ArrayList<Challenge> remainChallenges = new ArrayList<Challenge>();
                            for (Map.Entry<String, Challenge> challenge : Main.instance.getConfigGesture().getChallenges().entrySet()) {
                                find = 0;
                                for (Challenge challenge2 : list) {
                                    if (!challenge.getKey().equalsIgnoreCase(challenge2.getChallengeName())) continue;
                                    find = 1;
                                    break;
                                }
                                if (find != 0) continue;
                                remainChallenges.add(challenge.getValue());
                            }
                            if (remainChallenges.isEmpty()) {
                                MessageGesture.sendMessage(sender, this.addError);
                                break;
                            }
                            Collections.shuffle(remainChallenges);
                            challenge1 = (Challenge)remainChallenges.get(0);
                        }
                        if (Main.db.isChallengePresent(challenge1.getChallengeName())) {
                            MessageGesture.sendMessage(sender, this.addError);
                            break;
                        }
                        String string = "";
                        if (args.length == 4) {
                            String string2 = args[3];
                            String typeTime = string2.charAt(string2.length() - 1) + "";
                            try {
                                find = Integer.parseInt(string2.replace(typeTime, ""));
                            }
                            catch (NumberFormatException e) {
                                MessageGesture.sendMessage(sender, this.timeError.replace("{value}", string2));
                                break;
                            }
                        }
                        Challenge finalChallenge = var15_55.equalsIgnoreCase("") ? challenge1 : challenge1.cloneChallenge((String)var15_55);
                        Challenge challengeSelected = finalChallenge;
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                            Main.db.addChallenge(challengeSelected);
                            Main.db.insertChallenge(challengeSelected.getChallengeName(), challengeSelected.getTimeChallenge().getMilliseconds());
                            MessageGesture.sendMessage(sender, this.addSuccess);
                            if (Main.challengeSelected) {
                                Main.instance.getDailyChallenge().clearPlayers();
                                for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                                    interfaces.getValue().closeAllInventories();
                                }
                            }
                            Main.instance.getConfigGesture().getTasks().stopAllTasks();
                            Main.instance.unregisterCurrentListener();
                            Main.instance.pluginStartingProcess();
                        });
                        break;
                    }
                    if (args[1].equalsIgnoreCase("remove")) {
                        if (!sender.hasPermission("vc.schedule.remove.command")) {
                            MessageGesture.sendMessage(sender, this.errorNoPerms);
                            break;
                        }
                        if (challenge1 == null) {
                            StringBuilder stringBuilder = new StringBuilder("\n");
                            for (Challenge challenge : Main.db.getChallenges()) {
                                stringBuilder.append(this.challengeOfList.replace("{challenge}", challenge.getChallengeName())).append("\n");
                            }
                            MessageGesture.sendMessage(sender, this.challengeList.replace("{challengeList}", stringBuilder.toString()));
                            break;
                        }
                        if (Main.instance.getDailyChallenge().getChallengeName().equalsIgnoreCase(args[2])) {
                            MessageGesture.sendMessage(sender, this.scheduleError);
                            break;
                        }
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                            Main.db.deleteChallengeWithName(args[2]);
                            MessageGesture.sendMessage(sender, this.removeSuccess);
                            if (Main.challengeSelected) {
                                Main.instance.getDailyChallenge().clearPlayers();
                                for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                                    interfaces.getValue().closeAllInventories();
                                }
                            }
                            Main.instance.getConfigGesture().getTasks().stopAllTasks();
                            Main.instance.unregisterCurrentListener();
                            Main.instance.pluginStartingProcess();
                        });
                        break;
                    }
                    if (args[1].equalsIgnoreCase("disable")) {
                        if (!sender.hasPermission("vc.schedule.disable.command")) {
                            MessageGesture.sendMessage(sender, this.errorNoPerms);
                            break;
                        }
                        if (Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                            MessageGesture.sendMessage(sender, this.alreadyDisable);
                            break;
                        }
                        Main.instance.getConfigGesture().setChallengeGeneration("Nothing");
                        Main.instance.unregisterCurrentListener();
                        Main.instance.getConfigGesture().getTasks().stopAllTasks();
                        Main.instance.pluginStartingProcess();
                        break;
                    }
                    MessageGesture.sendMessage(sender, this.commandVcSchedule);
                    break;
                }
                case "time": {
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (args.length < 2 || args.length > 3) {
                        MessageGesture.sendMessage(sender, this.commandVcTime);
                        break;
                    }
                    if (args.length == 3) {
                        Time timeRemaining;
                        void var18_88;
                        int time;
                        String string = args[2];
                        String typeTime = string.charAt(string.length() - 1) + "";
                        try {
                            time = Integer.parseInt(string.replace(typeTime, ""));
                        }
                        catch (NumberFormatException numberFormatException) {
                            MessageGesture.sendMessage(sender, this.timeError.replace("{value}", args[2]));
                            break;
                        }
                        switch (typeTime) {
                            case "s": {
                                Time time2 = new Time(0, 0, 0, time, ':');
                                break;
                            }
                            case "m": {
                                Time time3 = new Time(0, 0, time, 0, ':');
                                break;
                            }
                            case "h": {
                                Time time4 = new Time(0, time, 0, 0, ':');
                                break;
                            }
                            default: {
                                Time time5 = new Time(0, ':');
                            }
                        }
                        if (args[1].equalsIgnoreCase("add")) {
                            Main.instance.getDailyChallenge().addTime((Time)var18_88);
                            timeRemaining = Main.instance.getDailyChallenge().getTimeChallenge();
                            MessageGesture.sendMessage(sender, this.timeAdd.replace("{time}", args[2]).replace("{hours}", timeRemaining.getHours() + "").replace("{minutes}", timeRemaining.getMinutes() + "").replace("{seconds}", timeRemaining.getSeconds() + ""));
                            break;
                        }
                        if (args[1].equalsIgnoreCase("remove")) {
                            Main.instance.getDailyChallenge().removeTime((Time)var18_88);
                            timeRemaining = Main.instance.getDailyChallenge().getTimeChallenge();
                            MessageGesture.sendMessage(sender, this.timeRemove.replace("{time}", args[2]).replace("{hours}", timeRemaining.getHours() + "").replace("{minutes}", timeRemaining.getMinutes() + "").replace("{seconds}", timeRemaining.getSeconds() + ""));
                            break;
                        }
                        if (args[1].equalsIgnoreCase("set")) {
                            if (var18_88.getMilliseconds() <= 0L) break;
                            Main.instance.getDailyChallenge().setTimeChallenge((Time)var18_88);
                            MessageGesture.sendMessage(sender, this.timeSet.replace("{time}", args[2]));
                            break;
                        }
                        Time timeRemain = Main.instance.getDailyChallenge().getTimeChallenge();
                        MessageGesture.sendMessage(sender, this.timeRemaining.replace("{hours}", timeRemain.getHours() + "").replace("{minutes}", timeRemain.getMinutes() + "").replace("{seconds}", timeRemain.getSeconds() + ""));
                        break;
                    }
                    Time time = Main.instance.getDailyChallenge().getTimeChallenge();
                    MessageGesture.sendMessage(sender, this.timeRemaining.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                    break;
                }
                case "top": {
                    void var15_65;
                    if (!Main.challengeSelected) {
                        if (!Main.db.checkPeacefulTime()) {
                            if (!Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Nothing")) {
                                sender.sendMessage(ChatColor.RED + "No DailyChallenge selected, check the configurations files and restart the plugin!");
                                break;
                            }
                            sender.sendMessage(ChatColor.RED + "No Scheduler enabled, remember for use the plugin now you have to use vc event command for start a challenge!");
                            break;
                        }
                        Time time = Main.db.getPeacefulTime();
                        MessageGesture.sendMessage(sender, this.cooldown.replace("{hours}", time.getHours() + "").replace("{minutes}", time.getMinutes() + "").replace("{seconds}", time.getSeconds() + ""));
                        break;
                    }
                    if (!sender.hasPermission("vc.top.command")) {
                        MessageGesture.sendMessage(sender, this.errorNoPerms);
                        break;
                    }
                    if (args.length > 2) {
                        MessageGesture.sendMessage(sender, this.commandVcTopHelp);
                        break;
                    }
                    ArrayList arrayList = new ArrayList();
                    if (args.length == 1) {
                        if (Main.instance.getConfigGesture().isYesterdayTop()) {
                            List<Challenger> list = Main.db.getTopYesterday();
                        } else {
                            List<Challenger> list = Main.instance.getDailyChallenge().getTopPlayers(this.numberOfTop);
                        }
                    } else if (args[1].equalsIgnoreCase("yesterday")) {
                        if (!sender.hasPermission("vc.top.yesterday.command")) {
                            MessageGesture.sendMessage(sender, this.errorNoPerms);
                            break;
                        }
                        List<Challenger> list = Main.db.getTopYesterday();
                    }
                    MessageGesture.sendMessage(sender, this.actuallyInTop);
                    int i = 1;
                    for (Challenger challenger : var15_65) {
                        MessageGesture.sendMessage(sender, Main.instance.getConfigGesture().getMessages().get("topPlayers" + i).replace("{number}", "" + i).replace("{player}", challenger.getNomePlayer()).replace("{points}", MoneyUtils.transform(challenger.getPoints())));
                        ++i;
                    }
                    break;
                }
                default: {
                    String finale = "\n\n&e&l" + Main.instance.getName() + "&7 \u25cf Version " + Main.instance.getDescription().getVersion() + " created by &a&leliotesta98 & xSavior_of_God\n&r\n";
                    if (sender.hasPermission("vc.add.command")) {
                        finale = finale + this.commandVcEconomyChallenge + "\n";
                    }
                    if (sender.hasPermission("vc.challenge.command")) {
                        finale = finale + this.commandVcChallenge + "\n";
                    }
                    if (sender.hasPermission("vc.clear.command")) {
                        finale = finale + this.commandVcClear + "\n";
                    }
                    if (sender.hasPermission("vc.event.start.command") || sender.hasPermission("vc.event.stop.command")) {
                        finale = finale + this.commandVcEvent + "\n";
                    }
                    if (sender.hasPermission("vc.list.command")) {
                        finale = finale + this.commandVcList + "\n";
                    }
                    if (sender.hasPermission("vc.next.command")) {
                        finale = finale + this.commandVcNextHelp + "\n";
                    }
                    if (sender.hasPermission("vc.points.command")) {
                        finale = finale + this.commandVcPointsHelp + "\n";
                    }
                    if (sender.hasPermission("vc.reload.command")) {
                        finale = finale + this.commandVcReloadHelp + "\n";
                    }
                    if (sender.hasPermission("vc.reward.command")) {
                        finale = finale + this.commandVcReward + "\n";
                    }
                    if (sender.hasPermission("vc.schedule.add.command") || sender.hasPermission("vc.schedule.remove.command")) {
                        finale = finale + this.commandVcSchedule + "\n";
                    }
                    if (sender.hasPermission("vc.time.add.command") || sender.hasPermission("vc.time.remove.command") || sender.hasPermission("vc.time.set.command")) {
                        finale = finale + this.commandVcTime + "\n";
                    }
                    if (sender.hasPermission("vc.top.command")) {
                        finale = finale + this.commandVcTopHelp + "\n";
                    }
                    finale = finale + "&r\n";
                    finale = finale + this.commandFooter;
                    MessageGesture.sendMessage(sender, finale);
                }
            }
            if (this.debugCommand) {
                debug.addLine("Commands execution time= " + (System.currentTimeMillis() - tempo));
                debug.debug();
            }
        });
        return false;
    }
}

