/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SheepDyeWoolEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.Plugin;

public class ColorSheepEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("ColorSheepEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");
    private final HashMap<Entity, String> sheepColored = new HashMap();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onColorSheep(SheepDyeWoolEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        if (this.sheepColored.containsKey(e.getEntity())) {
            String playerName = this.sheepColored.get(e.getEntity());
            String colorPlayer = e.getColor().toString();
            boolean playerSneaking = Bukkit.getPlayer((String)playerName).isSneaking();
            String worldName = Bukkit.getPlayer((String)playerName).getWorld().getName();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
                if (this.debugActive) {
                    this.debugUtils.addLine("PlayerColoring= " + playerName);
                }
                if (this.superiorSkyBlock2Enabled) {
                    if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                        if (this.debugActive) {
                            this.debugUtils.addLine("BlockBreakEvent Player is inside his own island");
                        }
                    } else {
                        if (this.debugActive) {
                            this.debugUtils.addLine("BlockBreakEvent Player isn't inside his own island");
                            this.debugUtils.addLine("BlockBreakEvent execution time= " + (System.currentTimeMillis() - tempo));
                            this.debugUtils.debug();
                        }
                        return;
                    }
                }
                if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                if (Controls.isSneaking(playerSneaking, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                if (Controls.isColor(colorPlayer, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                Main.instance.getDailyChallenge().increment(playerName, this.point);
                if (this.debugActive) {
                    this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
            });
            this.sheepColored.remove(e.getEntity());
        } else {
            if (e.getPlayer() == null || e.getEntity().getColor() == null) {
                if (this.debugActive) {
                    this.debugUtils.addLine("Player= " + e.getPlayer() + " EntityColor= " + e.getEntity().getColor());
                    this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
                return;
            }
            String playerName = e.getPlayer().getName();
            String colorPlayer = e.getColor().toString();
            boolean playerSneaking = e.getPlayer().isSneaking();
            String worldName = e.getPlayer().getWorld().getName();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
                if (this.debugActive) {
                    this.debugUtils.addLine("PlayerColoring= " + playerName);
                }
                if (!Controls.hasPermission(playerName)) {
                    return;
                }
                if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                if (Controls.isSneaking(playerSneaking, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                if (Controls.isColor(colorPlayer, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                Main.instance.getDailyChallenge().increment(playerName, this.point);
                if (this.debugActive) {
                    this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onRightClickSheep(PlayerInteractEntityEvent playerInteractEvent) {
        if (!Main.version.isInRange(8, 12)) {
            return;
        }
        if (playerInteractEvent.getRightClicked().toString().equalsIgnoreCase("CraftSheep")) {
            this.sheepColored.put(playerInteractEvent.getRightClicked(), playerInteractEvent.getPlayer().getName());
        }
    }
}

