/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class DamageEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("DamageEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDamage(EntityDamageEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        String causePlayer = e.getCause().toString();
        Entity entity = e.getEntity();
        double finalDamage = e.getFinalDamage();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (entity instanceof Player) {
                String playerName = ((Player)entity).getPlayer().getName();
                String worldName = entity.getWorld().getName();
                if (this.debugActive) {
                    this.debugUtils.addLine("PlayerDamaging= " + playerName);
                }
                if (this.superiorSkyBlock2Enabled) {
                    if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                        if (this.debugActive) {
                            this.debugUtils.addLine("Player is inside his own island");
                        }
                    } else {
                        if (this.debugActive) {
                            this.debugUtils.addLine("Player isn't inside his own island");
                            this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                            this.debugUtils.debug();
                        }
                        return;
                    }
                }
                if (!Controls.hasPermission(playerName)) {
                    return;
                }
                if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                if (Controls.isCause(causePlayer, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                double damage = finalDamage * (double)this.point;
                if (damage > 0.0) {
                    Main.instance.getDailyChallenge().increment(playerName, (long)finalDamage * (long)this.point);
                }
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

