/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EatEvent
implements Listener {
    private final HashMap<String, Integer> foodLevels = new HashMap();
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("EatEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onFoodLevelChange(FoodLevelChangeEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        String playerName = e.getEntity().getName();
        String worldName = e.getEntity().getWorld().getName();
        int foodLevel = e.getFoodLevel();
        ItemStack itemUsedByPlayer = e.getEntity().getInventory().getItemInHand();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerEating= " + playerName);
            }
            if (this.foodLevels.get(playerName) == null) {
                this.foodLevels.put(playerName, Math.min(foodLevel, 20));
                Main.instance.getDailyChallenge().increment(playerName, Math.abs(this.point));
            } else {
                int number = foodLevel - this.foodLevels.get(playerName);
                this.foodLevels.remove(playerName);
                this.foodLevels.put(playerName, Math.min(foodLevel, 20));
                if (!Controls.hasPermission(playerName)) {
                    return;
                }
                if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                if (Controls.isItem(itemUsedByPlayer.getType().toString(), this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                Main.instance.getDailyChallenge().increment(playerName, (long)number * (long)Math.abs(this.point));
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

