/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class InventoryCheck {
    private final DebugUtils debugUtils = new DebugUtils("InventoryCheck");
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("Inventory");
    private final int numberSlot = Main.instance.getDailyChallenge().getNumber();
    private final int timeTaskInMinute = Main.instance.getDailyChallenge().getMinutes();
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final List<String> items = Main.instance.getDailyChallenge().getItems();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    public InventoryCheck() {
        this.start();
    }

    public void start() {
        this.execute();
    }

    public void execute() {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            long tempo = System.currentTimeMillis();
            for (Player p : Bukkit.getOnlinePlayers()) {
                String worldName = p.getWorld().getName();
                if (this.superiorSkyBlock2Enabled) {
                    if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(p.getName()))) {
                        if (this.debugActive) {
                            this.debugUtils.addLine("Player is inside his own island");
                        }
                    } else {
                        if (!this.debugActive) continue;
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                        continue;
                    }
                }
                if (!Controls.hasPermission(p.getName())) {
                    return;
                }
                if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) continue;
                int sizeInventory = 0;
                boolean itemCheck = this.items.isEmpty();
                block1: for (int i = 0; i < p.getInventory().getStorageContents().length; ++i) {
                    if (p.getInventory().getItem(i) == null) continue;
                    ++sizeInventory;
                    for (String item : this.items) {
                        if (!p.getInventory().getItem(i).getType().toString().equalsIgnoreCase(item) || itemCheck) continue;
                        itemCheck = true;
                        break block1;
                    }
                }
                if (this.debugActive) {
                    this.debugUtils.addLine("Player= " + p.getName());
                    this.debugUtils.addLine("InventorySizePlayer= " + sizeInventory);
                    this.debugUtils.addLine("InventorySizeConfig= " + this.numberSlot);
                    this.debugUtils.addLine("InventoryItemConfig= " + this.items);
                    this.debugUtils.addLine("InventoryItemCheck= " + itemCheck);
                }
                if (this.numberSlot != -1) {
                    if (sizeInventory != this.numberSlot || !itemCheck) continue;
                    Main.instance.getDailyChallenge().increment(p.getName(), this.point);
                    continue;
                }
                if (!itemCheck) continue;
                Main.instance.getDailyChallenge().increment(p.getName(), this.point);
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        }, 0L, (long)this.timeTaskInMinute * 60L * 20L);
        Main.instance.getConfigGesture().getTasks().addExternalTasks(task, "InventoryEvent", false);
    }
}

