/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges.ItemCollector;

import io.eliotesta98.VanillaChallenges.Core.Main;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Database {
    private final FileConfiguration file;
    private final File configFile = new File(Main.instance.getDataFolder(), "itemCollectorDb.yml");

    public Database() {
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.file = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void loadChests(Map<String, Location> chestLocations) {
        if (!this.file.contains("Chest")) {
            return;
        }
        for (String playerName : this.file.getConfigurationSection("Chest").getKeys(false)) {
            String location = this.file.getString("Chest." + playerName);
            String[] locationSplitted = location.split(Pattern.quote("\\"));
            chestLocations.put(playerName, new Location(Bukkit.getWorld((String)locationSplitted[0]), (double)Integer.parseInt(locationSplitted[1]), (double)Integer.parseInt(locationSplitted[2]), (double)Integer.parseInt(locationSplitted[3])));
        }
    }

    public void insertChest(String playerName, Location location) {
        this.file.set("Chest." + playerName, (Object)(location.getWorld().getName() + "\\" + location.getBlockX() + "\\" + location.getBlockY() + "\\" + location.getBlockZ()));
        try {
            this.saveFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateChest(String playerName, Location chestLocation) {
        this.deleteChest(playerName);
        this.insertChest(playerName, chestLocation);
    }

    public void deleteChest(String playerName) {
        this.file.set("Chest." + playerName, null);
        try {
            this.saveFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteFile() {
        this.configFile.delete();
    }

    public void saveFile() throws IOException {
        this.file.save(this.configFile);
    }
}

