/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges.ItemCollector;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.heroxplugins.external.VanillaChallenges.de.tr7zw.NBTItem;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ItemCollector.Database;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ItemCollector
implements Listener {
    private static Database db;
    private final DebugUtils debugUtils = new DebugUtils("ItemCollector");
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("ItemCollector");
    private final String caseBroken = Main.instance.getConfigGesture().getMessages().get("Errors.CaseBroken");
    private final List<String> items = Main.instance.getDailyChallenge().getItems();
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final String errorAlreadyPlacedChest = Main.instance.getConfigGesture().getMessages().get("Errors.AlreadyPlacedChest");
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");
    final int number = 2400;
    private final Map<String, Location> chestLocation = new ConcurrentHashMap<String, Location>();

    public ItemCollector() {
        this.controlChest();
        db = new Database();
        db.loadChests(this.chestLocation);
        this.saveChests();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent e) {
        long tempo = System.currentTimeMillis();
        PlayerInventory playerInventory = e.getPlayer().getInventory();
        String playerName = e.getPlayer().getName();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> this.lambda$onPlayerJoin$0(playerName, (Inventory)playerInventory, tempo));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockPlace(BlockPlaceEvent e) {
        long tempo = System.currentTimeMillis();
        if (e.getBlockPlaced().getType() == Main.instance.getConfigGesture().getChestCollection().getType()) {
            NBTItem nbtItem;
            if (this.debugActive) {
                this.debugUtils.addLine("Player Place Block Name = " + e.getPlayer().getName());
            }
            if ((nbtItem = new NBTItem(e.getItemInHand())).getBoolean("vc.chest").booleanValue()) {
                if (this.debugActive) {
                    this.debugUtils.addLine("Location Place Chest = " + e.getBlockPlaced().getLocation());
                    this.debugUtils.addLine("Item in Hand = " + e.getItemInHand().getType());
                }
                if (this.chestLocation.get(e.getPlayer().getName()) == null) {
                    this.chestLocation.put(e.getPlayer().getName(), e.getBlockPlaced().getLocation());
                } else if (this.chestLocation.get(e.getPlayer().getName()).getBlockY() == -100) {
                    this.chestLocation.replace(e.getPlayer().getName(), this.chestLocation.get(e.getPlayer().getName()), e.getBlockPlaced().getLocation());
                } else {
                    e.setCancelled(true);
                    MessageGesture.sendMessage((CommandSender)e.getPlayer(), this.errorAlreadyPlacedChest);
                }
            }
        }
        if (this.debugActive) {
            this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
            this.debugUtils.debug();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockBreak(BlockBreakEvent e) {
        long tempo = System.currentTimeMillis();
        Block block = e.getBlock();
        if (block.getType() == Main.instance.getConfigGesture().getChestCollection().getType() && this.chestLocation.get(e.getPlayer().getName()) != null) {
            Location loc = this.chestLocation.get(e.getPlayer().getName());
            if (this.debugActive) {
                this.debugUtils.addLine("location chest= " + loc);
            }
            if (block.getX() == loc.getBlockX() && block.getY() == loc.getBlockY() && block.getZ() == loc.getBlockZ() && block.getWorld().getName().equalsIgnoreCase(loc.getWorld().getName())) {
                if (this.debugActive) {
                    this.debugUtils.addLine("location block = " + block.getLocation());
                }
                if (!Main.version.isInRange(8, 12)) {
                    e.setDropItems(false);
                } else {
                    e.setCancelled(true);
                    block.setType(Material.AIR);
                }
                this.chestLocation.replace(e.getPlayer().getName(), loc, new Location(Bukkit.getWorld((String)"world"), 0.0, -100.0, 0.0));
                e.getPlayer().getInventory().addItem(new ItemStack[]{Main.instance.getConfigGesture().getChestCollection()});
            }
        }
        if (this.debugActive) {
            this.debugUtils.addLine("Break Block Type = " + block.getType());
            this.debugUtils.addLine("Break Block Type Config = " + Main.instance.getConfigGesture().getChestCollection().getType());
            this.debugUtils.addLine("Player Name = " + e.getPlayer().getName());
            this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
            this.debugUtils.debug();
        }
    }

    public void controlChest() {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            long tempo = System.currentTimeMillis();
            if (!this.chestLocation.isEmpty()) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Location location;
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player Name = " + player.getName());
                    }
                    if (Main.instance.getConfigGesture().getTasks().isChallengeStart()) {
                        return;
                    }
                    if (this.chestLocation.get(player.getName()) == null || (location = this.chestLocation.get(player.getName())).getWorld() == null || location.getBlock().getType() != Main.instance.getConfigGesture().getChestCollection().getType()) continue;
                    String worldName = player.getWorld().getName();
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                        Chest chest = (Chest)location.getBlock().getState();
                        if (this.debugActive) {
                            this.debugUtils.addLine("Chest Location = " + location);
                        }
                        for (int i = 0; i < chest.getInventory().getSize(); ++i) {
                            ItemStack itemInv = chest.getInventory().getItem(i);
                            if (itemInv == null) continue;
                            int amount = itemInv.getAmount();
                            if (this.debugActive) {
                                this.debugUtils.addLine("Amount Item = " + amount);
                            }
                            if (this.superiorSkyBlock2Enabled) {
                                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(player.getName()))) {
                                    if (this.debugActive) {
                                        this.debugUtils.addLine("Player is inside his own island");
                                    }
                                } else {
                                    if (this.debugActive) {
                                        this.debugUtils.addLine("Player isn't inside his own island");
                                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                                        this.debugUtils.debug();
                                    }
                                    return;
                                }
                            }
                            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                                return;
                            }
                            if (this.items.isEmpty()) {
                                Main.instance.getDailyChallenge().increment(player.getName(), (long)this.point * (long)amount);
                                if (!Main.version.isInRange(8, 12)) {
                                    itemInv.setAmount(0);
                                    continue;
                                }
                                chest.getInventory().removeItem(new ItemStack[]{itemInv});
                                continue;
                            }
                            if (!this.items.contains(itemInv.getType().toString())) continue;
                            Main.instance.getDailyChallenge().increment(player.getName(), (long)this.point * (long)amount);
                            if (!Main.version.isInRange(8, 12)) {
                                itemInv.setAmount(0);
                                continue;
                            }
                            chest.getInventory().removeItem(new ItemStack[]{itemInv});
                        }
                    });
                }
            }
            if (this.debugActive) {
                this.debugUtils.addLine("Item in chest destroyed");
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        }, 0L, 2400L);
        Main.instance.getConfigGesture().getTasks().addExternalTasks(task, "ItemCollector", false);
    }

    public void saveChests() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Main.instance, () -> {
            ArrayList<String> chestBroken = new ArrayList<String>();
            for (Map.Entry<String, Location> location : this.chestLocation.entrySet()) {
                if (location.getValue().getWorld() == null) {
                    Player player = Bukkit.getPlayer((String)location.getKey());
                    if (player == null || !player.isOnline()) continue;
                    MessageGesture.sendMessage((CommandSender)player, this.caseBroken);
                    db.deleteChest(player.getName());
                    chestBroken.add(location.getKey());
                    player.getInventory().addItem(new ItemStack[]{Main.instance.getConfigGesture().getChestCollection()});
                    continue;
                }
                db.updateChest(location.getKey(), location.getValue());
            }
            if (!chestBroken.isEmpty()) {
                for (String playerName : chestBroken) {
                    this.chestLocation.remove(playerName);
                }
            }
        }, 0L, 1200L);
    }

    public static void deleteDb() {
        db.deleteFile();
    }

    private /* synthetic */ void lambda$onPlayerJoin$0(String playerName, Inventory playerInventory, long tempo) {
        if (this.chestLocation.get(playerName) == null && playerInventory.firstEmpty() != -1 && Controls.hasPermission(playerName)) {
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerJoinName = " + playerName);
            }
            this.chestLocation.put(playerName, new Location(Bukkit.getWorld((String)"world"), 0.0, -100.0, 0.0));
            playerInventory.addItem(new ItemStack[]{Main.instance.getConfigGesture().getChestCollection()});
        }
        if (this.debugActive) {
            this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
            this.debugUtils.debug();
        }
    }
}

