/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class MoveEvent
implements Listener {
    private final HashMap<String, Double> distances = new HashMap();
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("MoveEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onMove(PlayerMoveEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        if (e.getTo() == null) {
            if (this.debugActive) {
                this.debugUtils.addLine("EndLocation= null");
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
            return;
        }
        String playerName = e.getPlayer().getName();
        String worldName = e.getPlayer().getWorld().getName();
        Location from = e.getFrom();
        Location to = e.getTo();
        String materialFrom = from.getBlock().getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType().toString();
        String materialTo = to.getBlock().getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType().toString();
        String playerMaterialInHand = e.getPlayer().getInventory().getItemInHand().getType().toString();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerMoving= " + playerName);
            }
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (!Controls.hasPermission(playerName)) {
                return;
            }
            if (Controls.isItem(playerMaterialInHand, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isBlock(materialFrom, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isBlock(materialTo, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (this.distances.get(playerName) == null) {
                this.distances.put(playerName, from.distance(to));
            } else {
                double old = this.distances.get(playerName);
                double newDouble = old + from.distance(to);
                if (newDouble > 1.0) {
                    Main.instance.getDailyChallenge().increment(playerName, this.point);
                    this.distances.replace(playerName, newDouble - 1.0);
                } else {
                    this.distances.replace(playerName, newDouble);
                }
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

