/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.plugin.Plugin;

public class RaidEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("RaidEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onRaidFinishEvent(RaidFinishEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        if (e.getWinners().isEmpty()) {
            if (this.debugActive) {
                this.debugUtils.addLine("Winners= empty");
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
            return;
        }
        int totalWaves = e.getRaid().getTotalWaves();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            for (Player winner : e.getWinners()) {
                String worldName = winner.getWorld().getName();
                if (this.debugActive) {
                    this.debugUtils.addLine("RaidWinner= " + winner.getName());
                }
                if (this.superiorSkyBlock2Enabled) {
                    if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(winner.getName()))) {
                        if (this.debugActive) {
                            this.debugUtils.addLine("Player is inside his own island");
                        }
                    } else {
                        if (!this.debugActive) continue;
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                        continue;
                    }
                }
                if (!Controls.hasPermission(winner.getName())) {
                    return;
                }
                if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                    return;
                }
                Main.instance.getDailyChallenge().increment(winner.getName(), (long)totalWaves * (long)this.point);
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

