/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.plugin.Plugin;

public class SpongeAbsorbeEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("SpongeAbsorbEvent");
    private final HashMap<String, String> players = new HashMap();
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockPlace(BlockPlaceEvent e) {
        if (e.getBlockPlaced().getType().toString().equalsIgnoreCase("SPONGE")) {
            if (this.players.get(e.getBlockPlaced().getLocation().toString()) == null) {
                this.players.put(e.getBlockPlaced().getLocation().toString(), e.getPlayer().getName());
            } else {
                this.players.replace(e.getBlockPlaced().getLocation().toString(), e.getPlayer().getName());
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onAbsorb(SpongeAbsorbEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        Block spongeBlock = e.getBlock();
        int amount = e.getBlocks().size();
        String worldName = e.getBlock().getWorld().getName();
        String playerName = this.players.get(spongeBlock.getLocation().toString());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerAbsorbing= " + this.players.get(spongeBlock.getLocation().toString()));
            }
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (!Controls.hasPermission(playerName)) {
                return;
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (this.players.get(spongeBlock.getLocation().toString()) != null) {
                Main.instance.getDailyChallenge().increment(this.players.get(spongeBlock.getLocation().toString()), (long)amount * (long)this.point);
                this.players.remove(playerName);
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

