/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;

public class SprintEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("SprintEvent");
    private final HashMap<String, Boolean> players = new HashMap();
    private final HashMap<String, Double> distances = new HashMap();
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onSprint(PlayerToggleSprintEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        String blockWalk = e.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType().toString();
        String itemInHand = e.getPlayer().getInventory().getItemInHand().getType().toString();
        String worldName = e.getPlayer().getWorld().getName();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("ToggledSprintPlayer= " + e.getPlayer().getName());
                this.debugUtils.addLine("BlockStepOnPlayer= " + blockWalk);
                this.debugUtils.addLine("ItemInHandPlayer= " + itemInHand);
            }
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(e.getPlayer().getName()))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (!Controls.hasPermission(e.getPlayer().getName())) {
                return;
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isItem(itemInHand, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isBlock(blockWalk, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (this.players.get(e.getPlayer().getName()) != null) {
                boolean sprint = this.players.get(e.getPlayer().getName());
                if (sprint) {
                    this.players.replace(e.getPlayer().getName(), false);
                } else {
                    this.players.replace(e.getPlayer().getName(), true);
                }
            } else {
                this.players.put(e.getPlayer().getName(), true);
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onMove(PlayerMoveEvent e) {
        long tempo = System.currentTimeMillis();
        if (e.getTo() == null) {
            if (this.debugActive) {
                this.debugUtils.addLine("EndLocation= null");
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
            return;
        }
        String playerName = e.getPlayer().getName();
        Location from = e.getFrom();
        Location to = e.getTo();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerSprinting= " + playerName);
            }
            if (this.players.get(playerName) != null && this.players.get(playerName).booleanValue()) {
                if (this.distances.get(playerName) == null) {
                    this.distances.put(playerName, from.distance(to));
                } else {
                    double old = this.distances.get(playerName);
                    double newDouble = old + from.distance(to);
                    if (newDouble > 1.0) {
                        Main.instance.getDailyChallenge().increment(playerName, this.point);
                        this.distances.replace(playerName, newDouble - 1.0);
                    } else {
                        this.distances.replace(playerName, newDouble);
                    }
                }
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

