/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class VehicleMoveEvent
implements Listener {
    private final HashMap<String, Double> distances = new HashMap();
    private final DebugUtils debugUtils = new DebugUtils("VehicleMoveEvent");
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("VehicleMoveEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onMove(org.bukkit.event.vehicle.VehicleMoveEvent e) {
        long tempo = System.currentTimeMillis();
        ArrayList<String> players = new ArrayList<String>();
        if (!Main.version.isInRange(8, 12)) {
            for (Entity entity : e.getVehicle().getPassengers()) {
                if (!(entity instanceof Player)) continue;
                players.add(entity.getName());
            }
        } else {
            Entity entity = e.getVehicle().getPassenger();
            if (entity instanceof Player) {
                players.add(entity.getName());
            }
        }
        Location from = e.getFrom();
        Location to = e.getTo();
        Vehicle playerVehicle = e.getVehicle();
        String worldName = playerVehicle.getWorld().getName();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> this.lambda$onMove$0(players, tempo, worldName, (Entity)playerVehicle, from, to));
    }

    private /* synthetic */ void lambda$onMove$0(List players, long tempo, String worldName, Entity playerVehicle, Location from, Location to) {
        if (this.debugActive) {
            this.debugUtils.addLine("PlayersMoving= " + Arrays.toString(players.toArray()));
        }
        for (String playerName : players) {
            double old;
            double newDouble;
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (!Controls.hasPermission(playerName)) {
                return;
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (!Controls.isVehicle(playerVehicle.getType().toString(), this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (this.distances.get(playerName) == null) {
                this.distances.put(playerName, from.distance(to));
            }
            if ((newDouble = (old = this.distances.get(playerName).doubleValue()) + from.distance(to)) > 1.0) {
                Main.instance.getDailyChallenge().increment(playerName, this.point);
                this.distances.replace(playerName, newDouble - 1.0);
                continue;
            }
            this.distances.replace(playerName, newDouble);
        }
        if (this.debugActive) {
            this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
            this.debugUtils.debug();
        }
    }
}

