/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Modules.CubeGenerator;

import io.eliotesta98.CubeGenerator.api.CubeGeneratorAPI;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class CubeGeneratorEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("BlockBreakEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockPlace(BlockBreakEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        String blockBreaking = e.getBlock().getType().toString();
        Location blockLocation = e.getBlock().getLocation();
        String itemInMainHand = e.getPlayer().getInventory().getItemInMainHand().getType().toString();
        String playerName = e.getPlayer().getName();
        String worldName = e.getPlayer().getWorld().getName();
        boolean sneakingPlayer = e.getPlayer().isSneaking();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            int idCube = CubeGeneratorAPI.getGeneratorIdFromLocation((Location)blockLocation);
            if (this.debugActive) {
                this.debugUtils.addLine("BlockBreakEvent PlayerBreaking= " + playerName);
            }
            if (idCube == -1) {
                if (this.debugActive) {
                    this.debugUtils.addLine("BlockBreakEvent IdGeneratorInvalid= " + idCube);
                    this.debugUtils.addLine("BlockBreakEvent execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
                return;
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isSneaking(sneakingPlayer, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isBlock(blockBreaking, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isItemInHand(itemInMainHand, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            Main.instance.getDailyChallenge().increment(playerName, this.point);
            if (this.debugActive) {
                this.debugUtils.addLine("BlockBreakEvent execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

