/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Utils;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.HeroxWar.HeroxCore.TimeGesture.Time;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Database.Objects.Challenger;
import io.eliotesta98.VanillaChallenges.Database.Objects.DailyWinner;
import io.eliotesta98.VanillaChallenges.Database.Objects.PlayerStats;
import io.eliotesta98.VanillaChallenges.Events.ApiEvents.ChallengeChangeEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ItemCollector.ItemCollector;
import io.eliotesta98.VanillaChallenges.Interfaces.Interface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Challenge {
    private final Map<String, Long> players = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> min10PlayersPoints = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> boostSinglePlayers = new ConcurrentHashMap<String, Long>();
    private final Map<String, Boolean> startBoostSinglePlayers = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, BukkitTask> tasksSinglePlayers = new ConcurrentHashMap<String, BukkitTask>();
    private List<String> worlds = new ArrayList<String>();
    private String challengeName = "nessuna";
    private String itemChallenge = "BEDROCK";
    private List<String> blocks = new ArrayList<String>();
    private List<String> blocksOnPlaced = new ArrayList<String>();
    private String typeChallenge = "nessuna";
    private List<String> rewards = new ArrayList<String>();
    private List<String> title = new ArrayList<String>();
    private List<String> items = new ArrayList<String>();
    private List<String> itemsInHand = new ArrayList<String>();
    private List<String> mobs = new ArrayList<String>();
    private List<String> colors = new ArrayList<String>();
    private List<String> causes = new ArrayList<String>();
    private List<String> vehicles = new ArrayList<String>();
    private double force = 0.0;
    private double power = 0.0;
    private int number = 0;
    private String startTimeChallenge = "0:00";
    private String onGround = "NOBODY";
    private boolean keepInventory = false;
    final int timeNumber = 1200;
    private BukkitTask task;
    private BukkitTask boostingTask;
    int point = 1;
    private int pointsBoost = 0;
    private int multiplier = 1;
    private int boostMinutes = 0;
    private int pointsBoostSinglePlayer = 0;
    private int multiplierSinglePlayer = 1;
    private int minutesSinglePlayer = 0;
    private Time timeChallenge = new Time();
    private String endTimeChallenge = "24:00";
    private String nameChallenge = "NOBODY";
    private boolean deathInLand = false;
    private long countPointsChallenge = 0L;
    private boolean startBoost = false;
    private String sneaking = "NOBODY";
    private List<String> quests = new ArrayList<String>();
    int minutes = 1;
    private static final Pattern blockOnPlacedPattern = Pattern.compile("\\{blockOnPlaced[0-9]}");
    private static final Pattern blockPattern = Pattern.compile("\\{block[0-9]}");
    private static final Pattern worldPattern = Pattern.compile("\\{world[0-9]}");
    private static final Pattern itemPattern = Pattern.compile("\\{item[0-9]}");
    private static final Pattern itemInHandPattern = Pattern.compile("\\{itemInHand[0-9]}");
    private static final Pattern vehiclePattern = Pattern.compile("\\{vehicle[0-9]}");
    private static final Pattern causePattern = Pattern.compile("\\{cause[0-9]}");
    private static final Pattern colorPattern = Pattern.compile("\\{color[0-9]}");
    private static final Pattern mobPattern = Pattern.compile("\\{mob[0-9]}");

    public Challenge() {
    }

    public Challenge(String nameChallenge, List<String> blocks, List<String> blocksOnPlaced, String typeChallenge, List<String> rewards, List<String> title, List<String> items, List<String> itemsInHand, List<String> mobs, double force, double power, List<String> colors, List<String> causes, int point, int pointsBoost, int multiplier, int boostMinutes, int number, String challengeDuration, List<String> vehicles, String sneaking, String onGround, int pointsBoostSinglePlayer, int multiplierSinglePlayer, int minutesSinglePlayer, String endTimeChallenge, String challengeName, List<String> quests, int minutes, String startTimeChallenge, boolean keepInventory, boolean deathInLand, List<String> worlds, String itemChallenge) {
        this.blocks = blocks;
        this.worlds = worlds;
        this.blocksOnPlaced = blocksOnPlaced;
        this.typeChallenge = typeChallenge;
        this.rewards = rewards;
        this.title = title;
        this.items = items;
        this.itemsInHand = itemsInHand;
        this.mobs = mobs;
        this.force = force;
        this.power = power;
        this.colors = colors;
        this.causes = causes;
        this.point = point;
        this.pointsBoost = pointsBoost;
        this.multiplier = multiplier;
        this.boostMinutes = boostMinutes;
        this.number = number;
        this.vehicles = vehicles;
        this.sneaking = sneaking;
        this.onGround = onGround;
        this.pointsBoostSinglePlayer = pointsBoostSinglePlayer;
        this.minutesSinglePlayer = minutesSinglePlayer;
        this.multiplierSinglePlayer = multiplierSinglePlayer;
        this.endTimeChallenge = endTimeChallenge;
        this.challengeName = challengeName;
        this.quests = quests;
        this.minutes = minutes;
        this.startTimeChallenge = startTimeChallenge;
        this.keepInventory = keepInventory;
        this.nameChallenge = nameChallenge;
        this.deathInLand = deathInLand;
        this.itemChallenge = itemChallenge;
        this.timeChallenge(challengeDuration);
    }

    private void timeChallenge(String challengeDuration) {
        String typeTime = challengeDuration.charAt(challengeDuration.length() - 1) + "";
        int time = Integer.parseInt(challengeDuration.replace(typeTime, ""));
        if (time != 0) {
            switch (typeTime) {
                case "s": {
                    this.timeChallenge = new Time(0, 0, 0, time, ':');
                    break;
                }
                case "m": {
                    this.timeChallenge = new Time(0, 0, time, 0, ':');
                    break;
                }
                case "h": {
                    this.timeChallenge = new Time(0, time, 0, 0, ':');
                    break;
                }
                default: {
                    this.timeChallenge = new Time(time, ':');
                    break;
                }
            }
        } else {
            String[] startSplit = this.startTimeChallenge.split(":");
            String[] endSplit = this.endTimeChallenge.split(":");
            int hours = Integer.parseInt(endSplit[0]) - Integer.parseInt(startSplit[0]);
            int minutes = Integer.parseInt(endSplit[1]) - Integer.parseInt(startSplit[1]);
            this.timeChallenge = new Time(0, hours, minutes, 0, ':');
        }
    }

    public void addTime(Time time) {
        this.timeChallenge.sum(time);
    }

    public void removeTime(Time time) {
        this.timeChallenge.difference(time);
    }

    public Map<String, Long> getBoostSinglePlayers() {
        return this.boostSinglePlayers;
    }

    public int getPointsBoostSinglePlayer() {
        return this.pointsBoostSinglePlayer;
    }

    public int getMultiplierSinglePlayer() {
        return this.multiplierSinglePlayer;
    }

    public Map<String, Long> getMin10PlayersPoints() {
        return this.min10PlayersPoints;
    }

    public List<String> getCauses() {
        return this.causes;
    }

    public void setCauses(List<String> causes) {
        this.causes = causes;
    }

    public List<String> getColors() {
        return this.colors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public double getForce() {
        return this.force;
    }

    public void setForce(double force) {
        this.force = force;
    }

    public List<String> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<String> blocks) {
        this.blocks = blocks;
    }

    public List<String> getBlocksOnPlace() {
        return this.blocksOnPlaced;
    }

    public String getChallengeName() {
        return this.challengeName;
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    public Map<String, Long> getPlayers() {
        return this.players;
    }

    public void setPlayers(List<Challenger> challengers) {
        for (Challenger challenger : challengers) {
            this.players.put(challenger.getNomePlayer(), challenger.getPoints());
        }
    }

    public boolean isDeathInLand() {
        return this.deathInLand;
    }

    public List<String> getQuests() {
        return this.quests;
    }

    public void setQuests(List<String> quests) {
        this.quests = quests;
    }

    public String getTypeChallenge() {
        return this.typeChallenge;
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int point) {
        this.point = point;
    }

    public Time getTimeChallenge() {
        return this.timeChallenge;
    }

    public void setTimeChallenge(Time timeChallenge) {
        this.timeChallenge = timeChallenge;
    }

    public String getNameChallenge() {
        return this.nameChallenge;
    }

    public String getItemChallenge() {
        return this.itemChallenge;
    }

    public List<String> getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(List<String> vehicles) {
        this.vehicles = vehicles;
    }

    public void incrementCommands(String playerName, long amount) {
        if (Main.instance.getConfigGesture().getTasks().isChallengeStart()) {
            return;
        }
        if (!this.players.containsKey(playerName)) {
            this.players.put(playerName, amount);
        } else {
            this.players.replace(playerName, this.players.get(playerName) + amount);
        }
    }

    public void increment(String playerName, long amount) {
        if (Main.instance.getConfigGesture().getTasks().isChallengeStart()) {
            return;
        }
        if (!this.startBoostSinglePlayers.containsKey(playerName)) {
            this.startBoostSinglePlayers.put(playerName, false);
        }
        if (this.startBoost || this.startBoostSinglePlayers.get(playerName).booleanValue()) {
            if (this.startBoost) {
                if (!this.players.containsKey(playerName)) {
                    this.players.put(playerName, amount * (long)this.multiplier);
                } else {
                    this.players.replace(playerName, this.players.get(playerName) + amount * (long)this.multiplier);
                }
                if (!this.min10PlayersPoints.containsKey(playerName)) {
                    this.min10PlayersPoints.put(playerName, amount * (long)this.multiplier);
                } else {
                    this.min10PlayersPoints.replace(playerName, this.min10PlayersPoints.get(playerName) + amount * (long)this.multiplier);
                }
            }
            if (this.startBoostSinglePlayers.get(playerName).booleanValue()) {
                if (!this.players.containsKey(playerName)) {
                    this.players.put(playerName, amount * (long)this.multiplierSinglePlayer);
                } else {
                    this.players.replace(playerName, this.players.get(playerName) + amount * (long)this.multiplierSinglePlayer);
                }
                if (!this.min10PlayersPoints.containsKey(playerName)) {
                    this.min10PlayersPoints.put(playerName, amount * (long)this.multiplierSinglePlayer);
                } else {
                    this.min10PlayersPoints.replace(playerName, this.min10PlayersPoints.get(playerName) + amount * (long)this.multiplierSinglePlayer);
                }
            }
        } else {
            this.countPointsChallenge += amount;
            if (!this.players.containsKey(playerName)) {
                this.players.put(playerName, amount);
            } else {
                this.players.replace(playerName, this.players.get(playerName) + amount);
            }
            if (!this.min10PlayersPoints.containsKey(playerName)) {
                this.min10PlayersPoints.put(playerName, amount);
            } else {
                this.min10PlayersPoints.replace(playerName, this.min10PlayersPoints.get(playerName) + amount);
            }
            if (!this.boostSinglePlayers.containsKey(playerName)) {
                this.boostSinglePlayers.put(playerName, amount);
            } else {
                this.boostSinglePlayers.replace(playerName, this.boostSinglePlayers.get(playerName) + amount);
            }
            this.checkPointsMultiplier();
            this.checkPointsMultiplierSinglePlayer(playerName);
        }
    }

    public void clearPlayers() {
        this.stopTask();
        if (this.boostingTask != null) {
            this.stopTaskBoost();
        }
        this.players.clear();
        this.min10PlayersPoints.clear();
        this.boostSinglePlayers.clear();
        this.startBoostSinglePlayers.clear();
        for (Map.Entry<String, BukkitTask> task : this.tasksSinglePlayers.entrySet()) {
            task.getValue().cancel();
        }
    }

    public void savePoints() {
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            for (Map.Entry<String, Long> player : this.players.entrySet()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                    try {
                        if ((Long)player.getValue() > 0L) {
                            if (Main.db.isPresent((String)player.getKey())) {
                                Main.db.updateChallenger((String)player.getKey(), (Long)player.getValue());
                            } else {
                                Main.db.insertChallenger((String)player.getKey(), (Long)player.getValue());
                            }
                        }
                    }
                    catch (Exception ex) {
                        Bukkit.getServer().getConsoleSender().sendMessage("Save Points Runtime: " + ex.getMessage());
                    }
                });
            }
            if (this.startBoost && (this.boostingTask == null || this.boostingTask.isCancelled())) {
                this.startBoosting();
            }
        }, 0L, 1200L);
        Main.instance.getConfigGesture().getTasks().addExternalTasks(this.task, "SavePoints", false);
    }

    public void stopTask() {
        this.task.cancel();
    }

    public void stopTaskBoost() {
        this.boostingTask.cancel();
    }

    public long getPointFromPLayerName(String playerName) {
        if (this.players.get(playerName) == null) {
            return 0L;
        }
        return this.players.get(playerName);
    }

    public List<String> getRewards() {
        return this.rewards;
    }

    public void setRewards(List<String> rewards) {
        this.rewards = rewards;
    }

    public List<Challenger> getTopPlayers(int numberOfTops) {
        ArrayList<Challenger> topList = new ArrayList<Challenger>();
        try {
            Challenger challenger;
            for (int i = 0; i < numberOfTops && !(challenger = this.getChallenger(topList)).getNomePlayer().equalsIgnoreCase("Notch"); ++i) {
                topList.add(challenger);
            }
            return topList;
        }
        catch (Exception ex) {
            Bukkit.getServer().getConsoleSender().sendMessage("Top Players: " + ex.getMessage());
            return topList;
        }
    }

    private Challenger getChallenger(List<Challenger> topList) {
        Challenger challenger = new Challenger();
        for (Map.Entry<String, Long> player : this.players.entrySet()) {
            if (player.getValue() <= challenger.getPoints()) continue;
            boolean trovato = false;
            for (Challenger value : topList) {
                if (!value.getNomePlayer().equalsIgnoreCase(player.getKey())) continue;
                trovato = true;
                break;
            }
            if (trovato) continue;
            challenger = new Challenger(player.getKey(), player.getValue());
        }
        return challenger;
    }

    public boolean isMinimumPointsReached() {
        long count = 0L;
        for (long number : this.players.values()) {
            count += number;
        }
        return count >= (long)Main.instance.getConfigGesture().getMinimumPoints();
    }

    public long getPointsRemain() {
        long count = 0L;
        for (long number : this.players.values()) {
            count += number;
        }
        return (long)Main.instance.getConfigGesture().getMinimumPoints() - count;
    }

    public List<String> getTitle() {
        return this.title;
    }

    public void setTitle(List<String> title) {
        this.title = title;
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public List<String> getItemsInHand() {
        return this.itemsInHand;
    }

    public List<String> getMobs() {
        return this.mobs;
    }

    public void setMobs(List<String> mobs) {
        this.mobs = mobs;
    }

    public int getPointsBoost() {
        return this.pointsBoost;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public boolean isActive() {
        return this.startBoost || this.boostMinutes == 0 || this.multiplier == 1 || this.pointsBoost == 0;
    }

    public boolean isActiveSingleBoost(String playerName) {
        return this.startBoostSinglePlayers.getOrDefault(playerName, false);
    }

    public long getCountPointsChallenge() {
        return this.countPointsChallenge;
    }

    public long getCountPointsChallengeSinglePlayer(String playerName) {
        if (this.boostSinglePlayers.containsKey(playerName)) {
            return this.boostSinglePlayers.get(playerName);
        }
        return 0L;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public List<String> getVehicle() {
        return this.vehicles;
    }

    public void setVehicle(List<String> vehicles) {
        this.vehicles = vehicles;
    }

    public String getSneaking() {
        return this.sneaking;
    }

    public void setSneaking(String sneaking) {
        this.sneaking = sneaking;
    }

    public String getOnGround() {
        return this.onGround;
    }

    public void setOnGround(String onGround) {
        this.onGround = onGround;
    }

    public String getStartTimeChallenge() {
        return this.startTimeChallenge;
    }

    public boolean isKeepInventory() {
        return this.keepInventory;
    }

    public void setKeepInventory(boolean keepInventory) {
        this.keepInventory = keepInventory;
    }

    public List<String> getWorlds() {
        return this.worlds;
    }

    public void setWorlds(List<String> worlds) {
        this.worlds = worlds;
    }

    public String getEndTimeChallenge() {
        return this.endTimeChallenge;
    }

    public String toString() {
        return "Challenge{players=" + this.players + ", min10PlayersPoints=" + this.min10PlayersPoints + ", boostSinglePlayers=" + this.boostSinglePlayers + ", startBoostSinglePlayers=" + this.startBoostSinglePlayers + ", tasksSinglePlayers=" + this.tasksSinglePlayers + ", worlds=" + this.worlds + ", challengeName='" + this.challengeName + '\'' + ", blocks=" + this.blocks + ", blocksOnPlaced=" + this.blocksOnPlaced + ", typeChallenge='" + this.typeChallenge + '\'' + ", rewards=" + this.rewards + ", title=" + this.title + ", items=" + this.items + ", itemsInHand=" + this.itemsInHand + ", mobs=" + this.mobs + ", colors=" + this.colors + ", causes=" + this.causes + ", vehicles=" + this.vehicles + ", force=" + this.force + ", power=" + this.power + ", number=" + this.number + ", startTimeChallenge='" + this.startTimeChallenge + '\'' + ", onGround='" + this.onGround + '\'' + ", keepInventory=" + this.keepInventory + ", timeNumber=" + 1200 + ", task=" + this.task + ", boostingTask=" + this.boostingTask + ", point=" + this.point + ", pointsBoost=" + this.pointsBoost + ", multiplier=" + this.multiplier + ", boostMinutes=" + this.boostMinutes + ", pointsBoostSinglePlayer=" + this.pointsBoostSinglePlayer + ", multiplierSinglePlayer=" + this.multiplierSinglePlayer + ", minutesSinglePlayer=" + this.minutesSinglePlayer + ", timeChallenge=" + this.timeChallenge + ", nameChallenge='" + this.nameChallenge + '\'' + ", deathInLand=" + this.deathInLand + ", countPointsChallenge=" + this.countPointsChallenge + ", startBoost=" + this.startBoost + ", sneaking='" + this.sneaking + '\'' + ", quests=" + this.quests + ", minutes=" + this.minutes + '}';
    }

    private void checkPointsMultiplierSinglePlayer(String playerName) {
        if (this.minutesSinglePlayer == 0 && this.multiplierSinglePlayer == 1 && this.pointsBoostSinglePlayer == 0) {
            return;
        }
        if (this.boostSinglePlayers.get(playerName) >= (long)this.pointsBoostSinglePlayer) {
            this.boostSinglePlayers.remove(playerName);
            this.startBoostSinglePlayers.replace(playerName, this.startBoostSinglePlayers.get(playerName), this.startBoostSinglePlayers.get(playerName) == false);
            this.startBoostingSinglePlayer(playerName);
        }
    }

    private void startBoostingSinglePlayer(final String playerName) {
        BukkitTask boostSingleTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, new Runnable(){
            int number;
            final /* synthetic */ Challenge this$0;
            {
                this.this$0 = this$0;
                this.number = this.this$0.minutesSinglePlayer;
            }

            @Override
            public void run() {
                Player p;
                --this.number;
                if (this.number <= 0) {
                    BukkitTask task;
                    this.this$0.startBoostSinglePlayers.remove(playerName);
                    if (this.this$0.tasksSinglePlayers.containsKey(playerName) && (task = (BukkitTask)this.this$0.tasksSinglePlayers.get(playerName)) != null) {
                        task.cancel();
                    }
                    this.this$0.tasksSinglePlayers.remove(playerName);
                }
                if ((p = Bukkit.getPlayer((String)playerName)) != null) {
                    MessageGesture.sendMessage((CommandSender)p, Main.instance.getConfigGesture().getMessages().get("BoostMessageSinglePlayer").replace("{number}", this.this$0.multiplierSinglePlayer + "").replace("{minutes}", this.number + ""));
                }
            }
        }, 0L, 1200L);
        this.tasksSinglePlayers.put(playerName, boostSingleTask);
        Main.instance.getConfigGesture().getTasks().addExternalTasks(boostSingleTask, "SingleBoost", false);
    }

    private void checkPointsMultiplier() {
        if (this.boostMinutes == 0 && this.multiplier == 1 && this.pointsBoost == 0) {
            return;
        }
        if (this.countPointsChallenge >= (long)this.pointsBoost && !this.startBoost) {
            this.countPointsChallenge -= (long)this.pointsBoost;
            this.startBoost = true;
        }
    }

    private void startBoosting() {
        this.boostingTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, new Runnable(){
            int number;
            {
                this.number = Challenge.this.boostMinutes;
            }

            @Override
            public void run() {
                --this.number;
                if (this.number <= 0) {
                    Challenge.this.startBoost = false;
                    Challenge.this.boostingTask.cancel();
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    MessageGesture.sendMessage((CommandSender)p, Main.instance.getConfigGesture().getMessages().get("BoostMessage").replace("{number}", Challenge.this.multiplier + "").replace("{minutes}", this.number + ""));
                }
            }
        }, 0L, 1200L);
        Main.instance.getConfigGesture().getTasks().addExternalTasks(this.boostingTask, "GlobalBoost", false);
    }

    public void message(CommandSender sender) {
        ArrayList<String> title = new ArrayList<String>(this.title);
        for (int i = 0; i < title.size(); ++i) {
            Matcher matcherBlockPlaced = blockOnPlacedPattern.matcher((CharSequence)title.get(i));
            while (matcherBlockPlaced.find()) {
                String number = matcherBlockPlaced.group().replace("{blockOnPlaced", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.blocksOnPlaced.size()) {
                    title.set(i, ((String)title.get(i)).replace("{blockOnPlaced" + number + "}", this.blocksOnPlaced.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{blockOnPlaced" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {blockOnPlaced" + number + "}");
            }
            Matcher matcherBlock = blockPattern.matcher((CharSequence)title.get(i));
            while (matcherBlock.find()) {
                String number = matcherBlock.group().replace("{block", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.blocks.size()) {
                    title.set(i, ((String)title.get(i)).replace("{block" + number + "}", this.blocks.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{block" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {block" + number + "}");
            }
            Matcher matcherWorld = worldPattern.matcher((CharSequence)title.get(i));
            while (matcherWorld.find()) {
                String number = matcherWorld.group().replace("{world", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.worlds.size()) {
                    title.set(i, ((String)title.get(i)).replace("{world" + number + "}", this.worlds.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{world" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {world" + number + "}");
            }
            Matcher matcherItem = itemPattern.matcher((CharSequence)title.get(i));
            while (matcherItem.find()) {
                String number = matcherItem.group().replace("{item", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.items.size()) {
                    title.set(i, ((String)title.get(i)).replace("{item" + number + "}", this.items.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{item" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {item" + number + "}");
            }
            Matcher matcherItemInHand = itemInHandPattern.matcher((CharSequence)title.get(i));
            while (matcherItemInHand.find()) {
                String number = matcherItemInHand.group().replace("{itemInHand", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.itemsInHand.size()) {
                    title.set(i, ((String)title.get(i)).replace("{itemInHand" + number + "}", this.itemsInHand.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{itemInHand" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {itemInHand" + number + "}");
            }
            Matcher matcherVehicle = vehiclePattern.matcher((CharSequence)title.get(i));
            while (matcherVehicle.find()) {
                String number = matcherVehicle.group().replace("{vehicle", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.vehicles.size()) {
                    title.set(i, ((String)title.get(i)).replace("{vehicle" + number + "}", this.vehicles.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{vehicle" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {vehicle" + number + "}");
            }
            Matcher causeVehicle = causePattern.matcher((CharSequence)title.get(i));
            while (causeVehicle.find()) {
                String number = causeVehicle.group().replace("{cause", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.causes.size()) {
                    title.set(i, ((String)title.get(i)).replace("{cause" + number + "}", this.causes.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{cause" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {cause" + number + "}");
            }
            Matcher matcherColor = colorPattern.matcher((CharSequence)title.get(i));
            while (matcherColor.find()) {
                String number = matcherColor.group().replace("{color", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.colors.size()) {
                    title.set(i, ((String)title.get(i)).replace("{color" + number + "}", this.colors.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{color" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {color" + number + "}");
            }
            Matcher matcherMob = mobPattern.matcher((CharSequence)title.get(i));
            while (matcherMob.find()) {
                String number = matcherMob.group().replace("{mob", "").replace("}", "");
                int numberInt = Integer.parseInt(number);
                if (numberInt <= this.mobs.size()) {
                    title.set(i, ((String)title.get(i)).replace("{mob" + number + "}", this.mobs.get(Integer.parseInt(number) - 1)));
                    continue;
                }
                title.set(i, ((String)title.get(i)).replace("{mob" + number + "}", "&cDELETE PLACEHOLDER"));
                MessageGesture.sendMessage(sender, "&c&o&lERROR WITH PLACEHOLDER {mob" + number + "}");
            }
        }
        for (String s : title) {
            MessageGesture.sendMessage(sender, s.replace("{hours}", this.getTimeChallenge().getHours() + "").replace("{minutes}", this.getTimeChallenge().getMinutes() + "").replace("{seconds}", this.getTimeChallenge().getSeconds() + "").replace("{points}", this.point + "").replace("{slots}", this.number + "").replace("{minutes}", this.minutes + "").replace("{challengeName}", this.nameChallenge).replace("{sneaking}", this.sneaking).replace("{force}", this.force + "").replace("{power}", this.power + "").replace("{onGround}", this.onGround).replace("{keepInventory}", this.keepInventory + ""));
        }
    }

    public void nextChallenge(boolean resetPoints, boolean rankingReward, boolean randomReward, int numberOfRewardedPlayer, int numberOfTop, String reason, boolean skipPeacefulTime) {
        ChallengeChangeEvent challengeChangeEvent = new ChallengeChangeEvent(reason, this);
        Bukkit.getPluginManager().callEvent((Event)challengeChangeEvent);
        if (challengeChangeEvent.isCancelled()) {
            return;
        }
        List<Challenger> topPlayers = Main.instance.getDailyChallenge().getTopPlayers(numberOfRewardedPlayer);
        if (!Main.db.checkIfEventChallenge()) {
            Main.db.deleteChallengeWithName(Main.instance.getDailyChallenge().getChallengeName());
        } else {
            Main.db.deleteChallengeWithName("Event_" + Main.instance.getDailyChallenge().getChallengeName());
        }
        Main.db.removeTopYesterday();
        Main.db.saveTopYesterday(Main.instance.getDailyChallenge().getTopPlayers(numberOfTop));
        if (Main.instance.getDailyChallenge().getTypeChallenge().equalsIgnoreCase("ItemCollectionChallenge")) {
            ItemCollector.deleteDb();
        }
        if (Main.instance.getConfigGesture().isBackupEnabled()) {
            Main.db.backupDb(Main.instance.getConfigGesture().getNumberOfFilesInFolderForBackup());
        }
        int number = Main.db.lastDailyWinnerId();
        Random random = new Random();
        if (Main.instance.getDailyChallenge().isMinimumPointsReached()) {
            for (int z = 0; z < topPlayers.size(); ++z) {
                PlayerStats playerStats;
                int placeInTop = z;
                int rewardsSize = Main.instance.getDailyChallenge().getRewards().size();
                if (z >= rewardsSize) {
                    placeInTop = rewardsSize - 1;
                }
                if (Main.db.isPlayerHaveStats(topPlayers.get(z).getNomePlayer())) {
                    playerStats = Main.db.getStatsPlayer(topPlayers.get(z).getNomePlayer());
                    playerStats.setNumberOfVictories(playerStats.getNumberOfVictories() + 1);
                    if (z == 0) {
                        playerStats.setNumberOfFirstPlace(playerStats.getNumberOfFirstPlace() + 1);
                    } else if (z == 1) {
                        playerStats.setNumberOfSecondPlace(playerStats.getNumberOfSecondPlace() + 1);
                    } else if (z == 2) {
                        playerStats.setNumberOfThirdPlace(playerStats.getNumberOfThirdPlace() + 1);
                    }
                    Main.db.updatePlayerStat(playerStats);
                } else {
                    playerStats = new PlayerStats();
                    playerStats.setPlayerName(topPlayers.get(z).getNomePlayer());
                    playerStats.setNumberOfVictories(1);
                    if (z == 0) {
                        playerStats.setNumberOfFirstPlace(1);
                    } else if (z == 1) {
                        playerStats.setNumberOfSecondPlace(1);
                    } else if (z == 2) {
                        playerStats.setNumberOfThirdPlace(1);
                    }
                    Main.db.insertPlayerStat(playerStats);
                }
                ++number;
                DailyWinner dailyWinner = new DailyWinner();
                dailyWinner.setPlayerName(topPlayers.get(z).getNomePlayer());
                dailyWinner.setNomeChallenge(Main.instance.getDailyChallenge().getChallengeName());
                if (rankingReward) {
                    dailyWinner.setId(number);
                    dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(placeInTop));
                    Main.db.insertDailyWinner(dailyWinner);
                    continue;
                }
                if (randomReward) {
                    dailyWinner.setId(number);
                    dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(random.nextInt(rewardsSize)));
                    Main.db.insertDailyWinner(dailyWinner);
                    continue;
                }
                for (int i = 0; i < rewardsSize; ++i) {
                    dailyWinner.setId(number);
                    dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(i));
                    Main.db.insertDailyWinner(dailyWinner);
                    ++number;
                }
            }
        }
        if (resetPoints) {
            Main.db.clearChallengers();
            Main.instance.getDailyChallenge().clearPlayers();
        }
        if (Main.challengeSelected) {
            Main.instance.getDailyChallenge().clearPlayers();
            for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                interfaces.getValue().closeAllInventories();
            }
        }
        Main.instance.unregisterCurrentListener();
        Main.instance.getConfigGesture().getTasks().stopAllTasks();
        if (Main.instance.getConfigGesture().getCooldown().getMilliseconds() > 0L && !skipPeacefulTime) {
            Main.db.setPeacefulTime(Main.instance.getConfigGesture().getCooldown().cloneTime());
        }
        Main.instance.pluginStartingProcess();
    }

    public Challenge cloneChallenge(String challengeDuration) {
        return new Challenge(this.nameChallenge, this.blocks, this.blocksOnPlaced, this.typeChallenge, this.rewards, this.title, this.items, this.itemsInHand, this.mobs, this.force, this.power, this.colors, this.causes, this.point, this.pointsBoost, this.multiplier, this.boostMinutes, this.number, challengeDuration, this.vehicles, this.sneaking, this.onGround, this.pointsBoostSinglePlayer, this.multiplierSinglePlayer, this.minutesSinglePlayer, this.endTimeChallenge, this.challengeName, this.quests, this.minutes, this.startTimeChallenge, this.keepInventory, this.deathInLand, this.worlds, this.itemChallenge);
    }

    public Challenge cloneChallenge() {
        return new Challenge(this.nameChallenge, this.blocks, this.blocksOnPlaced, this.typeChallenge, this.rewards, this.title, this.items, this.itemsInHand, this.mobs, this.force, this.power, this.colors, this.causes, this.point, this.pointsBoost, this.multiplier, this.boostMinutes, this.number, "0t", this.vehicles, this.sneaking, this.onGround, this.pointsBoostSinglePlayer, this.multiplierSinglePlayer, this.minutesSinglePlayer, this.endTimeChallenge, this.challengeName, this.quests, this.minutes, this.startTimeChallenge, this.keepInventory, this.deathInLand, this.worlds, this.itemChallenge);
    }
}

