/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Utils;

import com.HeroxWar.HeroxCore.MessageGesture;
import com.HeroxWar.HeroxCore.TimeGesture.Time;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Database.Objects.Challenger;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Utils.MoneyUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Tasks {
    private final List<BukkitTask> tasks = new ArrayList<BukkitTask>();
    private BukkitTask checkStart = null;
    private boolean challengeStart = false;
    private final Map<String, Integer> minutesOnlinePlayer = new ConcurrentHashMap<String, Integer>();
    private BukkitTask peacefulTask = null;

    public void stopAllTasks() {
        for (BukkitTask task : this.tasks) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public boolean isChallengeStart() {
        return !this.challengeStart;
    }

    public void broadcast(long time, String actuallyInTop, String pointsEveryMinutes, String pointsRemainForBoosting, String pointsRemainForBoostingSinglePlayer, int numberOfTop, String pointsRemainForReward) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                long pointsRemain;
                if (Main.instance.getConfigGesture().getTasks().isChallengeStart()) break;
                Main.instance.getDailyChallenge().message((CommandSender)p);
                ArrayList<Challenger> top = Main.instance.getConfigGesture().isYesterdayTop() ? new ArrayList<Challenger>(Main.db.getTopYesterday()) : new ArrayList<Challenger>(Main.instance.getDailyChallenge().getTopPlayers(numberOfTop));
                if (!top.isEmpty()) {
                    MessageGesture.sendMessage((CommandSender)p, actuallyInTop);
                }
                int i = 1;
                for (Challenger challenger : top) {
                    MessageGesture.sendMessage((CommandSender)p, Main.instance.getConfigGesture().getMessages().get("topPlayers" + i).replace("{number}", "" + i).replace("{player}", challenger.getNomePlayer()).replace("{points}", MoneyUtils.transform(challenger.getPoints())));
                    ++i;
                }
                if (Main.instance.getConfigGesture().getMinimumPoints() != -1) {
                    if (!Main.instance.getDailyChallenge().isMinimumPointsReached()) {
                        MessageGesture.sendMessage((CommandSender)p, pointsRemainForReward.replace("{points}", Main.instance.getDailyChallenge().getPointsRemain() + ""));
                    } else {
                        MessageGesture.sendMessage((CommandSender)p, pointsRemainForReward.replace("{points}", "0"));
                    }
                }
                if (Main.instance.getDailyChallenge().getMin10PlayersPoints().get(p.getName()) != null) {
                    String minutes = time / 60L / 20L + "";
                    MessageGesture.sendMessage((CommandSender)p, pointsEveryMinutes.replace("{points}", MoneyUtils.transform(Main.instance.getDailyChallenge().getMin10PlayersPoints().get(p.getName()))).replace("{minutes}", minutes));
                }
                if (!Main.instance.getDailyChallenge().isActive() && (pointsRemain = (long)Main.instance.getDailyChallenge().getPointsBoost() - Main.instance.getDailyChallenge().getCountPointsChallenge()) > 0L) {
                    MessageGesture.sendMessage((CommandSender)p, pointsRemainForBoosting.replace("{points}", pointsRemain + ""));
                }
                if (Main.instance.getDailyChallenge().isActiveSingleBoost(p.getName()) || (pointsRemain = (long)Main.instance.getDailyChallenge().getPointsBoostSinglePlayer() - Main.instance.getDailyChallenge().getCountPointsChallengeSinglePlayer(p.getName())) <= 0L) continue;
                MessageGesture.sendMessage((CommandSender)p, pointsRemainForBoostingSinglePlayer.replace("{points}", pointsRemain + ""));
            }
            Main.instance.getDailyChallenge().getMin10PlayersPoints().clear();
        }, 0L, time);
        this.tasks.add(task);
    }

    public void checkStartDay() {
        this.checkStart = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, new Runnable(){
            final String startChallenge = Main.instance.getDailyChallenge().getStartTimeChallenge();
            final String endChallenge = Main.instance.getDailyChallenge().getEndTimeChallenge();
            final String[] startSplit = this.startChallenge.split(":");
            final String[] endSplit = this.endChallenge.split(":");
            final int startHour = Integer.parseInt(this.startSplit[0]);
            final int startMinutes = Integer.parseInt(this.startSplit[1]);
            final int endHour = Integer.parseInt(this.endSplit[0]);
            final int endMinutes = Integer.parseInt(this.endSplit[1]);

            @Override
            public void run() {
                SimpleDateFormat sdf = new SimpleDateFormat("ss.mm.HH.dd.MM.yyyy");
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                String data = sdf.format(timestamp);
                try {
                    Date now = sdf.parse(data);
                    String[] dataSplit = data.split(Pattern.quote("."));
                    String endData = "00." + this.endMinutes + "." + this.endHour + "." + dataSplit[3] + "." + dataSplit[4] + "." + dataSplit[5];
                    String startData = "00." + this.startMinutes + "." + this.startHour + "." + dataSplit[3] + "." + dataSplit[4] + "." + dataSplit[5];
                    Date end = sdf.parse(endData);
                    Date start = sdf.parse(startData);
                    if (now.compareTo(start) > 0 && now.compareTo(end) < 0) {
                        Main.instance.getConfigGesture().getTasks().checkDay(Main.instance.getConfigGesture().isResetPointsAtNewChallenge(), Main.instance.getConfigGesture().isRankingReward(), Main.instance.getConfigGesture().isRandomReward(), Main.instance.getConfigGesture().getNumberOfRewardPlayer(), Main.instance.getConfigGesture().getNumberOfTop());
                        Tasks.this.challengeStart = true;
                    } else {
                        Tasks.this.challengeStart = false;
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }, 0L, 1200L);
        this.tasks.add(this.checkStart);
    }

    public void checkDay(final boolean resetPoints, final boolean rankingReward, final boolean randomReward, final int numberOfRewardedPlayer, final int numberOfTop) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)Main.instance, new Runnable(){
            boolean firstTime = true;
            final /* synthetic */ Tasks this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Time time = Main.instance.getDailyChallenge().getTimeChallenge();
                if (this.firstTime) {
                    this.firstTime = false;
                    this.this$0.checkStart.cancel();
                }
                if (time.getMilliseconds() <= 0L) {
                    Main.instance.getDailyChallenge().nextChallenge(resetPoints, rankingReward, randomReward, numberOfRewardedPlayer, numberOfTop, "Challenge Time Finished", false);
                } else {
                    if (time.getSeconds() == 0L) {
                        Main.db.updateChallenge(Main.instance.getDailyChallenge().getChallengeName(), time.getMilliseconds());
                    }
                    Main.instance.getDailyChallenge().setTimeChallenge(time.differenceBetween(new Time(0, 0, 0, 1, ':')));
                }
            }
        }, 0L, 20L);
        this.tasks.add(task);
    }

    public void peacefulTimeTask() {
        this.peacefulTask = Bukkit.getScheduler().runTaskTimer((Plugin)Main.instance, () -> {
            Time time = Main.db.getPeacefulTime();
            if (time.getMilliseconds() <= 0L) {
                Main.db.updatePeacefulTime(new Time(0, ':'));
                Main.instance.pluginStartingProcess();
                this.peacefulTask.cancel();
            } else {
                if (time.getSeconds() == 0L) {
                    Main.db.updatePeacefulTime(time);
                }
                Main.db.setPeacefulTime(time.differenceBetween(new Time(0, 0, 0, 1, ':')));
            }
        }, 0L, 20L);
        this.tasks.add(this.peacefulTask);
    }

    public void onlinePoints(int minutes, int point) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.minutesOnlinePlayer.get(p.getName()) == null) {
                    this.minutesOnlinePlayer.put(p.getName(), 0);
                    continue;
                }
                if (this.minutesOnlinePlayer.get(p.getName()) == minutes) {
                    if (!Controls.hasPermission(p.getName())) {
                        return;
                    }
                    Main.instance.getDailyChallenge().increment(p.getName(), point);
                    this.minutesOnlinePlayer.replace(p.getName(), 0);
                    continue;
                }
                this.minutesOnlinePlayer.replace(p.getName(), this.minutesOnlinePlayer.get(p.getName()) + 1);
            }
        }, 0L, 1200L);
        this.tasks.add(task);
    }

    public void addExternalTasks(BukkitTask task, String savingName, boolean save) {
        this.tasks.add(task);
    }
}

