/*
 * Decompiled with CFR 0.152.
 */
package com.HeroxWar.HeroxCore.SoundGesture;

import com.HeroxWar.HeroxCore.SoundGesture.SoundException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SoundType {
    private static final Logger logger = Logger.getLogger(SoundType.class.getName());
    private final boolean enabled;
    private final Sound sound;
    private final String type;
    private final double volume;
    private final double pitch;

    public SoundType(String type, double volume, double pitch) {
        this.type = type;
        if (this.type == null || this.type.isEmpty()) {
            this.enabled = false;
            this.sound = null;
            this.volume = 0.0;
            this.pitch = 0.0;
            return;
        }
        this.sound = this.getSound(type);
        if (this.sound == null) {
            this.enabled = false;
            this.volume = 0.0;
            this.pitch = 0.0;
            return;
        }
        if (volume < 0.0 || volume > 100.0) {
            try {
                throw new Exception("!!!!!!!! THIS IS A CONFIGURATION ERROR !!!!!!!!!!!! The volume of the sound '" + type + "' is not between 0 and 100, it's: '" + volume + "'");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage());
                this.volume = 100.0;
            }
        } else {
            this.volume = volume;
        }
        if (pitch < 0.0 || pitch > 2.0) {
            try {
                throw new Exception("!!!!!!!! THIS IS A CONFIGURATION ERROR !!!!!!!!!!!! The pitch of the sound '" + type + "' is not between 0 and 2, it's: '" + pitch + "'");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage());
                this.pitch = 1.0;
            }
        } else {
            this.pitch = pitch;
        }
        this.enabled = true;
    }

    public String getType() {
        return this.type;
    }

    public float getVolume() {
        return (float)this.volume;
    }

    public float getPitch() {
        return (float)this.pitch;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void playSound(Player player) {
        if (!this.enabled) {
            return;
        }
        player.playSound(player.getLocation(), this.sound, (float)this.volume, (float)this.pitch);
    }

    public void playSound(Location location) {
        if (!this.enabled || location.getWorld() == null) {
            return;
        }
        location.getWorld().playSound(location, this.sound, (float)this.volume, (float)this.pitch);
    }

    private Sound getSound(String sound) {
        try {
            Method valueOfMethod = Sound.class.getMethod("valueOf", String.class);
            return (Sound)valueOfMethod.invoke(null, sound);
        }
        catch (Exception e) {
            try {
                logger.log(Level.WARNING, e.getMessage());
                throw new SoundException("Error: Unable to resolve sound " + sound + ", if your server is running 1.21.3 or newer, make sure to convert the sound names to the new format, like 'minecraft:entity.ender_dragon.flap'.");
            }
            catch (SoundException ex) {
                logger.log(Level.WARNING, ex.getMessage());
                return null;
            }
        }
    }

    public String toString() {
        return "SoundType{type='" + this.type + "', volume=" + this.volume + ", pitch=" + this.pitch + "}";
    }
}

