/*
 * Decompiled with CFR 0.152.
 */
package com.HeroxWar.HeroxCore.Utils;

import com.HeroxWar.HeroxCore.Utils.Nms;
import com.HeroxWar.HeroxCore.Utils.TextureException;
import com.HeroxWar.HeroxCore.Utils.Version;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.json.JSONObject;

public class Texture {
    private static final String defaultTexture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Im51bGwifX19";
    private static final UUID RANDOM_UUID = UUID.fromString("8667ba71-b85a-4004-af54-457a9734eed7");
    private static final Version version = new Version();

    public static ItemStack setCustomTexture(ItemStack item, String texture) throws TextureException {
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        try {
            UUID uuid = Bukkit.getOnlinePlayers().stream().findFirst().map(OfflinePlayer::getUniqueId).orElse(RANDOM_UUID);
            PlayerProfile player_profile = Bukkit.getServer().createPlayerProfile(uuid, "Tombs");
            PlayerTextures textures = player_profile.getTextures();
            textures.setSkin(new URL(Texture.convertBase64ToURL(texture)));
            player_profile.setTextures(textures);
            try {
                meta.setOwnerProfile(player_profile);
            }
            catch (NullPointerException exx) {
                throw new TextureException("Failed to set skull owner Game Profile, please check if the texture is correct: '" + texture + "'" + exx.getMessage());
            }
        }
        catch (NoSuchMethodError | MalformedURLException ignored) {
            try {
                GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                profile.properties().put((Object)"textures", (Object)new Property("textures", texture));
                try {
                    Field profileField = meta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(meta, profile);
                }
                catch (Exception e) {
                    throw new TextureException(e.getMessage());
                }
            }
            catch (NoSuchMethodError ignored2) {
                GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                try {
                    Method getPropertiesMethod = profile.getClass().getDeclaredMethod("getProperties", new Class[0]);
                    getPropertiesMethod.setAccessible(true);
                    Object properties = getPropertiesMethod.invoke((Object)profile, new Object[0]);
                    Method putMethod = properties.getClass().getDeclaredMethod("put", Object.class, Object.class);
                    putMethod.invoke(properties, "textures", new Property("textures", texture));
                    Field profileField = meta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(meta, profile);
                }
                catch (Exception e) {
                    throw new TextureException(e.getMessage());
                }
            }
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static void setCustomTexture(Block block, String playerName) {
        if (!(block.getState() instanceof Skull)) {
            block.setType(Material.getMaterial((String)(version.isInRange(8, 12) ? "SKULL" : "PLAYER_WALL_HEAD")));
        }
        GameProfile profile = new GameProfile(UUID.randomUUID(), playerName);
        Skull skull = (Skull)block.getState();
        String profileName = null;
        try {
            profileName = Texture.getProfileName(profile);
        }
        catch (TextureException e) {
            throw new RuntimeException(e);
        }
        if (profileName != null) {
            try {
                skull.setOwner(profileName);
            }
            catch (Exception ignored) {
                skull.setOwnerProfile(Bukkit.getOfflinePlayer((String)profileName).getPlayerProfile());
            }
        }
        skull.update();
    }

    private static String getProfileName(GameProfile profile) throws TextureException {
        String profileName;
        try {
            Method nameMethod = profile.getClass().getDeclaredMethod("name", new Class[0]);
            nameMethod.setAccessible(true);
            profileName = (String)nameMethod.invoke((Object)profile, new Object[0]);
        }
        catch (NoSuchMethodException ignored) {
            try {
                Method getNameMethod = profile.getClass().getDeclaredMethod("getName", new Class[0]);
                getNameMethod.setAccessible(true);
                profileName = (String)getNameMethod.invoke((Object)profile, new Object[0]);
            }
            catch (Exception ex) {
                throw new TextureException(ex.getMessage());
            }
        }
        catch (Exception e) {
            throw new TextureException(e.getMessage());
        }
        return profileName;
    }

    public static String getPlayerTexture(Player p) {
        try {
            return Texture.getPlayerTexture(p, defaultTexture);
        }
        catch (TextureException ignore) {
            return defaultTexture;
        }
    }

    public static String getPlayerTexture(Player p, String defaultTexture) throws TextureException {
        String encod = defaultTexture;
        try {
            Nms nms = new Nms();
            Class<?> CraftPlayer = nms.getNMSClass("org.bukkit.craftbukkit.__VERSION__.entity.CraftPlayer");
            Object craftEntity = CraftPlayer.cast(p);
            Method getProfile = CraftPlayer.getDeclaredMethod("getProfile", new Class[0]);
            GameProfile profile = (GameProfile)getProfile.invoke(craftEntity, new Object[0]);
            Collection c = null;
            try {
                c = profile.properties().get((Object)"textures");
            }
            catch (Exception | NoSuchMethodError ex3) {
                try {
                    Method getPropertiesMethod = profile.getClass().getDeclaredMethod("getProperties", new Class[0]);
                    getPropertiesMethod.setAccessible(true);
                    Object propertyMap = getPropertiesMethod.invoke((Object)profile, new Object[0]);
                    c = ((PropertyMap)propertyMap).get((Object)"textures");
                }
                catch (Exception ex) {
                    throw new TextureException(ex.getMessage());
                }
            }
            for (Property p1 : c) {
                try {
                    Method m = p1.getClass().getDeclaredMethod("getName", new Class[0]);
                    if (!((String)m.invoke((Object)p1, new Object[0])).equalsIgnoreCase("textures")) continue;
                    Method m1 = p1.getClass().getDeclaredMethod("getValue", new Class[0]);
                    encod = (String)m1.invoke((Object)p1, new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    if (!p1.name().equalsIgnoreCase("textures")) continue;
                    encod = p1.value();
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new TextureException(ex.getMessage());
        }
        return encod;
    }

    public static String convertBase64ToURL(String texture) {
        String jsonString = new String(Base64.getDecoder().decode(texture), StandardCharsets.UTF_8);
        JSONObject jsonObject = new JSONObject(jsonString);
        JSONObject jstextures = jsonObject.getJSONObject("textures");
        JSONObject skin = jstextures.getJSONObject("SKIN");
        return skin.getString("url");
    }
}

