/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Core;

import com.HeroxWar.HeroxCore.CommentedConfiguration;
import com.HeroxWar.HeroxCore.ReloadGesture;
import com.HeroxWar.HeroxCore.Utils.Version;
import io.eliotesta98.VanillaChallenges.Comandi.Commands;
import io.eliotesta98.VanillaChallenges.Core.Library;
import io.eliotesta98.VanillaChallenges.Database.ConfigGesture;
import io.eliotesta98.VanillaChallenges.Database.Database;
import io.eliotesta98.VanillaChallenges.Database.H2Database;
import io.eliotesta98.VanillaChallenges.Database.MySql;
import io.eliotesta98.VanillaChallenges.Database.YamlDB;
import io.eliotesta98.VanillaChallenges.Events.Challenges.AFKCheck;
import io.eliotesta98.VanillaChallenges.Events.Challenges.BlockBreakEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.BlockPlaceEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.BreedEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ChatEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ColorSheepEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.CraftingEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.DamageEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.DropperEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.DyeEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.EatEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.EggThrowEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.EnchantEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.EntityCatcherEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ExpCollector;
import io.eliotesta98.VanillaChallenges.Events.Challenges.FireCatcher;
import io.eliotesta98.VanillaChallenges.Events.Challenges.FishEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.FurnaceBurnEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.GameBlockEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.HarvestEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.HealthRegenEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.InventoryCheck;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ItemBreakEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ItemCollector.ItemCollector;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ItemConsumeEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.JumpEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.JumpHorseEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.KillMobEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.LeashEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.MoveEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.PlayerShearsEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.PrimeEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.RaidEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.RiptideEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ShootArrowEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.SleepEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.SneakEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.SpongeAbsorbeEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.SprintEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.VehicleMoveEvent;
import io.eliotesta98.VanillaChallenges.Events.DailyGiveWinners;
import io.eliotesta98.VanillaChallenges.Interfaces.GuiEvent;
import io.eliotesta98.VanillaChallenges.Interfaces.Interface;
import io.eliotesta98.VanillaChallenges.Modules.CubeGenerator.CubeGeneratorEvent;
import io.eliotesta98.VanillaChallenges.Modules.Lands.LandsUtils;
import io.eliotesta98.VanillaChallenges.Modules.PlaceholderApi.ExpansionPlaceholderAPI;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Events;
import io.eliotesta98.VanillaChallenges.Utils.Challenge;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import io.eliotesta98.VanillaChallenges.Utils.Metrics;
import io.eliotesta98.VanillaChallenges.Utils.UpdateChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.internal.net.http.common.Log;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Main instance;
    private ConfigGesture config;
    private Challenge dailyChallenge;
    public static ExpansionPlaceholderAPI EPAPI;
    public static Database db;
    public static boolean challengeSelected;
    public static Listener currentListener;
    private static final Logger logger;
    public static Version version;

    public void onLoad() {
        instance = this;
        version = new Version();
        this.loadLibraries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnable() {
        DebugUtils debugSystem = new DebugUtils("Enabled");
        long tempo = System.currentTimeMillis();
        int pluginId = 17661;
        new Metrics(this, pluginId);
        this.getServer().getConsoleSender().sendMessage("\n\n\n\u00a7a ___ ___                __  __  __          ______  __            __  __                                    \n\u00a7a|   |   |.---.-..-----.|__||  ||  |.---.-. |      ||  |--..---.-.|  ||  |.-----..-----..-----..-----..-----.\n\u00a7a|   |   ||  _  ||     ||  ||  ||  ||  _  | |   ---||     ||  _  ||  ||  ||  -__||     ||  _  ||  -__||__ --|\n\u00a7a \\_____/ |___._||__|__||__||__||__||___._| |______||__|__||___._||__||__||_____||__|__||___  ||_____||_____|\n\u00a7a                                                                                       |_____|              \n\u00a7a  \r\n\u00a7a  \r\n\u00a7e  Version " + this.getDescription().getVersion() + " \r\n\u00a7e\u00a9 Developed by \u00a7feliotesta98 & xSavior_of_God \u00a7ewith \u00a74<3 \r\n \r\n \r\n");
        if (version.isInRange(8, 12)) {
            this.getServer().getConsoleSender().sendMessage("\u00a76Server version registered < 1.13");
        } else {
            this.getServer().getConsoleSender().sendMessage("\u00a76Server version registered > 1.12");
        }
        this.getServer().getConsoleSender().sendMessage("\u00a76Loading config...");
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int read;
                this.saveResource("config.yml", false);
                inputStream = this.getResource("config.yml");
                outputStream = new FileOutputStream(configFile);
                byte[] bytes = new byte[1024];
                while ((read = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, read);
                }
            }
            catch (IOException e) {
                Log.logError(e);
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create config.yml!");
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        Log.logError(e);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        Log.logError(e);
                    }
                }
            }
        }
        CommentedConfiguration cfg = CommentedConfiguration.loadConfiguration(configFile);
        try {
            String configName = "config.yml";
            String splits = "bho";
            String[] strings = splits.split(":");
            cfg.syncWithConfig(configFile, this.getResource(configName), strings);
        }
        catch (IOException e) {
            Log.logError(e);
        }
        try {
            this.config = new ConfigGesture((FileConfiguration)YamlConfiguration.loadConfiguration((File)configFile));
        }
        catch (IOException e) {
            Log.logError(e);
        }
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                if (this.getConfigGesture().getHooks().get("PlaceholderAPI").booleanValue()) {
                    EPAPI = new ExpansionPlaceholderAPI().getInstance();
                    EPAPI.register();
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aAdded compatibility to &fPlaceholderApi&a!"));
                }
            } else {
                this.getConfigGesture().getHooks().replace("PlaceholderAPI", false);
            }
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("CubeGenerator")) {
                if (this.getConfigGesture().getHooks().get("CubeGenerator").booleanValue()) {
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aAdded compatibility to &fCubeGenerator&a!"));
                }
            } else {
                this.getConfigGesture().getHooks().replace("CubeGenerator", false);
            }
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("GriefPrevention")) {
                if (this.getConfigGesture().getHooks().get("GriefPrevention").booleanValue()) {
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aAdded compatibility to &fGriefPrevention&a!"));
                }
            } else {
                this.getConfigGesture().getHooks().replace("GriefPrevention", false);
            }
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("Tombs")) {
                if (this.getConfigGesture().getHooks().get("Tombs").booleanValue()) {
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aAdded compatibility to &fTombs&a!"));
                }
            } else {
                this.getConfigGesture().getHooks().replace("Tombs", false);
            }
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("Lands")) {
                if (this.getConfigGesture().getHooks().get("Lands").booleanValue()) {
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aAdded compatibility to &fLands&a!"));
                    LandsUtils.setLandsIntegration();
                }
            } else {
                this.getConfigGesture().getHooks().replace("Lands", false);
            }
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("WorldGuard")) {
                if (this.getConfigGesture().getHooks().get("WorldGuard").booleanValue()) {
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aAdded compatibility to &fWorldGuard&a!"));
                }
            } else {
                this.getConfigGesture().getHooks().replace("WorldGuard", false);
            }
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("SuperiorSkyblock2")) {
                if (this.getConfigGesture().getHooks().get("SuperiorSkyblock2").booleanValue()) {
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aAdded compatibility to &fSuperiorSkyblock2&a!"));
                }
            } else {
                this.getConfigGesture().getHooks().replace("SuperiorSkyblock2", false);
            }
        });
        this.getServer().getConsoleSender().sendMessage("\u00a7aConfiguration Loaded!");
        this.getServer().getConsoleSender().sendMessage("\u00a76Connection to database!");
        if (this.getConfigGesture().getDatabase().equalsIgnoreCase("H2")) {
            try {
                db = new H2Database(this.getDataFolder().getAbsolutePath());
            }
            catch (Exception e) {
                this.getServer().getConsoleSender().sendMessage("\u00a7cTry to restore the database");
                this.restoreDatabase();
                logger.log(Level.WARNING, e.getMessage());
                return;
            }
        } else if (this.getConfigGesture().getDatabase().equalsIgnoreCase("MySql")) {
            try {
                db = new MySql(this.config.getUrl());
            }
            catch (SQLException e) {
                instance.getServer().getConsoleSender().sendMessage("\u00a7cError Database not connected!");
                Log.logError(e.getMessage(), new Object[0]);
                instance.onDisable();
            }
        } else {
            db = new YamlDB();
        }
        this.getServer().getConsoleSender().sendMessage("\u00a7aDatabase connected!");
        new UpdateChecker(instance, 101426).getVersion(version1 -> {
            if (!instance.getDescription().getVersion().equals(version1)) {
                this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "New Update available for VanillaChallenges!");
            }
        });
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new DailyGiveWinners(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new GuiEvent(), (Plugin)this);
        this.pluginStartingProcess();
        this.getCommand("vanillachallenges").setExecutor((CommandExecutor)new Commands());
        if (this.config.getDebug().get("Enabled").booleanValue()) {
            debugSystem.addLine("Enabled execution time= " + (System.currentTimeMillis() - tempo));
            debugSystem.debug();
        }
    }

    public void onDisable() {
        DebugUtils debugSystem = new DebugUtils("Disabled");
        long tempo = System.currentTimeMillis();
        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "VanillaChallenges has been disabled, \u00a7cBye bye! \u00a7e:(");
        this.config.getTasks().stopAllTasks();
        if (this.getConfigGesture().getHooks().get("PlaceholderAPI").booleanValue()) {
            try {
                EPAPI.getInstance().unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (challengeSelected) {
            this.dailyChallenge.clearPlayers();
            for (Map.Entry<String, Interface> interfaces : instance.getConfigGesture().getInterfaces().entrySet()) {
                interfaces.getValue().closeAllInventories();
            }
        }
        db.disconnect();
        if (this.config.getDebug().get("Disabled").booleanValue()) {
            debugSystem.addLine("Disabled execution time= " + (System.currentTimeMillis() - tempo));
            debugSystem.debug();
        }
    }

    public ConfigGesture getConfigGesture() {
        return this.config;
    }

    public Challenge getDailyChallenge() {
        return this.dailyChallenge;
    }

    public void setDailyChallenge(Challenge dailyChallenge) {
        this.dailyChallenge = dailyChallenge;
    }

    private void loadLibraries() {
        ArrayList<Library> libraries = new ArrayList<Library>();
        boolean oldVersion = this.getServer().getVersion().matches(".*\\b1\\.(8|9|1[0-6])\\b.*");
        if (oldVersion) {
            Bukkit.getConsoleSender().sendMessage("Loading legacy libraries...");
            InputStreamReader targetReader = new InputStreamReader(this.getResource("plugin.yml"));
            YamlConfiguration pluginFile = YamlConfiguration.loadConfiguration((Reader)targetReader);
            for (String libraryPath : pluginFile.getStringList("legacy-libraries")) {
                Library library = Library.fromMavenRepo(libraryPath);
                Bukkit.getConsoleSender().sendMessage("Loading library " + libraryPath);
                libraries.add(library);
            }
            for (Library library : libraries) {
                library.load();
            }
            Bukkit.getConsoleSender().sendMessage("Legacy libraries loaded!");
        }
    }

    public void restoreDatabase() {
        File dbNew;
        File db = new File(instance.getDataFolder(), "vanillachallenges.mv.db");
        if (!db.renameTo(dbNew = new File(instance.getDataFolder(), "vanillachallengesOld.mv.db"))) {
            this.getServer().getConsoleSender().sendMessage("\u00a7cOlder Database Not Successfully Deleted");
            this.onDisable();
            return;
        }
        this.getServer().getConsoleSender().sendMessage("\u00a7cOlder Database Successfully Renamed");
        ReloadGesture.reload(instance.getName());
    }

    public void pluginStartingProcess() {
        db.controlIfChallengeExist(this.config.getControlIfChallengeExist());
        String typeChallenge = db.insertDailyChallenges();
        challengeSelected = true;
        boolean skipCheck = false;
        if (typeChallenge.equalsIgnoreCase("BlockPlaceChallenge")) {
            currentListener = new BlockPlaceEvent();
        } else if (typeChallenge.equalsIgnoreCase("BlockBreakChallenge")) {
            currentListener = new BlockBreakEvent();
        } else if (typeChallenge.equalsIgnoreCase("CraftingChallenge")) {
            currentListener = new CraftingEvent();
        } else if (typeChallenge.equalsIgnoreCase("CookerChallenge")) {
            currentListener = new FurnaceBurnEvent();
        } else if (typeChallenge.equalsIgnoreCase("ConsumeChallenge")) {
            currentListener = new ItemConsumeEvent();
        } else if (typeChallenge.equalsIgnoreCase("CollectorExpChallenge")) {
            currentListener = new ExpCollector();
        } else if (typeChallenge.equalsIgnoreCase("KillChallenge")) {
            currentListener = new KillMobEvent();
        } else if (typeChallenge.equalsIgnoreCase("BreedChallenge")) {
            currentListener = new BreedEvent();
        } else if (typeChallenge.equalsIgnoreCase("FeedChallenge")) {
            currentListener = new EatEvent();
        } else if (typeChallenge.equalsIgnoreCase("ShootChallenge")) {
            currentListener = new ShootArrowEvent();
        } else if (typeChallenge.equalsIgnoreCase("JumpWithHorseChallenge")) {
            currentListener = new JumpHorseEvent();
        } else if (typeChallenge.equalsIgnoreCase("ColorSheepChallenge")) {
            currentListener = new ColorSheepEvent();
        } else if (typeChallenge.equalsIgnoreCase("RaidChallenge")) {
            currentListener = new RaidEvent();
        } else if (typeChallenge.equalsIgnoreCase("FishingChallenge")) {
            currentListener = new FishEvent();
        } else if (typeChallenge.equalsIgnoreCase("SprintChallenge")) {
            currentListener = new SprintEvent();
        } else if (typeChallenge.equalsIgnoreCase("MoveChallenge")) {
            currentListener = new MoveEvent();
        } else if (typeChallenge.equalsIgnoreCase("DamageChallenge")) {
            currentListener = new DamageEvent();
        } else if (typeChallenge.equalsIgnoreCase("SneakChallenge")) {
            currentListener = new SneakEvent();
        } else if (typeChallenge.equalsIgnoreCase("ItemBreakChallenge")) {
            currentListener = new ItemBreakEvent();
        } else if (typeChallenge.equalsIgnoreCase("SpongeAbsorbChallenge")) {
            currentListener = new SpongeAbsorbeEvent();
        } else if (typeChallenge.equalsIgnoreCase("HarvestChallenge")) {
            currentListener = new HarvestEvent();
        } else if (typeChallenge.equalsIgnoreCase("EggThrowerChallenge")) {
            currentListener = new EggThrowEvent();
        } else if (typeChallenge.equalsIgnoreCase("EnchantChallenge")) {
            currentListener = new EnchantEvent();
        } else if (typeChallenge.equalsIgnoreCase("ChatChallenge")) {
            currentListener = new ChatEvent();
        } else if (typeChallenge.equalsIgnoreCase("ItemCollectionChallenge")) {
            currentListener = new ItemCollector();
        } else if (typeChallenge.equalsIgnoreCase("InventoryConditionChallenge")) {
            new InventoryCheck();
            skipCheck = true;
        } else if (typeChallenge.equalsIgnoreCase("VehicleMoveChallenge")) {
            currentListener = new VehicleMoveEvent();
        } else if (typeChallenge.equalsIgnoreCase("JumpChallenge")) {
            currentListener = new JumpEvent();
        } else if (typeChallenge.equalsIgnoreCase("DyerChallenge")) {
            currentListener = new DyeEvent();
        } else if (typeChallenge.equalsIgnoreCase("CubeGeneratorChallenge")) {
            currentListener = new CubeGeneratorEvent();
        } else if (typeChallenge.equalsIgnoreCase("DropperChallenge")) {
            currentListener = new DropperEvent();
        } else if (typeChallenge.equalsIgnoreCase("HealthChallenge")) {
            currentListener = new HealthRegenEvent();
        } else if (typeChallenge.equalsIgnoreCase("AFKChallenge")) {
            new AFKCheck();
            skipCheck = true;
        } else if (typeChallenge.equalsIgnoreCase("MissionChallenge")) {
            currentListener = new SuperiorSkyBlock2Events();
        } else if (typeChallenge.equalsIgnoreCase("SensorChallenge")) {
            currentListener = new GameBlockEvent();
        } else if (typeChallenge.equalsIgnoreCase("PrimerChallenge")) {
            currentListener = new PrimeEvent();
        } else if (typeChallenge.equalsIgnoreCase("FireCatcherChallenge")) {
            currentListener = new FireCatcher();
        } else if (typeChallenge.equalsIgnoreCase("EntityCatcherChallenge")) {
            currentListener = new EntityCatcherEvent();
        } else if (typeChallenge.equalsIgnoreCase("LeashChallenge")) {
            currentListener = new LeashEvent();
        } else if (typeChallenge.equalsIgnoreCase("SleepChallenge")) {
            currentListener = new SleepEvent();
        } else if (typeChallenge.equalsIgnoreCase("WoolCutterChallenge")) {
            currentListener = new PlayerShearsEvent();
        } else if (typeChallenge.equalsIgnoreCase("RiptideChallenge")) {
            currentListener = new RiptideEvent();
        } else {
            challengeSelected = false;
        }
        if (skipCheck) {
            challengeSelected = true;
        } else if (currentListener == null) {
            challengeSelected = false;
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "No DailyChallenge selected, if you use the plugin without a scheduling ignore this error, otherwise check the configurations files and restart the plugin!");
        } else {
            Bukkit.getServer().getPluginManager().registerEvents(currentListener, (Plugin)this);
        }
        if (challengeSelected) {
            db.loadPlayersPoints();
            this.config.getTasks().checkStartDay();
            if (this.config.getTimeBroadcastMessageTitle() != 0) {
                this.config.getTasks().broadcast((long)this.config.getTimeBroadcastMessageTitle() * 60L * 20L, this.config.getMessages().get("ActuallyInTop"), this.config.getMessages().get("PointsEveryMinutes"), this.config.getMessages().get("PointsRemainForBoosting"), this.config.getMessages().get("PointsRemainForBoostingSinglePlayer"), this.config.getNumberOfTop(), this.config.getMessages().get("PointsRemainForReward"));
            }
            if (this.config.isActiveOnlinePoints()) {
                this.config.getTasks().onlinePoints(this.config.getMinutesOnlinePoints(), this.config.getPointsOnlinePoints());
            }
        }
    }

    public void unregisterCurrentListener() {
        HandlerList.unregisterAll((Listener)currentListener);
    }

    static {
        challengeSelected = true;
        currentListener = null;
        logger = Logger.getLogger(Main.class.getName());
    }
}

