/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Database;

import com.HeroxWar.HeroxCore.MessageGesture;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Database.Objects.Challenger;
import io.eliotesta98.VanillaChallenges.Database.Objects.DailyWinner;
import io.eliotesta98.VanillaChallenges.Database.Objects.PlayerStats;
import io.eliotesta98.VanillaChallenges.Utils.Challenge;
import io.eliotesta98.VanillaChallenges.Utils.MoneyUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class Database {
    private final List<Challenger> playerPoints = new ArrayList<Challenger>();
    private final List<Challenge> challenges = new ArrayList<Challenge>();
    private final List<DailyWinner> dailyWinners = new ArrayList<DailyWinner>();
    private final List<Challenger> topYesterday = new ArrayList<Challenger>();
    private final List<Challenger> oldPoints = new ArrayList<Challenger>();
    private final List<PlayerStats> stats = new ArrayList<PlayerStats>();
    private String prefix = "";
    private Connection connection;
    private static final Logger logger = Logger.getLogger(Database.class.getName());

    public abstract void createConnection(String var1);

    public void initialize() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "Challenge (`NomeChallenge` VARCHAR(100) NOT NULL PRIMARY KEY, `TimeResume` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "Challenger (`PlayerName` VARCHAR(100) NOT NULL PRIMARY KEY, `Points` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "ChallengerEvent (`PlayerName` VARCHAR(100) NOT NULL PRIMARY KEY, `Points` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "DailyWinner (`ID` INT(100) NOT NULL AUTO_INCREMENT PRIMARY KEY, `NomeChallenge` VARCHAR(100) NOT NULL, `PlayerName` VARCHAR(100) NOT NULL, `Reward` VARCHAR(100) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "TopYesterday (`ID` INT(100) NOT NULL AUTO_INCREMENT PRIMARY KEY, `PlayerName` VARCHAR(100) NOT NULL, `Points` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "Statistic (`PlayerName` VARCHAR(100) NOT NULL PRIMARY KEY, `NumberVictories` INT(10) NOT NULL, `NumberFirstPlace` INT(10) NOT NULL, `NumberSecondPlace` INT(10) NOT NULL, `NumberThirdPlace` INT(10) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException e) {
            Main.instance.getServer().getConsoleSender().sendMessage("\u00a7cError Database not connected!");
            logger.log(Level.WARNING, e.getMessage());
            Main.instance.onDisable();
        }
        this.selectAllChallenges();
        this.selectAllChallengers();
        this.selectAllStats();
        this.selectAllDailyWinners();
        this.selectAllChallengersTopYesterday();
        this.selectAllOldChallengers();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<Challenge> getChallenges() {
        return this.challenges;
    }

    public List<PlayerStats> getAllStats() {
        return this.stats;
    }

    public List<Challenger> getTopYesterday() {
        return this.topYesterday;
    }

    public List<Challenger> getPlayerPoints() {
        return this.playerPoints;
    }

    public List<Challenger> getOldPoints() {
        return this.oldPoints;
    }

    public List<DailyWinner> getDailyWinners() {
        return this.dailyWinners;
    }

    public void addPlayerPoints(Challenger challenger) {
        this.playerPoints.add(challenger);
    }

    public void addChallenge(Challenge challenge) {
        this.challenges.add(challenge);
    }

    public void addChallenge(Challenge challenge, int index) {
        this.challenges.add(index, challenge);
    }

    public void addDailyWinner(DailyWinner dailyWinner) {
        this.dailyWinners.add(dailyWinner);
    }

    public void addOldPoints(Challenger challenger) {
        this.oldPoints.add(challenger);
    }

    public void addTopYesterday(Challenger challenger) {
        this.topYesterday.add(challenger);
    }

    public void addStat(PlayerStats playerStats) {
        this.stats.add(playerStats);
    }

    public void removeStat(String playerName) {
        this.stats.removeIf(playerStat -> playerStat.getPlayerName().equalsIgnoreCase(playerName));
    }

    public void removeChallenge(String challengeName) {
        this.challenges.removeIf(challenge -> challenge.getChallengeName().equalsIgnoreCase(challengeName));
    }

    public void removePlayer(String playerName) {
        this.playerPoints.removeIf(challenger -> challenger.getNomePlayer().equalsIgnoreCase(playerName));
    }

    public void removeDailyWinner(int id) {
        this.dailyWinners.removeIf(dailyWinner -> dailyWinner.getId() == id);
    }

    public void updatePlayer(String playerName, long points) {
        this.removePlayer(playerName);
        this.addPlayerPoints(new Challenger(playerName, points));
    }

    public void updateChallengeTime(String challengeName, int time) {
        for (Challenge challenge : this.challenges) {
            if (!challenge.getChallengeName().equalsIgnoreCase(challengeName)) continue;
            challenge.setTimeChallenge(time);
        }
    }

    public void selectAllChallenges() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "Challenge");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Challenge challengeDB = new Challenge();
                challengeDB.setTimeChallenge(resultSet.getInt("TimeResume"));
                challengeDB.setChallengeName(resultSet.getString("NomeChallenge"));
                this.challenges.add(challengeDB);
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void selectAllStats() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "Statistic");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                PlayerStats playerStats = new PlayerStats();
                playerStats.setPlayerName(resultSet.getString("PlayerName"));
                playerStats.setNumberOfVictories(resultSet.getInt("NumberVictories"));
                playerStats.setNumberOfFirstPlace(resultSet.getInt("NumberFirstPlace"));
                playerStats.setNumberOfSecondPlace(resultSet.getInt("NumberSecondPlace"));
                playerStats.setNumberOfThirdPlace(resultSet.getInt("NumberThirdPlace"));
                this.stats.add(playerStats);
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void selectAllChallengers() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "Challenger");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Challenger point = new Challenger();
                point.setPoints(resultSet.getInt("Points"));
                point.setNomePlayer(resultSet.getString("PlayerName"));
                this.playerPoints.add(point);
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void selectAllDailyWinners() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "DailyWinner");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DailyWinner dailyWinner = new DailyWinner();
                dailyWinner.setId(resultSet.getInt("ID"));
                dailyWinner.setNomeChallenge(resultSet.getString("NomeChallenge"));
                dailyWinner.setPlayerName(resultSet.getString("PlayerName"));
                dailyWinner.setReward(resultSet.getString("Reward"));
                this.dailyWinners.add(dailyWinner);
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void selectAllChallengersTopYesterday() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "TopYesterday");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Challenger point = new Challenger();
                point.setPoints(resultSet.getInt("Points"));
                point.setNomePlayer(resultSet.getString("PlayerName"));
                this.topYesterday.add(point);
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void selectAllOldChallengers() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "ChallengerEvent");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Challenger point = new Challenger();
                point.setPoints(resultSet.getInt("Points"));
                point.setNomePlayer(resultSet.getString("PlayerName"));
                this.oldPoints.add(point);
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void backupDb(int numberOfFiles) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String data = sdf.format(timestamp);
        File configFile = new File(Main.instance.getDataFolder() + File.separator + "backup", data + ".yml");
        if (!configFile.exists()) {
            try {
                File folder = new File(Main.instance.getDataFolder() + File.separator + "backup");
                boolean folderCreate = folder.mkdir();
                if (!folderCreate && folder.listFiles().length >= numberOfFiles) {
                    Date finalDate = null;
                    int number = 0;
                    for (int i = 0; i < folder.listFiles().length; ++i) {
                        try {
                            Date date = sdf.parse(folder.listFiles()[i].getName());
                            if (finalDate == null) {
                                finalDate = date;
                                number = i;
                                continue;
                            }
                            int result = finalDate.compareTo(date);
                            if (result <= 0) continue;
                            finalDate = date;
                            number = i;
                            continue;
                        }
                        catch (ParseException e) {
                            logger.log(Level.WARNING, e.getMessage());
                        }
                    }
                    folder.listFiles()[number].delete();
                }
                configFile.createNewFile();
                YamlConfiguration file = YamlConfiguration.loadConfiguration((File)configFile);
                for (Challenger playerPoint : this.playerPoints) {
                    file.set("Points." + playerPoint.getNomePlayer(), (Object)playerPoint.getPoints());
                }
                for (Challenge challenge : this.challenges) {
                    file.set("Challenges." + challenge.getChallengeName(), (Object)challenge.getTimeChallenge());
                }
                for (DailyWinner dailyWinner : this.dailyWinners) {
                    file.set("DailyWinners." + dailyWinner.getId() + ".PlayerName", (Object)dailyWinner.getPlayerName());
                    file.set("DailyWinners." + dailyWinner.getId() + ".NomeChallenge", (Object)dailyWinner.getNomeChallenge());
                    file.set("DailyWinners." + dailyWinner.getId() + ".Reward", (Object)dailyWinner.getReward());
                }
                for (Challenger challenger : this.topYesterday) {
                    file.set("TopYesterday." + challenger.getNomePlayer(), (Object)challenger.getPoints());
                }
                for (PlayerStats playerStats : this.stats) {
                    file.set("Statistic." + playerStats.getPlayerName() + ".NumberVictories", (Object)playerStats.getNumberOfVictories());
                    file.set("Statistic." + playerStats.getPlayerName() + ".NumberFirstPlace", (Object)playerStats.getNumberOfFirstPlace());
                    file.set("Statistic." + playerStats.getPlayerName() + ".NumberSecondPlace", (Object)playerStats.getNumberOfSecondPlace());
                    file.set("Statistic." + playerStats.getPlayerName() + ".NumberThirdPlace", (Object)playerStats.getNumberOfThirdPlace());
                }
                file.save(configFile);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    public void clearAll() {
        this.clearChallenges();
        this.clearChallengers();
        this.clearChallengersOld();
        this.clearDailyWinners();
        this.removeTopYesterday();
        this.clearStats();
    }

    public String insertDailyChallenges() {
        int count = 1;
        if (this.challenges.isEmpty()) {
            String nome = "nessuno";
            ArrayList<String> keys = new ArrayList<String>(Main.instance.getConfigGesture().getChallenges().keySet());
            if (Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Random")) {
                Collections.shuffle(keys);
            } else if (Main.instance.getConfigGesture().getChallengeGeneration().equalsIgnoreCase("Single")) {
                Collections.shuffle(keys);
                Challenge challenge = Main.instance.getConfigGesture().getChallenges().get(keys.get(0));
                return challenge.getChallengeName();
            }
            for (String key : keys) {
                Challenge challenge = Main.instance.getConfigGesture().getChallenges().get(key);
                if (count == 1) {
                    Main.instance.setDailyChallenge(challenge);
                    nome = challenge.getTypeChallenge();
                }
                this.challenges.add(challenge);
                ++count;
            }
            this.saveChallenges();
            return nome;
        }
        for (int i = 0; i < this.challenges.size(); ++i) {
            if (this.challenges.get(i).getTimeChallenge() > 0) {
                if (this.challenges.get(i).getChallengeName().contains("Event_")) {
                    Challenge challenge = Main.instance.getConfigGesture().getChallengesEvent().get(this.challenges.get(i).getChallengeName().replace("Event_", ""));
                    challenge.setTimeChallenge(this.challenges.get(i).getTimeChallenge());
                    Main.instance.setDailyChallenge(challenge);
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[Vanilla Challenges] " + this.challenges.size() + " challenges remain on DB");
                    return Main.instance.getDailyChallenge().getTypeChallenge();
                }
                Challenge challenge = Main.instance.getConfigGesture().getChallenges().get(this.challenges.get(i).getChallengeName());
                challenge.setTimeChallenge(this.challenges.get(i).getTimeChallenge());
                Main.instance.setDailyChallenge(challenge);
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[Vanilla Challenges] " + this.challenges.size() + " challenges remain on DB");
                return Main.instance.getDailyChallenge().getTypeChallenge();
            }
            this.deleteChallengeWithName(this.challenges.get(i).getChallengeName());
            this.challenges.remove(i);
        }
        return "nessuno";
    }

    public void saveChallenges() {
        for (Challenge challenge : this.challenges) {
            this.insertChallenge(challenge.getChallengeName(), challenge.getTimeChallenge());
        }
    }

    public void insertChallengeEvent(String challengeName, int time) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.prefix + "Challenge (NomeChallenge,TimeResume) VALUES ('Event_" + challengeName + "','" + time + "')");
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                throw new SQLException("Insert failed, no rows affected.");
            }
            preparedStatement.close();
            Challenge challenge = Main.instance.getConfigGesture().getChallengesEvent().get(challengeName);
            challenge.setChallengeName("Event_" + challengeName);
            challenge.setTimeChallenge(time);
            this.addChallenge(challenge, 0);
            this.clearChallengesFromFile();
            for (Challenge challenge1 : this.getChallenges()) {
                this.insertChallenge(challenge1.getChallengeName(), challenge1.getTimeChallenge());
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void clearChallengesFromFile() {
        this.clearChallenges();
    }

    public void clearChallenges() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DROP TABLE " + this.prefix + "Challenge");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "Challenge (`NomeChallenge` VARCHAR(100) NOT NULL PRIMARY KEY, `TimeResume` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void clearChallengersOld() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DROP TABLE " + this.prefix + "ChallengerEvent");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "ChallengerEvent (`PlayerName` VARCHAR(100) NOT NULL PRIMARY KEY, `Points` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.oldPoints.clear();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void deleteChallengeWithName(String challengeName) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE FROM " + this.prefix + "Challenge WHERE `NomeChallenge`='" + challengeName + "'");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.removeChallenge(challengeName);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void insertChallenger(String playerName, long points) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.prefix + "Challenger (PlayerName,Points) VALUES ('" + playerName + "','" + points + "')");
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                throw new SQLException("Insert failed, no rows affected.");
            }
            preparedStatement.close();
            this.addPlayerPoints(new Challenger(playerName, points));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void updateChallenge(String challengeName, int timeResume) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE " + this.prefix + "Challenge SET TimeResume = '" + timeResume + "' WHERE NomeChallenge = '" + challengeName + "'");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.updateChallengeTime(challengeName, timeResume);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void controlIfChallengeExist(List<String> controlIfChallengeExist) {
        block0: for (String challengeName : controlIfChallengeExist) {
            for (Challenge challenge : this.challenges) {
                if (!challenge.getChallengeName().equalsIgnoreCase(challengeName)) continue;
                this.challenges.remove(challenge);
                this.deleteChallengeWithName(challengeName);
                continue block0;
            }
        }
    }

    public void insertChallenge(String challengeName, int timeResume) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.prefix + "Challenge (NomeChallenge,TimeResume) VALUES ('" + challengeName + "','" + timeResume + "')");
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                throw new SQLException("Insert failed, no rows affected.");
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public boolean isChallengePresent(String challengeName) {
        return this.challenges.stream().anyMatch(challenge -> challenge.getChallengeName().equalsIgnoreCase(challengeName));
    }

    public void loadPlayersPoints() {
        Main.instance.getDailyChallenge().setPlayers(this.playerPoints);
        Main.instance.getDailyChallenge().savePoints();
        List<Challenger> top = Main.instance.getDailyChallenge().getTopPlayers(Main.instance.getConfigGesture().getNumberOfTop());
        int i = 1;
        for (Challenger challenger : top) {
            MessageGesture.sendMessage((CommandSender)Bukkit.getServer().getConsoleSender(), Main.instance.getConfigGesture().getMessages().get("topPlayers" + i).replace("{number}", "" + i).replace("{player}", challenger.getNomePlayer()).replace("{points}", MoneyUtils.transform(challenger.getPoints())));
            ++i;
        }
    }

    public boolean isPresent(String playerName) {
        return this.playerPoints.stream().anyMatch(challenger -> challenger.getNomePlayer().equalsIgnoreCase(playerName));
    }

    public void clearChallengers() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DROP TABLE " + this.prefix + "Challenger");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "Challenger (`PlayerName` VARCHAR(100) NOT NULL PRIMARY KEY, `Points` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.playerPoints.clear();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void saveOldPointsForChallengeEvents() {
        HashMap<String, Long> copyMap = new HashMap<String, Long>(Main.instance.getDailyChallenge().getPlayers());
        for (Map.Entry<String, Long> player : copyMap.entrySet()) {
            try {
                if (player.getValue() <= 0L) continue;
                this.insertChallengerEvent(player.getKey(), player.getValue());
            }
            catch (Exception ex) {
                Bukkit.getServer().getConsoleSender().sendMessage("Save Points Event: " + ex.getMessage());
            }
        }
        this.clearChallengers();
    }

    public void insertChallengerEvent(String playerName, long points) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.prefix + "ChallengerEvent (PlayerName,Points) VALUES ('" + playerName + "','" + points + "')");
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                throw new SQLException("Insert failed, no rows affected.");
            }
            preparedStatement.close();
            this.oldPoints.add(new Challenger(playerName, points));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void deleteChallengerWithName(String nomePlayer) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE FROM " + this.prefix + "Challenger WHERE `PlayerName`='" + nomePlayer + "'");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.removePlayer(nomePlayer);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void updateChallenger(String playerName, long points) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE " + this.prefix + "Challenger SET Points = '" + points + "' WHERE PlayerName = '" + playerName + "'");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.updatePlayer(playerName, points);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void resumeOldPoints() {
        this.clearChallengers();
        for (Challenger challenger : this.oldPoints) {
            this.insertChallenger(challenger.getNomePlayer(), challenger.getPoints());
        }
        this.clearChallengersOld();
    }

    public void insertPlayerStat(PlayerStats playerStats) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.prefix + "Statistic (PlayerName,NumberVictories,NumberFirstPlace,NumberSecondPlace,NumberThirdPlace) VALUES ('" + playerStats.getPlayerName() + "','" + playerStats.getNumberOfVictories() + "','" + playerStats.getNumberOfFirstPlace() + "','" + playerStats.getNumberOfSecondPlace() + "','" + playerStats.getNumberOfThirdPlace() + "')");
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                throw new SQLException("Insert failed, no rows affected.");
            }
            preparedStatement.close();
            this.addStat(playerStats);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void deletePlayerStatWithPlayerName(String playerName) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE FROM " + this.prefix + "Statistic WHERE `PlayerName`='" + playerName + "'");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.removeStat(playerName);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void updatePlayerStat(PlayerStats playerStats) {
        for (PlayerStats playerStats1 : this.stats) {
            if (!playerStats1.getPlayerName().equalsIgnoreCase(playerStats.getPlayerName())) continue;
            this.deletePlayerStatWithPlayerName(playerStats1.getPlayerName());
            this.insertPlayerStat(playerStats);
            return;
        }
        this.insertPlayerStat(playerStats);
    }

    public PlayerStats getStatsPlayer(String playerName) {
        for (PlayerStats playerStats : this.stats) {
            if (!playerStats.getPlayerName().equalsIgnoreCase(playerName)) continue;
            return playerStats;
        }
        return null;
    }

    public List<PlayerStats> getTopVictories() {
        ArrayList<PlayerStats> top = new ArrayList<PlayerStats>(this.stats);
        top.sort(Comparator.comparing(PlayerStats::getNumberOfVictories));
        Collections.reverse(top);
        return top;
    }

    public List<PlayerStats> getTopFirstPlace() {
        ArrayList<PlayerStats> top = new ArrayList<PlayerStats>(this.stats);
        top.sort(Comparator.comparing(PlayerStats::getNumberOfFirstPlace));
        Collections.reverse(top);
        return top;
    }

    public List<PlayerStats> getTopSecondPlace() {
        ArrayList<PlayerStats> top = new ArrayList<PlayerStats>(this.stats);
        top.sort(Comparator.comparing(PlayerStats::getNumberOfSecondPlace));
        Collections.reverse(top);
        return top;
    }

    public List<PlayerStats> getTopThirdPlace() {
        ArrayList<PlayerStats> top = new ArrayList<PlayerStats>(this.stats);
        top.sort(Comparator.comparing(PlayerStats::getNumberOfThirdPlace));
        Collections.reverse(top);
        return top;
    }

    public void clearStats() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DROP TABLE " + this.prefix + "Statistic");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "Statistic (`PlayerName` VARCHAR(100) NOT NULL PRIMARY KEY, `NumberVictories` INT(10) NOT NULL, `NumberFirstPlace` INT(10) NOT NULL, `NumberSecondPlace` INT(10) NOT NULL, `NumberThirdPlace` INT(10) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.stats.clear();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public boolean isPlayerHaveStats(String playerName) {
        return this.stats.stream().anyMatch(playerStats -> playerStats.getPlayerName().equalsIgnoreCase(playerName));
    }

    public void removeTopYesterday() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DROP TABLE " + this.prefix + "TopYesterday");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "TopYesterday (`ID` INT(100) NOT NULL AUTO_INCREMENT PRIMARY KEY, `PlayerName` VARCHAR(100) NOT NULL, `Points` INT(15) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.topYesterday.clear();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void saveTopYesterday(List<Challenger> newTopYesterday) {
        for (Challenger challenger : newTopYesterday) {
            this.insertChallengerTopYesterday(challenger.getNomePlayer(), challenger.getPoints());
        }
    }

    public void insertChallengerTopYesterday(String playerName, long points) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.prefix + "TopYesterday (PlayerName,Points) VALUES ('" + playerName + "','" + points + "')");
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                throw new SQLException("Insert failed, no rows affected.");
            }
            preparedStatement.close();
            this.addTopYesterday(new Challenger(playerName, points));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public int lastDailyWinnerId() {
        if (this.dailyWinners.isEmpty()) {
            return 1;
        }
        return Collections.max(this.dailyWinners, Comparator.comparing(DailyWinner::getId)).getId();
    }

    public void insertDailyWinner(DailyWinner dailyWinner) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.prefix + "DailyWinner (NomeChallenge,PlayerName,Reward) VALUES ('" + dailyWinner.getNomeChallenge() + "','" + dailyWinner.getPlayerName() + "','" + dailyWinner.getReward() + "')");
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                throw new SQLException("Insert failed, no rows affected.");
            }
            preparedStatement.close();
            this.addDailyWinner(dailyWinner);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void deleteDailyWinnerWithId(int id) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE FROM " + this.prefix + "DailyWinner WHERE `ID`='" + id + "'");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.removeDailyWinner(id);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void clearDailyWinners() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DROP TABLE " + this.prefix + "DailyWinner");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.prefix + "DailyWinner (`ID` INT(100) NOT NULL AUTO_INCREMENT PRIMARY KEY, `NomeChallenge` VARCHAR(100) NOT NULL, `PlayerName` VARCHAR(100) NOT NULL, `Reward` VARCHAR(100) NOT NULL);");
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }
}

