/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Database;

import io.eliotesta98.VanillaChallenges.Database.Database;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class H2Database
extends Database {
    public static H2Database instance = null;
    private static final Logger logger = Logger.getLogger(H2Database.class.getName());

    public H2Database(String absolutePath) {
        this.setPrefix("");
        this.createConnection(absolutePath);
        this.initialize();
    }

    @Override
    public void createConnection(String absolutePath) {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        try {
            Connection connection = DriverManager.getConnection("jdbc:h2:" + absolutePath + File.separator + "vanillachallenges;mode=MySQL;");
            this.setConnection(connection);
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }
}

