/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Database;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Database.Database;
import io.eliotesta98.VanillaChallenges.Database.Objects.Challenger;
import io.eliotesta98.VanillaChallenges.Database.Objects.DailyWinner;
import io.eliotesta98.VanillaChallenges.Database.Objects.PlayerStats;
import io.eliotesta98.VanillaChallenges.Utils.Challenge;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlDB
extends Database {
    private FileConfiguration file;
    private File configFile;
    private static final Logger logger = Logger.getLogger(YamlDB.class.getName());

    public YamlDB() {
        this.initialize();
    }

    @Override
    public void initialize() {
        block22: {
            Challenger challenger;
            block21: {
                this.configFile = new File(Main.instance.getDataFolder(), "database.yml");
                if (this.configFile.exists()) break block21;
                boolean create = false;
                try {
                    create = this.configFile.createNewFile();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.getMessage());
                }
                if (create) {
                    this.file = YamlConfiguration.loadConfiguration((File)this.configFile);
                } else {
                    Challenger challenger2;
                    for (String playerName : this.file.getConfigurationSection("Points").getKeys(false)) {
                        challenger2 = new Challenger(playerName, this.file.getInt("Points." + playerName));
                        this.addPlayerPoints(challenger2);
                    }
                    for (String playerName : this.file.getConfigurationSection("PointsLastChallenge").getKeys(false)) {
                        challenger2 = new Challenger(playerName, this.file.getInt("PointsLastChallenge." + playerName));
                        this.addOldPoints(challenger2);
                    }
                    for (String challenge : this.file.getConfigurationSection("Challenges").getKeys(false)) {
                        Challenge challengeDB = new Challenge();
                        challengeDB.setChallengeName(challenge);
                        challengeDB.setTimeChallenge(this.file.getInt("Challenges." + challenge));
                        this.addChallenge(challengeDB);
                    }
                    for (String number : this.file.getConfigurationSection("DailyWinners").getKeys(false)) {
                        DailyWinner dailyWinner = new DailyWinner(Integer.parseInt(number), this.file.getString("DailyWinners." + number + ".PlayerName"), this.file.getString("DailyWinners." + number + ".NomeChallenge"), this.file.getString("DailyWinners." + number + ".Reward"));
                        this.addDailyWinner(dailyWinner);
                    }
                    for (String playerName : this.file.getConfigurationSection("TopYesterday").getKeys(false)) {
                        challenger2 = new Challenger(playerName, this.file.getInt("TopYesterday." + playerName));
                        this.addTopYesterday(challenger2);
                    }
                    for (String playerName : this.file.getConfigurationSection("Statistic").getKeys(false)) {
                        PlayerStats playerStats = new PlayerStats(playerName, this.file.getInt("Statistic." + playerName + ".NumberVictories"), this.file.getInt("Statistic." + playerName + ".NumberFirstPlace"), this.file.getInt("Statistic." + playerName + ".NumberSecondPlace"), this.file.getInt("Statistic." + playerName + ".NumberThirdPlace"));
                        this.addStat(playerStats);
                    }
                }
                break block22;
            }
            this.file = YamlConfiguration.loadConfiguration((File)this.configFile);
            if (this.file.getConfigurationSection("Points") != null) {
                for (String playerName : this.file.getConfigurationSection("Points").getKeys(false)) {
                    challenger = new Challenger(playerName, this.file.getInt("Points." + playerName));
                    this.addPlayerPoints(challenger);
                }
            }
            if (this.file.getConfigurationSection("PointsLastChallenge") != null) {
                for (String playerName : this.file.getConfigurationSection("PointsLastChallenge").getKeys(false)) {
                    challenger = new Challenger(playerName, this.file.getInt("PointsLastChallenge." + playerName));
                    this.addOldPoints(challenger);
                }
            }
            if (this.file.getConfigurationSection("Challenges") != null) {
                for (String challenge : this.file.getConfigurationSection("Challenges").getKeys(false)) {
                    Challenge challengeDB = new Challenge();
                    challengeDB.setChallengeName(challenge);
                    challengeDB.setTimeChallenge(this.file.getInt("Challenges." + challenge));
                    this.addChallenge(challengeDB);
                }
            }
            if (this.file.getConfigurationSection("DailyWinners") != null) {
                for (String number : this.file.getConfigurationSection("DailyWinners").getKeys(false)) {
                    DailyWinner dailyWinner = new DailyWinner(Integer.parseInt(number), this.file.getString("DailyWinners." + number + ".PlayerName"), this.file.getString("DailyWinners." + number + ".NomeChallenge"), this.file.getString("DailyWinners." + number + ".Reward"));
                    this.addDailyWinner(dailyWinner);
                }
            }
            if (this.file.getConfigurationSection("TopYesterday") != null) {
                for (String playerName : this.file.getConfigurationSection("TopYesterday").getKeys(false)) {
                    challenger = new Challenger(playerName, this.file.getInt("TopYesterday." + playerName));
                    this.addTopYesterday(challenger);
                }
            }
            if (this.file.getConfigurationSection("Statistic") == null) break block22;
            for (String playerName : this.file.getConfigurationSection("Statistic").getKeys(false)) {
                PlayerStats playerStats = new PlayerStats(playerName, this.file.getInt("Statistic." + playerName + ".NumberVictories"), this.file.getInt("Statistic." + playerName + ".NumberFirstPlace"), this.file.getInt("Statistic." + playerName + ".NumberSecondPlace"), this.file.getInt("Statistic." + playerName + ".NumberThirdPlace"));
                this.addStat(playerStats);
            }
        }
    }

    @Override
    public void createConnection(String absolutePath) {
    }

    @Override
    public void saveTopYesterday(List<Challenger> newTopYesterday) {
        for (Challenger challenger : newTopYesterday) {
            this.file.set("TopYesterday." + challenger.getNomePlayer(), (Object)challenger.getPoints());
            this.addTopYesterday(challenger);
        }
        this.saveFile();
    }

    @Override
    public void removeTopYesterday() {
        for (Challenger challenger : this.getTopYesterday()) {
            this.file.set("TopYesterday." + challenger.getNomePlayer(), null);
        }
        this.getTopYesterday().clear();
        this.saveFile();
    }

    @Override
    public void saveChallenges() {
        for (Challenge challenge : this.getChallenges()) {
            this.file.set("Challenges." + challenge.getChallengeName(), (Object)challenge.getTimeChallenge());
        }
        this.saveFile();
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void insertPlayerStat(PlayerStats playerStats) {
        this.file.set("Statistic." + playerStats.getPlayerName() + ".NumberVictories", (Object)playerStats.getNumberOfVictories());
        this.file.set("Statistic." + playerStats.getPlayerName() + ".NumberFirstPlace", (Object)playerStats.getNumberOfFirstPlace());
        this.file.set("Statistic." + playerStats.getPlayerName() + ".NumberSecondPlace", (Object)playerStats.getNumberOfSecondPlace());
        this.file.set("Statistic." + playerStats.getPlayerName() + ".NumberThirdPlace", (Object)playerStats.getNumberOfThirdPlace());
        this.addStat(playerStats);
        this.saveFile();
    }

    @Override
    public void deletePlayerStatWithPlayerName(String playerName) {
        this.file.set("Statistic." + playerName, null);
        this.removeStat(playerName);
        this.saveFile();
    }

    @Override
    public void deleteChallengeWithName(String challengeName) {
        this.file.set("Challenges." + challengeName, null);
        this.removeChallenge(challengeName);
        this.saveFile();
    }

    @Override
    public void updateChallenge(String nomeChallenge, int number) {
        this.file.set("Challenges." + nomeChallenge, (Object)number);
        this.updateChallengeTime(nomeChallenge, number);
        this.saveFile();
    }

    @Override
    public void updateChallenger(String playerName, long points) {
        this.file.set("Points." + playerName, (Object)points);
        this.updatePlayer(playerName, points);
        this.saveFile();
    }

    @Override
    public void insertChallengerEvent(String playerName, long value) {
        this.file.set("PointsLastChallenge." + playerName, (Object)((int)value));
        this.addOldPoints(new Challenger(playerName, value));
        this.saveFile();
    }

    @Override
    public void insertChallengerTopYesterday(String playerName, long points) {
        this.file.set("TopYesterday." + playerName, (Object)points);
        this.addTopYesterday(new Challenger(playerName, points));
        this.saveFile();
    }

    @Override
    public void insertChallenger(String playerName, long value) {
        this.addPlayerPoints(new Challenger(playerName, value));
        this.file.set("Points." + playerName, (Object)((int)value));
        this.saveFile();
    }

    @Override
    public void clearChallengesFromFile() {
        this.file.set("Challenges", null);
        this.saveFile();
    }

    @Override
    public void clearStats() {
        this.file.set("Statistic", null);
        this.getAllStats().clear();
        this.saveFile();
    }

    @Override
    public void insertChallenge(String challengeName, int time) {
        this.file.set("Challenges." + challengeName, (Object)time);
        this.saveFile();
    }

    @Override
    public void clearChallengersOld() {
        this.file.set("PointsLastChallenge", null);
        this.getOldPoints().clear();
        this.saveFile();
    }

    @Override
    public void deleteChallengerWithName(String playerName) {
        this.file.set("Points." + playerName, null);
        this.removePlayer(playerName);
        this.saveFile();
    }

    @Override
    public void clearChallengers() {
        this.file.set("Points", null);
        this.getPlayerPoints().clear();
        this.saveFile();
    }

    @Override
    public void clearChallenges() {
        this.file.set("Challenges", null);
        this.getChallenges().clear();
        this.saveFile();
    }

    @Override
    public void clearDailyWinners() {
        this.file.set("DailyWinners", null);
        this.getDailyWinners().clear();
        this.saveFile();
    }

    @Override
    public void deleteDailyWinnerWithId(int id) {
        this.file.set("DailyWinners." + id, null);
        this.removeDailyWinner(id);
        this.saveFile();
    }

    @Override
    public void insertDailyWinner(DailyWinner dailyWinner) {
        this.file.set("DailyWinners." + dailyWinner.getId() + ".PlayerName", (Object)dailyWinner.getPlayerName());
        this.file.set("DailyWinners." + dailyWinner.getId() + ".NomeChallenge", (Object)dailyWinner.getNomeChallenge());
        this.file.set("DailyWinners." + dailyWinner.getId() + ".Reward", (Object)dailyWinner.getReward());
        this.addDailyWinner(dailyWinner);
        this.saveFile();
    }

    @Override
    public void insertChallengeEvent(String challengeName, int time) {
        Challenge challenge = Main.instance.getConfigGesture().getChallengesEvent().get(challengeName);
        challenge.setChallengeName("Event_" + challengeName);
        challenge.setTimeChallenge(time);
        this.addChallenge(challenge, 0);
        this.clearChallengesFromFile();
        for (Challenge challenge1 : this.getChallenges()) {
            this.insertChallenge(challenge1.getChallengeName(), challenge1.getTimeChallenge());
        }
        this.saveFile();
    }

    @Override
    public void clearAll() {
        this.configFile.delete();
    }

    public void saveFile() {
        try {
            this.file.save(this.configFile);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }
}

