/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import com.HeroxWar.HeroxCore.MessageGesture;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ChatEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("ChatEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final List<String> quests = Main.instance.getDailyChallenge().getQuests();
    private String word = "";
    private String quest = "";
    private final String message = Main.instance.getConfigGesture().getMessages().get("ChatWord");
    private final String correctAnswer = Main.instance.getConfigGesture().getMessages().get("CorrectAnswer");
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    public ChatEvent() {
        this.start(2400L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        String world = e.getPlayer().getWorld().getName();
        String playerName = e.getPlayer().getName();
        if (this.debugActive) {
            this.debugUtils.addLine("message: " + e.getMessage() + " word: " + this.word);
        }
        if (this.superiorSkyBlock2Enabled) {
            if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                if (this.debugActive) {
                    this.debugUtils.addLine("Player is inside his own island");
                }
            } else {
                if (this.debugActive) {
                    this.debugUtils.addLine("Player isn't inside his own island");
                    this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
                return;
            }
        }
        if (!Controls.hasPermission(playerName)) {
            return;
        }
        if (Controls.isWorldEnable(world, this.debugActive, this.debugUtils, tempo)) {
            return;
        }
        if (e.getMessage().equalsIgnoreCase(this.word)) {
            Main.instance.getDailyChallenge().increment(e.getPlayer().getName(), (long)this.point * (long)this.word.length());
            for (Player p : Bukkit.getOnlinePlayers()) {
                MessageGesture.sendMessage((CommandSender)p, this.correctAnswer.replace("{player}", e.getPlayer().getName()));
            }
            if (this.debugActive) {
                this.debugUtils.addLine("add " + this.point * this.word.length() + " points at " + e.getPlayer().getName());
            }
            this.word = "";
        }
        if (this.debugActive) {
            this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
            this.debugUtils.debug();
        }
    }

    public void start(long time) {
        this.execute(time);
    }

    public void execute(long time) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("world broadcasted: " + this.word);
            }
            this.word = "";
            this.quest = "";
            this.generateWord();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.quest.equalsIgnoreCase("")) {
                    MessageGesture.sendMessage((CommandSender)p, this.quest);
                    continue;
                }
                MessageGesture.sendMessage((CommandSender)p, this.message.replace("{points}", this.word.length() * this.point + "").replace("{word}", this.word));
            }
        }, 0L, time);
        Main.instance.getConfigGesture().getTasks().addExternalTasks(task, "ChatEvent", false);
    }

    public void generateWord() {
        Random random = new Random();
        if (this.quests.size() == 1 && this.quests.get(0).contains("Formatter")) {
            String alphabet = this.quests.get(0).split(":")[1];
            int number = random.nextInt(15) + 1;
            for (int i = 0; i < number; ++i) {
                this.word = this.word + alphabet.charAt(random.nextInt(alphabet.length()));
            }
            if (this.debugActive) {
                this.debugUtils.addLine("world generated: " + this.word);
            }
        } else {
            String quest = this.quests.get(random.nextInt(this.quests.size()));
            this.word = quest.split(":")[1];
            this.quest = quest.split(":")[0];
        }
    }
}

