/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class DropperEvent
implements Listener {
    private final DebugUtils debugUtils = new DebugUtils("DropperEvent");
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("DropperEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onMove(PlayerMoveEvent e) {
        long tempo = System.currentTimeMillis();
        if (e.getTo() == null) {
            if (this.debugActive) {
                this.debugUtils.addLine("EndLocation= null");
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
            return;
        }
        String playerName = e.getPlayer().getName();
        String worldName = e.getPlayer().getWorld().getName();
        Location from = e.getFrom();
        Location to = e.getTo();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            int number = to.getBlockY() - from.getBlockY();
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerMoving= " + playerName);
                this.debugUtils.addLine("JumpHeight= " + number);
                this.debugUtils.addLine("CalculationHeight= " + to.getBlockY() + " " + from.getBlockY());
            }
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (!Controls.hasPermission(playerName)) {
                return;
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (number < 0) {
                Main.instance.getDailyChallenge().increment(playerName, (long)Math.negateExact(this.point) * (long)number);
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

