/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.Lands.LandsUtils;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class DyeEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("DyeEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean keepInventory = Main.instance.getDailyChallenge().isKeepInventory();
    private final boolean deathInLand = Main.instance.getDailyChallenge().isDeathInLand();
    private final boolean landsEnabled = Main.instance.getConfigGesture().getHooks().get("Lands");
    private final int numberOfSlots = Main.instance.getDailyChallenge().getNumber();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDeath(PlayerDeathEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        String playerName = e.getEntity().getName();
        String worldName = e.getEntity().getWorld().getName();
        String causePlayer = e.getEntity().getLastDamageCause().getCause().toString();
        Location playerLocation = e.getEntity().getLocation();
        boolean sneakingPlayer = e.getEntity().isSneaking();
        PlayerInventory inventory = e.getEntity().getInventory();
        String itemInHandPlayer = e.getEntity().getInventory().getItemInHand().getType().toString();
        if (this.keepInventory) {
            e.setKeepInventory(true);
        }
        if (Controls.isItemInInventory((Inventory)inventory, this.debugActive, this.debugUtils, tempo)) {
            return;
        }
        int sizeInventory = 0;
        if (this.numberOfSlots != -1) {
            for (int i = 0; i < inventory.getStorageContents().length; ++i) {
                if (inventory.getItem(i) == null) continue;
                ++sizeInventory;
            }
        }
        int inventorySize = sizeInventory;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerDye= " + playerName);
            }
            if (this.deathInLand && this.landsEnabled) {
                if (LandsUtils.isTrusted(playerLocation, playerName)) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is trusted at Land");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is not trusted at Land");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (!Controls.hasPermission(playerName)) {
                return;
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isCause(causePlayer, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isSneaking(sneakingPlayer, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isItemInHand(itemInHandPlayer, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (this.numberOfSlots != -1 && inventorySize != this.numberOfSlots) {
                if (this.debugActive) {
                    this.debugUtils.addLine("NumberOfSlot= " + inventorySize);
                    this.debugUtils.addLine("NumberOfSlotConfig= " + this.numberOfSlots);
                    this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
                return;
            }
            Main.instance.getDailyChallenge().increment(playerName, this.point);
        });
        if (this.debugActive) {
            this.debugUtils.addLine("AddedPoints= " + this.point);
            this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
            this.debugUtils.debug();
        }
    }
}

