/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.GriefPrevention.GriefPreventionUtils;
import io.eliotesta98.VanillaChallenges.Modules.Lands.LandsUtils;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Modules.WorldGuard.WorldGuardUtils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.plugin.Plugin;

public class FireCatcher
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("EntityCombustByBlockEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final boolean landsEnabled = Main.instance.getConfigGesture().getHooks().get("Lands");
    private final boolean worldGuardEnabled = Main.instance.getConfigGesture().getHooks().get("WorldGuard");
    private final boolean griefPreventionEnabled = Main.instance.getConfigGesture().getHooks().get("GriefPrevention");
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");
    private boolean ok = false;

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockBurn(EntityCombustByBlockEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        if (!(e.getEntity() instanceof Player)) {
            if (this.debugActive) {
                this.debugUtils.addLine("This Entity is not a Player");
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
            return;
        }
        Player player = (Player)e.getEntity();
        String itemInMainHand = player.getInventory().getItemInHand().getType().toString();
        boolean sneakingPlayer = player.isSneaking();
        Location location = player.getLocation();
        World world = player.getWorld();
        Block block = location.getBlock();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerBreaking= " + player.getName());
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                if (this.griefPreventionEnabled) {
                    this.ok = GriefPreventionUtils.isReasonOk(player, block, (Event)e);
                }
            });
            if (this.ok) {
                this.ok = false;
                if (this.debugActive) {
                    this.debugUtils.addLine("Player is not trusted at Claim");
                    this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
                return;
            }
            if (this.landsEnabled) {
                if (LandsUtils.isTrusted(location, player.getName())) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is trusted at Land");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is not trusted at Land");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (this.worldGuardEnabled && WorldGuardUtils.isARagion(world, location)) {
                if (this.debugActive) {
                    this.debugUtils.addLine("Player is in a region");
                    this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    this.debugUtils.debug();
                }
                return;
            }
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(player.getName()))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (!Controls.hasPermission(player.getName())) {
                return;
            }
            if (Controls.isWorldEnable(world.getName(), this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isSneaking(sneakingPlayer, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isItemInHand(itemInMainHand, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            Main.instance.getDailyChallenge().increment(player.getName(), this.point);
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

