/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Events.Challenges;

import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Modules.SuperiorSkyblock2.SuperiorSkyBlock2Utils;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.plugin.Plugin;

public class HealthRegenEvent
implements Listener {
    private DebugUtils debugUtils;
    private final boolean debugActive = Main.instance.getConfigGesture().getDebug().get("HealthRegenEvent");
    private final int point = Main.instance.getDailyChallenge().getPoint();
    private final HashMap<String, Double> playersRegen = new HashMap();
    private final boolean superiorSkyBlock2Enabled = Main.instance.getConfigGesture().getHooks().get("SuperiorSkyblock2");

    @EventHandler(priority=EventPriority.NORMAL)
    public void onHealthRegen(EntityRegainHealthEvent e) {
        this.debugUtils = new DebugUtils((Event)e);
        long tempo = System.currentTimeMillis();
        EntityRegainHealthEvent.RegainReason reason = e.getRegainReason();
        double amount = e.getAmount();
        Player player = null;
        if (e.getEntity() instanceof Player) {
            player = (Player)e.getEntity();
        }
        if (player == null) {
            if (this.debugActive) {
                this.debugUtils.addLine("This is not a player");
            }
            return;
        }
        Player finalPlayer = player;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            String playerName = finalPlayer.getName();
            String worldName = finalPlayer.getWorld().getName();
            if (this.debugActive) {
                this.debugUtils.addLine("PlayerRegen= " + playerName);
            }
            if (this.superiorSkyBlock2Enabled) {
                if (SuperiorSkyBlock2Utils.isInsideIsland(SuperiorSkyBlock2Utils.getSuperiorPlayer(playerName))) {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player is inside his own island");
                    }
                } else {
                    if (this.debugActive) {
                        this.debugUtils.addLine("Player isn't inside his own island");
                        this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        this.debugUtils.debug();
                    }
                    return;
                }
            }
            if (!Controls.hasPermission(playerName)) {
                return;
            }
            if (Controls.isWorldEnable(worldName, this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (Controls.isCause(reason.toString(), this.debugActive, this.debugUtils, tempo)) {
                return;
            }
            if (this.playersRegen.get(playerName) == null) {
                this.playersRegen.put(playerName, amount);
            } else {
                double oldAmount = this.playersRegen.get(playerName);
                if ((oldAmount += amount) > 1.0) {
                    double truncate = Math.floor(oldAmount);
                    Main.instance.getDailyChallenge().increment(playerName, (long)(truncate * (double)this.point));
                    this.playersRegen.replace(playerName, oldAmount - truncate);
                } else {
                    this.playersRegen.replace(playerName, oldAmount);
                }
            }
            if (this.debugActive) {
                this.debugUtils.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                this.debugUtils.debug();
            }
        });
    }
}

