/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Interfaces;

import com.heroxplugins.external.VanillaChallenges.de.tr7zw.NBTCompound;
import com.heroxplugins.external.VanillaChallenges.de.tr7zw.NBTItem;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Interfaces.VanillaChallengesInterfaceHolder;
import io.eliotesta98.VanillaChallenges.Utils.Challenge;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class GuiEvent
implements Listener {
    private final boolean debugGui = Main.instance.getConfigGesture().getDebug().get("ClickGui");

    @EventHandler
    public void InventoryDragEvent(InventoryDragEvent e) {
        if (e.getInventory().getHolder() instanceof VanillaChallengesInterfaceHolder) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void InventoryDragEvent(InventoryMoveItemEvent e) {
        if (e.getInitiator().getHolder() instanceof VanillaChallengesInterfaceHolder) {
            e.setCancelled(true);
        } else if (e.getDestination().getHolder() instanceof VanillaChallengesInterfaceHolder) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        try {
            if (inventoryCloseEvent.getPlayer() instanceof Player && inventoryCloseEvent.getInventory().getHolder() instanceof VanillaChallengesInterfaceHolder) {
                NBTCompound nbtItem = null;
                for (int count = 0; count < inventoryCloseEvent.getInventory().getSize(); ++count) {
                    if (inventoryCloseEvent.getInventory().getItem(count) == null) continue;
                    nbtItem = new NBTItem(inventoryCloseEvent.getInventory().getItem(count));
                    break;
                }
                if (nbtItem != null) {
                    Main.instance.getConfigGesture().getInterfaces().get(nbtItem.getString("vc.currentInterface")).removeInventory(inventoryCloseEvent.getPlayer().getName());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @EventHandler
    public void cancelOnClick(InventoryClickEvent event) {
        if (event.getInventory().getHolder() instanceof VanillaChallengesInterfaceHolder) {
            try {
                Inventory inventory = event.getWhoClicked().getOpenInventory().getTopInventory();
                if (inventory.getHolder() instanceof VanillaChallengesInterfaceHolder) {
                    event.setCancelled(true);
                }
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        DebugUtils debug = new DebugUtils("Gui");
        long tempo = System.currentTimeMillis();
        if (inventoryClickEvent.getWhoClicked() instanceof Player) {
            Player player = (Player)inventoryClickEvent.getWhoClicked();
            Inventory inv = inventoryClickEvent.getClickedInventory();
            if (inv == null || !inv.getType().equals((Object)InventoryType.CHEST)) {
                if (this.debugGui) {
                    debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    debug.debug();
                }
                return;
            }
            if (inv.getHolder() instanceof VanillaChallengesInterfaceHolder) {
                inventoryClickEvent.setCancelled(true);
                if (inv.getItem(inventoryClickEvent.getSlot()) == null || inv.getItem(inventoryClickEvent.getSlot()).getType() == Material.AIR) {
                    if (this.debugGui) {
                        debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        debug.debug();
                    }
                    return;
                }
                NBTItem nbtItem = new NBTItem(inv.getItem(inventoryClickEvent.getSlot()));
                int pageNumber = nbtItem.getInteger("vc.numberPage");
                String typeInterface = nbtItem.getString("vc.currentInterface");
                int itemSlot = nbtItem.getInteger("vc.positionItem");
                List<String> slots = Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getSlots();
                String returnInterface = Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getNameInterfaceToReturn();
                String nameItemConfig = Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getItemsConfig().get(slots.get(inventoryClickEvent.getSlot())).getNameItemConfig();
                String interfaceToOpen = Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getNameInterfaceToOpen();
                if (typeInterface.equalsIgnoreCase("Challenges")) {
                    String currentItem = inventoryClickEvent.getCurrentItem().getType().toString();
                    short durability = inventoryClickEvent.getCurrentItem().getDurability();
                    String configItem = Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getItemsConfig().get(slots.get(inventoryClickEvent.getSlot())).getType();
                    if (this.debugGui) {
                        debug.addLine("Config Item=" + configItem);
                        debug.addLine("Current Item=" + currentItem);
                        if (durability != 0) {
                            debug.addLine("Current Item Durability=" + durability);
                        }
                        debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                        debug.debug();
                    }
                    boolean isItem113 = false;
                    if (!Main.version.isInRange(8, 12) && (configItem.equalsIgnoreCase(currentItem) || configItem.equalsIgnoreCase(currentItem + "-" + durability))) {
                        isItem113 = true;
                    }
                    if (isItem113 || Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getItemsConfig().get(slots.get(inventoryClickEvent.getSlot())).getType().equalsIgnoreCase(inventoryClickEvent.getCurrentItem().getType().toString())) {
                        if (nameItemConfig.equalsIgnoreCase("LeftPage")) {
                            player.closeInventory();
                            ArrayList<Challenge> challenges = new ArrayList<Challenge>();
                            int limit = (pageNumber - 1) * Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getSizeModificableSlot();
                            int count = 1;
                            int number = Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getSizeModificableSlot();
                            if (pageNumber != 1) {
                                for (Challenge entry : Main.db.getChallenges()) {
                                    if (limit < count && number > 0) {
                                        challenges.add(entry);
                                        --number;
                                    }
                                    ++count;
                                }
                            } else {
                                for (Challenge entry : Main.db.getChallenges()) {
                                    if (number != 0) {
                                        challenges.add(entry);
                                        --number;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            Main.instance.getConfigGesture().getInterfaces().get(typeInterface).openInterface(challenges, player, pageNumber);
                            if (this.debugGui) {
                                debug.addLine("Left Page");
                                debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                                debug.debug();
                            }
                            return;
                        }
                        if (nameItemConfig.equalsIgnoreCase("RightPage")) {
                            player.closeInventory();
                            ArrayList<Challenge> challenges = new ArrayList<Challenge>();
                            int limit = (pageNumber - 1) * Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getSizeModificableSlot();
                            int count = 1;
                            int number = Main.instance.getConfigGesture().getInterfaces().get(typeInterface).getSizeModificableSlot();
                            for (Challenge entry : Main.db.getChallenges()) {
                                if (limit < count && number > 0) {
                                    challenges.add(entry);
                                    --number;
                                }
                                ++count;
                            }
                            Main.instance.getConfigGesture().getInterfaces().get(typeInterface).openInterface(challenges, player, pageNumber);
                            if (this.debugGui) {
                                debug.addLine("Right Page");
                                debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                                debug.debug();
                            }
                            return;
                        }
                    }
                }
                if (this.debugGui) {
                    debug.addLine("Challenges List");
                    debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                    debug.debug();
                }
                return;
            }
            if (this.debugGui) {
                debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
                debug.debug();
            }
        }
    }
}

