/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Interfaces;

import com.HeroxWar.HeroxCore.SoundGesture.SoundType;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Interfaces.ItemConfig;
import io.eliotesta98.VanillaChallenges.Interfaces.VanillaChallengesInterfaceHolder;
import io.eliotesta98.VanillaChallenges.Utils.Challenge;
import io.eliotesta98.VanillaChallenges.Utils.DebugUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class Interface {
    private final String nameInterface;
    private final String nameInterfaceToOpen;
    private final String nameInterfaceToReturn;
    private String title;
    private List<String> slots;
    private final Map<String, ItemConfig> itemsConfig;
    private boolean debug;
    private final int sizeModificableSlot;
    private final Map<String, Inventory> interfacesOpened = new HashMap<String, Inventory>();
    private final SoundType soundOpen;

    public Interface(String title, String soundOpen, List<String> slots, Map<String, ItemConfig> itemsConfig, boolean debug, int sizeModificableSlot, String nameInterface, String nameInterfaceToOpen, String nameInterfaceToReturn) {
        this.title = title;
        this.soundOpen = new SoundType(soundOpen, 50.0, 1.0);
        this.itemsConfig = itemsConfig;
        this.debug = debug;
        this.sizeModificableSlot = sizeModificableSlot;
        this.slots = slots;
        this.nameInterface = nameInterface;
        this.nameInterfaceToOpen = nameInterfaceToOpen;
        this.nameInterfaceToReturn = nameInterfaceToReturn;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getSlots() {
        return this.slots;
    }

    public void setSlots(ArrayList<String> slots) {
        this.slots = slots;
    }

    public Map<String, ItemConfig> getItemsConfig() {
        return this.itemsConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getSizeModificableSlot() {
        return this.sizeModificableSlot;
    }

    public String getNameInterfaceToOpen() {
        return this.nameInterfaceToOpen;
    }

    public String getNameInterfaceToReturn() {
        return this.nameInterfaceToReturn;
    }

    public void removeInventory(String playerName) {
        this.interfacesOpened.remove(playerName);
    }

    public void closeAllInventories() {
        for (Map.Entry<String, Inventory> inventory : this.interfacesOpened.entrySet()) {
            if (Bukkit.getPlayer((String)inventory.getKey()) == null) continue;
            Bukkit.getPlayer((String)inventory.getKey()).closeInventory();
        }
    }

    public void openInterface(ArrayList<?> items, Player p, int numberOfPage) {
        DebugUtils debug = new DebugUtils("Interface Creation");
        long tempo = System.currentTimeMillis();
        VanillaChallengesInterfaceHolder holder = new VanillaChallengesInterfaceHolder(this.slots.size(), ChatColor.translateAlternateColorCodes((char)'&', (String)this.title));
        Inventory inventory = holder.getInventory();
        int slotModificable = items.size() - this.sizeModificableSlot;
        this.interfacesOpened.put(p.getName(), inventory);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            boolean lock = Main.instance.getConfigGesture().isLockedInterface();
            int countItems = 0;
            block0: for (int i = 0; i < this.slots.size(); ++i) {
                String slot = this.slots.get(i);
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("Challenge")) {
                    if (items.size() <= countItems || !(items.get(countItems) instanceof Challenge)) continue;
                    Challenge challenge = (Challenge)items.get(countItems);
                    Challenge challengeComplete = Main.instance.getConfigGesture().getChallenges().get(challenge.getChallengeName());
                    if (challenge.getChallengeName().contains("Event_")) {
                        challengeComplete = Main.instance.getConfigGesture().getChallengesEvent().get(challenge.getChallengeName().replace("Event_", ""));
                    }
                    if (!lock) {
                        inventory.setItem(i, this.itemsConfig.get(slot).createItemConfig(this.nameInterface, numberOfPage, "vc.numberPage:" + numberOfPage + ";vc.challengeName:" + challenge.getChallengeName() + ";vc.challengeTime:" + challenge.getTimeChallenge() + ";vc.challengeDescription:" + challengeComplete.getTitle() + ";vc.challengePoint:" + challengeComplete.getPoint() + ";vc.challengeItemsInHand:" + challengeComplete.getItemsInHand() + ";vc.challengeWords:" + challengeComplete.getWorlds() + ";vc.challengeBlocks:" + challengeComplete.getBlocks() + ";vc.challengeRewards:" + challengeComplete.getRewards() + ";vc.challengeSneaking:" + challengeComplete.getSneaking() + ";vc.challengeBlocksOnPlace:" + challengeComplete.getBlocksOnPlace() + ";vc.challengeVehicles:" + challengeComplete.getVehicle() + ";vc.challengeMobs:" + challengeComplete.getMobs() + ";vc.challengeItems:" + challengeComplete.getItems() + ";vc.challengeCauses:" + challengeComplete.getCauses() + ";vc.challengeColors:" + challengeComplete.getColors() + ";vc.challengeItem:" + challengeComplete.getItemChallenge(), i));
                    } else if (Main.instance.getDailyChallenge().getChallengeName().equalsIgnoreCase(challenge.getChallengeName())) {
                        inventory.setItem(i, this.itemsConfig.get(slot).createItemConfig(this.nameInterface, numberOfPage, "vc.numberPage:" + numberOfPage + ";vc.challengeName:" + challenge.getChallengeName() + ";vc.challengeTime:" + challenge.getTimeChallenge() + ";vc.challengeDescription:" + challengeComplete.getTitle() + ";vc.challengePoint:" + challengeComplete.getPoint() + ";vc.challengeItemsInHand:" + challengeComplete.getItemsInHand() + ";vc.challengeWords:" + challengeComplete.getWorlds() + ";vc.challengeBlocks:" + challengeComplete.getBlocks() + ";vc.challengeRewards:" + challengeComplete.getRewards() + ";vc.challengeSneaking:" + challengeComplete.getSneaking() + ";vc.challengeBlocksOnPlace:" + challengeComplete.getBlocksOnPlace() + ";vc.challengeVehicles:" + challengeComplete.getVehicle() + ";vc.challengeMobs:" + challengeComplete.getMobs() + ";vc.challengeItems:" + challengeComplete.getItems() + ";vc.challengeCauses:" + challengeComplete.getCauses() + ";vc.challengeColors:" + challengeComplete.getColors() + ";vc.challengeItem:" + challengeComplete.getItemChallenge(), i));
                    } else {
                        inventory.setItem(i, this.itemsConfig.get(slot.concat("1")).createItemConfig(this.nameInterface, numberOfPage, "vc.numberPage:" + numberOfPage + ";vc.challengeName:" + challenge.getChallengeName() + ";vc.challengeTime:" + challenge.getTimeChallenge() + ";vc.challengeDescription:" + challengeComplete.getTitle() + ";vc.challengePoint:" + challengeComplete.getPoint() + ";vc.challengeItemsInHand:" + challengeComplete.getItemsInHand() + ";vc.challengeWords:" + challengeComplete.getWorlds() + ";vc.challengeBlocks:" + challengeComplete.getBlocks() + ";vc.challengeRewards:" + challengeComplete.getRewards() + ";vc.challengeSneaking:" + challengeComplete.getSneaking() + ";vc.challengeBlocksOnPlace:" + challengeComplete.getBlocksOnPlace() + ";vc.challengeVehicles:" + challengeComplete.getVehicle() + ";vc.challengeMobs:" + challengeComplete.getMobs() + ";vc.challengeItems:" + challengeComplete.getItems() + ";vc.challengeCauses:" + challengeComplete.getCauses() + ";vc.challengeColors:" + challengeComplete.getColors() + ";vc.challengeItem:" + challengeComplete.getItemChallenge(), i));
                    }
                    ++countItems;
                    continue;
                }
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("LeftPage")) {
                    if (numberOfPage - 1 != 0) {
                        inventory.setItem(i, this.itemsConfig.get(slot).createItemConfig(this.nameInterface, numberOfPage - 1, "vc.numberPage:" + (numberOfPage - 1), i));
                        continue;
                    }
                    for (Map.Entry<String, ItemConfig> itemConfig : this.itemsConfig.entrySet()) {
                        if (!itemConfig.getValue().getNameItemConfig().equalsIgnoreCase("Border")) continue;
                        inventory.setItem(i, this.itemsConfig.get(itemConfig.getKey()).createItemConfig(this.nameInterface, 0, "", i));
                        continue block0;
                    }
                    continue;
                }
                if (this.itemsConfig.get(slot).getNameItemConfig().equalsIgnoreCase("RightPage")) {
                    if (slotModificable == 0) {
                        inventory.setItem(i, this.itemsConfig.get(slot).createItemConfig(this.nameInterface, numberOfPage + 1, "vc.numberPage:" + (numberOfPage + 1), i));
                        continue;
                    }
                    for (Map.Entry<String, ItemConfig> itemConfig : this.itemsConfig.entrySet()) {
                        if (!itemConfig.getValue().getNameItemConfig().equalsIgnoreCase("Border")) continue;
                        inventory.setItem(i, this.itemsConfig.get(itemConfig.getKey()).createItemConfig(this.nameInterface, 0, "", i));
                        continue block0;
                    }
                    continue;
                }
                inventory.setItem(i, this.itemsConfig.get(slot).createItemConfig(this.nameInterface, 0, "", i));
            }
            this.soundOpen.playSound(p);
        });
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> p.openInventory(inventory));
        if (this.debug) {
            debug.addLine("execution time= " + (System.currentTimeMillis() - tempo));
            debug.debug();
        }
    }
}

