/*
 * Decompiled with CFR 0.152.
 */
package io.eliotesta98.VanillaChallenges.Utils;

import com.HeroxWar.HeroxCore.MessageGesture;
import io.eliotesta98.VanillaChallenges.Core.Main;
import io.eliotesta98.VanillaChallenges.Database.Objects.Challenger;
import io.eliotesta98.VanillaChallenges.Database.Objects.DailyWinner;
import io.eliotesta98.VanillaChallenges.Database.Objects.PlayerStats;
import io.eliotesta98.VanillaChallenges.Events.ApiEvents.ChallengeChangeEvent;
import io.eliotesta98.VanillaChallenges.Events.Challenges.ItemCollector.ItemCollector;
import io.eliotesta98.VanillaChallenges.Events.Challenges.Modules.Controls;
import io.eliotesta98.VanillaChallenges.Interfaces.Interface;
import io.eliotesta98.VanillaChallenges.Utils.MoneyUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Tasks {
    private final ArrayList<BukkitTask> tasks = new ArrayList();
    private final HashMap<String, Boolean> saving = new HashMap();
    private BukkitTask checkStart = null;
    private boolean challengeStart = false;
    private final HashMap<String, Integer> minutesOnlinePlayer = new HashMap();
    private static final Pattern hexPattern = Pattern.compile("\\{block[0-9]\\}");

    public void stopAllTasks() {
        for (BukkitTask task : this.tasks) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public boolean isChallengeStart() {
        return !this.challengeStart;
    }

    public void broadcast(long time, String actuallyInTop, String pointsEveryMinutes, String pointsRemainForBoosting, String pointsRemainForBoostingSinglePlayer, int numberOfTop, String pointsRemainForReward) {
        this.saving.put("Broadcast", false);
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            this.saving.replace("Broadcast", true);
            for (Player p : Bukkit.getOnlinePlayers()) {
                long pointsRemain;
                if (Main.instance.getConfigGesture().getTasks().isChallengeStart()) break;
                Main.instance.getDailyChallenge().message((CommandSender)p);
                List<Challenger> top = Main.instance.getConfigGesture().isYesterdayTop() ? Main.db.getTopYesterday() : Main.instance.getDailyChallenge().getTopPlayers(numberOfTop);
                if (!top.isEmpty()) {
                    MessageGesture.sendMessage((CommandSender)p, actuallyInTop);
                }
                int i = 1;
                for (Challenger challenger : top) {
                    MessageGesture.sendMessage((CommandSender)p, Main.instance.getConfigGesture().getMessages().get("topPlayers" + i).replace("{number}", "" + i).replace("{player}", challenger.getNomePlayer()).replace("{points}", MoneyUtils.transform(challenger.getPoints())));
                    ++i;
                }
                if (Main.instance.getConfigGesture().getMinimumPoints() != -1) {
                    if (!Main.instance.getDailyChallenge().isMinimumPointsReached()) {
                        MessageGesture.sendMessage((CommandSender)p, pointsRemainForReward.replace("{points}", Main.instance.getDailyChallenge().getPointsRemain() + ""));
                    } else {
                        MessageGesture.sendMessage((CommandSender)p, pointsRemainForReward.replace("{points}", "0"));
                    }
                }
                if (Main.instance.getDailyChallenge().getMin10PlayersPoints().get(p.getName()) != null) {
                    String minutes = time / 60L / 20L + "";
                    MessageGesture.sendMessage((CommandSender)p, pointsEveryMinutes.replace("{points}", MoneyUtils.transform(Main.instance.getDailyChallenge().getMin10PlayersPoints().get(p.getName()))).replace("{minutes}", minutes));
                }
                if (!Main.instance.getDailyChallenge().isActive() && (pointsRemain = (long)Main.instance.getDailyChallenge().getPointsBoost() - Main.instance.getDailyChallenge().getCountPointsChallenge()) > 0L) {
                    MessageGesture.sendMessage((CommandSender)p, pointsRemainForBoosting.replace("{points}", pointsRemain + ""));
                }
                if (Main.instance.getDailyChallenge().isActiveSingleBoost(p.getName()) || (pointsRemain = (long)Main.instance.getDailyChallenge().getPointsBoostSinglePlayer() - Main.instance.getDailyChallenge().getCountPointsChallengeSinglePlayer(p.getName())) <= 0L) continue;
                MessageGesture.sendMessage((CommandSender)p, pointsRemainForBoostingSinglePlayer.replace("{points}", pointsRemain + ""));
            }
            Main.instance.getDailyChallenge().getMin10PlayersPoints().clear();
            this.saving.replace("Broadcast", false);
        }, 0L, time);
        this.tasks.add(task);
    }

    public void checkStartDay() {
        this.saving.put("CheckStartDay", false);
        this.checkStart = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, new Runnable(){
            final String startChallenge = Main.instance.getDailyChallenge().getStartTimeChallenge();
            final String endChallenge = Main.instance.getDailyChallenge().getEndTimeChallenge();
            final String[] startSplit = this.startChallenge.split(":");
            final String[] endSplit = this.endChallenge.split(":");
            final int startHour = Integer.parseInt(this.startSplit[0]);
            final int startMinutes = Integer.parseInt(this.startSplit[1]);
            final int endHour = Integer.parseInt(this.endSplit[0]);
            final int endMinutes = Integer.parseInt(this.endSplit[1]);

            @Override
            public void run() {
                Tasks.this.saving.replace("CheckStartDay", true);
                SimpleDateFormat sdf = new SimpleDateFormat("ss.mm.HH.dd.MM.yyyy");
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                String data = sdf.format(timestamp);
                try {
                    Date now = sdf.parse(data);
                    String[] dataSplit = data.split(Pattern.quote("."));
                    String endData = "00." + this.endMinutes + "." + this.endHour + "." + dataSplit[3] + "." + dataSplit[4] + "." + dataSplit[5];
                    String startData = "00." + this.startMinutes + "." + this.startHour + "." + dataSplit[3] + "." + dataSplit[4] + "." + dataSplit[5];
                    Date end = sdf.parse(endData);
                    Date start = sdf.parse(startData);
                    if (now.compareTo(start) > 0 && now.compareTo(end) < 0) {
                        Main.instance.getConfigGesture().getTasks().checkDay(72000L, Main.instance.getConfigGesture().isResetPointsAtNewChallenge(), Main.instance.getConfigGesture().isRankingReward(), Main.instance.getConfigGesture().isRandomReward(), Main.instance.getConfigGesture().getNumberOfRewardPlayer(), Main.instance.getConfigGesture().getNumberOfTop());
                        Tasks.this.challengeStart = true;
                    } else {
                        Tasks.this.challengeStart = false;
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                Tasks.this.saving.replace("CheckStartDay", false);
            }
        }, 0L, 1200L);
        this.tasks.add(this.checkStart);
    }

    public void checkDay(long time, final boolean resetPoints, final boolean rankingReward, final boolean randomReward, final int numberOfRewardedPlayer, final int numberOfTop) {
        this.saving.put("CheckDay", false);
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, new Runnable(){
            boolean firstTime = true;
            final /* synthetic */ Tasks this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.saving.replace("CheckDay", true);
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[VanillaChallenges] Backup challenge: " + Main.instance.getDailyChallenge().getTypeChallenge());
                if (!this.firstTime) {
                    Main.instance.getDailyChallenge().setTimeChallenge(Main.instance.getDailyChallenge().getTimeChallenge() - 1);
                } else {
                    this.firstTime = false;
                    this.this$0.checkStart.cancel();
                }
                if (Main.instance.getDailyChallenge().getTimeChallenge() <= 0) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> {
                        ChallengeChangeEvent challengeChangeEvent = new ChallengeChangeEvent("Challenge Time Finished", Main.instance.getDailyChallenge());
                        Bukkit.getPluginManager().callEvent((Event)challengeChangeEvent);
                        if (challengeChangeEvent.isCancelled()) {
                            return;
                        }
                        List<Challenger> topPlayers = Main.instance.getDailyChallenge().getTopPlayers(numberOfRewardedPlayer);
                        Main.db.deleteChallengeWithName(Main.instance.getDailyChallenge().getChallengeName());
                        Main.db.removeTopYesterday();
                        Main.db.saveTopYesterday(Main.instance.getDailyChallenge().getTopPlayers(numberOfTop));
                        if (Main.instance.getDailyChallenge().getTypeChallenge().equalsIgnoreCase("ItemCollectionChallenge")) {
                            ItemCollector.deleteDb();
                        }
                        if (Main.instance.getConfigGesture().isBackupEnabled()) {
                            Main.db.backupDb(Main.instance.getConfigGesture().getNumberOfFilesInFolderForBackup());
                        }
                        int number = Main.db.lastDailyWinnerId();
                        Random random = new Random();
                        if (Main.instance.getDailyChallenge().isMinimumPointsReached()) {
                            for (int z = 0; z < topPlayers.size(); ++z) {
                                PlayerStats playerStats;
                                int placeInTop = z;
                                int rewardsSize = Main.instance.getDailyChallenge().getRewards().size();
                                if (z >= rewardsSize) {
                                    placeInTop = rewardsSize - 1;
                                }
                                if (Main.db.isPlayerHaveStats(topPlayers.get(z).getNomePlayer())) {
                                    playerStats = Main.db.getStatsPlayer(topPlayers.get(z).getNomePlayer());
                                    playerStats.setNumberOfVictories(playerStats.getNumberOfVictories() + 1);
                                    if (z == 0) {
                                        playerStats.setNumberOfFirstPlace(playerStats.getNumberOfFirstPlace() + 1);
                                    } else if (z == 1) {
                                        playerStats.setNumberOfSecondPlace(playerStats.getNumberOfSecondPlace() + 1);
                                    } else if (z == 2) {
                                        playerStats.setNumberOfThirdPlace(playerStats.getNumberOfThirdPlace() + 1);
                                    }
                                    Main.db.updatePlayerStat(playerStats);
                                } else {
                                    playerStats = new PlayerStats();
                                    playerStats.setPlayerName(topPlayers.get(z).getNomePlayer());
                                    playerStats.setNumberOfVictories(1);
                                    if (z == 0) {
                                        playerStats.setNumberOfFirstPlace(1);
                                    } else if (z == 1) {
                                        playerStats.setNumberOfSecondPlace(1);
                                    } else if (z == 2) {
                                        playerStats.setNumberOfThirdPlace(1);
                                    }
                                    Main.db.insertPlayerStat(playerStats);
                                }
                                ++number;
                                DailyWinner dailyWinner = new DailyWinner();
                                dailyWinner.setPlayerName(topPlayers.get(z).getNomePlayer());
                                dailyWinner.setNomeChallenge(Main.instance.getDailyChallenge().getChallengeName());
                                if (rankingReward) {
                                    dailyWinner.setId(number);
                                    dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(placeInTop));
                                    Main.db.insertDailyWinner(dailyWinner);
                                    continue;
                                }
                                if (randomReward) {
                                    dailyWinner.setId(number);
                                    dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(random.nextInt(rewardsSize)));
                                    Main.db.insertDailyWinner(dailyWinner);
                                    continue;
                                }
                                for (int i = 0; i < rewardsSize; ++i) {
                                    dailyWinner.setId(number);
                                    dailyWinner.setReward(Main.instance.getDailyChallenge().getRewards().get(i));
                                    Main.db.insertDailyWinner(dailyWinner);
                                    ++number;
                                }
                            }
                        }
                        if (resetPoints) {
                            Main.db.clearChallengers();
                            Main.instance.getDailyChallenge().clearPlayers();
                        }
                        if (Main.challengeSelected) {
                            Main.instance.getDailyChallenge().clearPlayers();
                            for (Map.Entry<String, Interface> interfaces : Main.instance.getConfigGesture().getInterfaces().entrySet()) {
                                interfaces.getValue().closeAllInventories();
                            }
                        }
                        Main.instance.unregisterCurrentListener();
                        Main.instance.getConfigGesture().getTasks().stopAllTasks();
                        Main.instance.pluginStartingProcess();
                    });
                } else {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.instance, () -> Main.db.updateChallenge(Main.instance.getDailyChallenge().getChallengeName(), Main.instance.getDailyChallenge().getTimeChallenge()));
                }
                this.this$0.saving.replace("CheckDay", false);
            }
        }, 0L, time);
        this.tasks.add(task);
    }

    public void onlinePoints(int minutes, int point) {
        this.saving.put("OnlinePoints", false);
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.instance, () -> {
            this.saving.replace("OnlinePoints", true);
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.minutesOnlinePlayer.get(p.getName()) == null) {
                    this.minutesOnlinePlayer.put(p.getName(), 0);
                    continue;
                }
                if (this.minutesOnlinePlayer.get(p.getName()) == minutes) {
                    if (!Controls.hasPermission(p.getName())) {
                        return;
                    }
                    Main.instance.getDailyChallenge().increment(p.getName(), point);
                    this.minutesOnlinePlayer.replace(p.getName(), 0);
                    continue;
                }
                this.minutesOnlinePlayer.replace(p.getName(), this.minutesOnlinePlayer.get(p.getName()) + 1);
            }
            this.saving.replace("OnlinePoints", false);
        }, 0L, 1200L);
        this.tasks.add(task);
    }

    public void addExternalTasks(BukkitTask task, String savingName, boolean save) {
        this.tasks.add(task);
        this.saving.put(savingName, save);
    }

    public void changeStatusExternalTasks(String savingName) {
        this.saving.replace(savingName, this.saving.get(savingName) == false);
    }

    public boolean getIfTaskSaving(String nameTask) {
        return this.saving.get(nameTask);
    }
}

