package dev.denismasterherobrine.afterdark.forge.registry;

import dev.denismasterherobrine.afterdark.TheAfterdark;
import dev.denismasterherobrine.afterdark.blocks.entity.TeleportBlockEntity;
import dev.denismasterherobrine.afterdark.features.*;
import dev.denismasterherobrine.afterdark.features.configuration.*;
import dev.denismasterherobrine.afterdark.registry.AfterdarkRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

import java.util.Set;

@SuppressWarnings("unused")
@Mod.EventBusSubscriber(modid = TheAfterdark.MOD_ID, bus = Mod.EventBusSubscriber.Bus.MOD)
public class AfterdarkForgeRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create(ForgeRegistries.BLOCKS, TheAfterdark.MOD_ID);
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES =
            DeferredRegister.create(ForgeRegistries.BLOCK_ENTITY_TYPES, TheAfterdark.MOD_ID);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create(ForgeRegistries.ITEMS, TheAfterdark.MOD_ID);
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create(ForgeRegistries.FEATURES, TheAfterdark.MOD_ID);

    public static final RegistryObject<Block> TELEPORT_BLOCK = BLOCKS.register("teleport_block", () -> AfterdarkRegistry.TELEPORT_BLOCK);
    public static final RegistryObject<Item> TELEPORT_BLOCK_ITEM = ITEMS.register("teleport_block", () -> AfterdarkRegistry.TELEPORT_BLOCK_ITEM);
    public static final RegistryObject<Item> TELEPORT_CATALYST_ITEM = ITEMS.register("teleport_catalyst", () -> AfterdarkRegistry.TELEPORT_CATALYST_ITEM);
    public static final RegistryObject<BlockEntityType<?>> TELEPORT_BLOCK_ENTITY = BLOCK_ENTITIES.register(TeleportBlockEntity.TELEPORT_BE_ID, () -> new BlockEntityType<>(TeleportBlockEntity::new, Set.of(TELEPORT_BLOCK.get())));


    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS =
            DeferredRegister.create(BuiltInRegistries.CREATIVE_MODE_TAB.key(), TheAfterdark.MOD_ID);

    public static final RegistryObject<CreativeModeTab> AFTERDARK = CREATIVE_MODE_TABS.register("afterdark", () -> AfterdarkRegistry.AFTERDARK);

    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_BASALT_PILLAR = FEATURES.register("large_basalt_pillar", () -> new LargeBasaltPillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<VerticalBlobConfiguration>> CRYSTAL_SPIKE = FEATURES.register("crystal_spike", () -> new CrystalSpikeFeature(VerticalBlobConfiguration.CODEC));
    public static final RegistryObject<Feature<SpiralConfiguration>> SPIRAL = FEATURES.register("spiral", () -> new SpiralFeature(SpiralConfiguration.CODEC));
    public static final RegistryObject<Feature<VerticalBlobConfiguration>> ADDITIVE_BLOB = FEATURES.register("additive_blob", () -> new AdditiveBlobFeature(VerticalBlobConfiguration.CODEC));
    public static final RegistryObject<Feature<AnvilRockConfiguration>> ANVIL_ROCK_FEATURE = FEATURES.register("anvil_rock", () -> new AnvilRockFeature(AnvilRockConfiguration.CODEC));
    public static final RegistryObject<Feature<CatchingFallConfiguration>> CATCHING_FALL = FEATURES.register("catching_fall", () -> new CatchingFallFeature(CatchingFallConfiguration.CODEC));
    public static final RegistryObject<Feature<DoubleBlockConfiguration>> POND = FEATURES.register("pond", () -> new PondFeature(DoubleBlockConfiguration.CODEC));
    public static final RegistryObject<Feature<VerticalBlobConfiguration>> ADDITIVE_GROUND_BLOB = FEATURES.register("additive_ground_blob", () -> new AdditiveGroundBlobFeature(VerticalBlobConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_CALCITE_PILLAR = FEATURES.register("large_calcite_pillar", () -> new LargeCalcitePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_PRISMARINE_PILLAR = FEATURES.register("large_prismarine_pillar", () -> new LargePrismarinePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_DARK_PRISMARINE_PILLAR = FEATURES.register("large_dark_prismarine_pillar", () -> new LargeDarkPrismarinePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_SLIME_PILLAR = FEATURES.register("large_slime_pillar", () -> new LargeSlimePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<WaterloggableRandomPatchConfiguration>> WATERLOGGABLE_RANDOM_PATCH_FEATURE = FEATURES.register("waterloggable_random_patch", () -> new WaterloggableRandomPatchFeature(WaterloggableRandomPatchConfiguration.CODEC));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CAVE_KELP_FEATURE = FEATURES.register("cave_kelp", () -> new CaveKelpFeature(NoneFeatureConfiguration.CODEC));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CAVE_PICKLE_FEATURE = FEATURES.register("cave_pickle", () -> new CavePickleFeature(NoneFeatureConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_DEEPSLATE_PILLAR = FEATURES.register("large_deepslate_pillar", () -> new LargeDeepslatePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> CAVE_SEAGRASS_FEATURE = FEATURES.register("cave_seagrass", () -> new CaveSeagrassFeature(ProbabilityFeatureConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_OBSIDIAN_PILLAR = FEATURES.register("large_obsidian_pillar", () -> new LargeObsidianPillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<DiskConfiguration>> SUPPORTED_DISK_FEATURE = FEATURES.register("supported_disk", () -> new SupportedDiskFeature(DiskConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_PACKED_ICE_PILLAR = FEATURES.register("large_packed_ice_pillar", () -> new LargePackedIcePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_ICE_PILLAR = FEATURES.register("large_ice_pillar", () -> new LargeIcePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_BLUE_ICE_PILLAR = FEATURES.register("large_blue_ice_pillar", () -> new LargeBlueIcePillarFeature(LargeDripstoneConfiguration.CODEC));

    // Raw Ore Pillars
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_RAW_IRON_PILLAR = FEATURES.register("raw_iron_pillar", () -> new LargeRawIronPillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_RAW_COPPER_PILLAR = FEATURES.register("raw_copper_pillar", () -> new LargeRawCopperPillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_RAW_GOLD_PILLAR = FEATURES.register("raw_gold_pillar", () -> new LargeRawGoldPillarFeature(LargeDripstoneConfiguration.CODEC));

    // Ore Pillars
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_REDSTONE_ORE_PILLAR = FEATURES.register("redstone_ore_pillar", () -> new LargeRedstoneOrePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_LAPIS_ORE_PILLAR = FEATURES.register("lapis_ore_pillar", () -> new LargeLapisOrePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_EMERALD_ORE_PILLAR = FEATURES.register("emerald_ore_pillar", () -> new LargeEmeraldOrePillarFeature(LargeDripstoneConfiguration.CODEC));
    public static final RegistryObject<Feature<LargeDripstoneConfiguration>> LARGE_DIAMOND_ORE_PILLAR = FEATURES.register("diamond_ore_pillar", () -> new LargeDiamondOrePillarFeature(LargeDripstoneConfiguration.CODEC));

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        ITEMS.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
        FEATURES.register(eventBus);
    }
}