/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.MainHelpCommand;
import org.leralix.lib.commands.SubCommand;

public abstract class CommandManager
implements CommandExecutor,
TabExecutor,
TabCompleter {
    protected final HashMap<String, SubCommand> subCommands;
    protected final String permissionBase;

    protected CommandManager(String permissionBase) {
        this.permissionBase = permissionBase;
        this.subCommands = new HashMap();
    }

    protected void addSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName(), subCommand);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        SubCommand subCommand;
        if (args.length > 0 && (subCommand = this.subCommands.get(args[0])) != null && sender.hasPermission(this.getFullPermission(subCommand.getName()))) {
            subCommand.perform(sender, args);
            return true;
        }
        if (sender instanceof Player) {
            new MainHelpCommand(this).perform(sender, args);
            return true;
        }
        return false;
    }

    private String getFullPermission(String subCommand) {
        return this.permissionBase + "." + subCommand;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            for (SubCommand subCmd : this.subCommands.values()) {
                if (!sender.hasPermission(this.getFullPermission(subCmd.getName())) || !subCmd.getName().startsWith(args[0].toLowerCase())) continue;
                suggestions.add(subCmd.getName());
            }
            return suggestions;
        }
        SubCommand subCommand = this.subCommands.get(args[0]);
        if (subCommand == null) {
            return suggestions;
        }
        List<String> subCommandSuggestions = subCommand.getTabCompleteSuggestions(sender, args[0].toLowerCase(), args);
        if (subCommandSuggestions == null) {
            return suggestions;
        }
        for (String suggestion : subCommandSuggestions) {
            if (!suggestion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    public Collection<SubCommand> getSubCommands() {
        return this.subCommands.values();
    }

    public abstract String getName();
}

