/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.commands;

import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.CommandManager;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.lib.commands.SubCommand;
import org.leralix.lib.lang.Lang;

public class MainHelpCommand
extends PlayerSubCommand {
    CommandManager commandManager;

    public MainHelpCommand(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return Lang.HELP_DESC.get();
    }

    @Override
    public int getArguments() {
        return 1;
    }

    @Override
    public String getSyntax() {
        return "/tan help <page n\u00b0>";
    }

    @Override
    public List<String> getTabCompleteSuggestions(Player player, String currentMessage, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 2) {
            suggestions.add("<page n\u00b0>");
        }
        return suggestions;
    }

    @Override
    public void perform(Player player, String[] args) {
        if (args.length <= 1) {
            this.sendHelp(player, 0);
        } else {
            try {
                int page = Integer.parseInt(args[1]);
                this.sendHelp(player, page);
            }
            catch (NumberFormatException e) {
                player.sendMessage(Lang.PLEASE_ENTER_A_VALID_NUMBER.get());
            }
        }
    }

    private void sendHelp(Player p, int page) {
        ArrayList<SubCommand> commandList = new ArrayList<SubCommand>(this.commandManager.getSubCommands());
        int maxPage = (7 + commandList.size()) / 8 - 1;
        if (page < 0) {
            page = 0;
        }
        if (page > maxPage) {
            page = maxPage;
        }
        p.sendMessage("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u27e2\u27d0\u27e3\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u256e");
        commandList.subList(page * 8, Math.min(commandList.size(), (page + 1) * 8)).forEach(subCommand -> p.sendMessage(subCommand.getSyntax() + String.valueOf(ChatColor.GRAY) + " - " + subCommand.getDescription()));
        ComponentBuilder pageLine = new ComponentBuilder();
        pageLine.append("\u2570\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        pageLine.append("<<");
        pageLine.color(ChatColor.GOLD);
        pageLine.bold(true);
        pageLine.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.commandManager.getName() + " help " + (page - 1)));
        pageLine.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(Lang.CLICK_TO_GO_PREVIOUS_PAGE.get())}));
        pageLine.append(Lang.PAGE_NUMBER.get(page, maxPage));
        pageLine.color(ChatColor.WHITE);
        pageLine.bold(false);
        pageLine.event((ClickEvent)null);
        pageLine.event((HoverEvent)null);
        pageLine.append(">>");
        pageLine.color(ChatColor.GOLD);
        pageLine.bold(true);
        pageLine.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.commandManager.getName() + " help " + (page + 1)));
        pageLine.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(Lang.CLICK_TO_GO_NEXT_PAGE.get())}));
        pageLine.append("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u256f");
        pageLine.color(ChatColor.WHITE);
        pageLine.bold(false);
        pageLine.event((ClickEvent)null);
        pageLine.event((HoverEvent)null);
        p.spigot().sendMessage(pageLine.create());
    }
}

