/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.data;

public class PluginVersion {
    private final Integer major;
    private final Integer minor;
    private final Integer patch;

    public PluginVersion(Integer major, Integer minor, Integer patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public PluginVersion(String version) {
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        String[] split = version.split("\\.");
        this.major = Integer.parseInt(split[0]);
        this.minor = Integer.parseInt(split[1]);
        this.patch = Integer.parseInt(split[2]);
    }

    public boolean isOlderThan(PluginVersion version) {
        if (this.major < version.major) {
            return true;
        }
        if (this.major > version.major) {
            return false;
        }
        if (this.minor < version.minor) {
            return true;
        }
        if (this.minor > version.minor) {
            return false;
        }
        return this.patch < version.patch;
    }

    public String toString() {
        return "v" + this.major + "." + this.minor + "." + this.patch;
    }
}

