/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.data;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.leralix.lib.data.SoundData;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;

public class SoundStorage {
    private static final Map<SoundEnum, SoundData> soundMap = new EnumMap<SoundEnum, SoundData>(SoundEnum.class);

    private SoundStorage() {
        throw new IllegalStateException("Utility class");
    }

    public static void init() {
        ConfigurationSection soundsSection = ConfigUtil.getCustomConfig(ConfigTag.MAIN).getConfigurationSection("sounds");
        if (soundsSection != null) {
            for (String key : soundsSection.getKeys(false)) {
                List soundValues = soundsSection.getStringList(key);
                Sound soundName = Sound.valueOf((String)((String)soundValues.get(0)));
                int volume = Integer.parseInt((String)soundValues.get(1));
                float pitch = Float.parseFloat((String)soundValues.get(2));
                soundMap.put(SoundEnum.valueOf(key), new SoundData(soundName, volume, pitch));
            }
        }
    }

    public static SoundData getSoundData(SoundEnum soundName) {
        return soundMap.get((Object)soundName);
    }
}

